<?php
/**
 * Attribute Filter Widget
 *
 * @package  Azo
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Azo_Advanced_Filter' ) ) :

	/**
	 * Main Class
	 */
	class Azo_Advanced_Filter {
		/**
		 * Instance
		 *
		 * @var instance
		 */
		private static $instance;

		/**
		 * Get instance
		 *
		 * @return instance|Azo_Advanced_Filter
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'widgets_init', array( $this, 'add_widgets' ) );
		}

		/**
		 * Add widgets
		 */
		public function add_widgets() {
			if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
				return;
			}
			// Rating filter.
			require_once AZO_ADV_FILTER_PATH . 'inc/widgets/class-azo-widget-rating-filter.php';
			register_widget( 'Azo_Widget_Rating_Filter' );
			// Active filters.
			require_once AZO_ADV_FILTER_PATH . 'inc/widgets/class-azo-widget-active-filters.php';
			register_widget( 'Azo_Widget_Active_Filters' );
			// Attribute filter.
			require_once AZO_ADV_FILTER_PATH . 'inc/widgets/class-azo-widget-product-filter.php';
			register_widget( 'Azo_Widget_Product_Filter' );
		}
	}

	Azo_Advanced_Filter::get_instance();
endif;
