<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

defined( 'ABSPATH' ) || exit;

if ( empty( $related_products ) ) {
	return;
}

/**
* Remove related products output
*/
if ( true !== get_theme_mod( 'shop_single_related', false ) ) {
	return;
}
if ( ! class_exists( 'Kirki' ) ) {
	return;
}

?>
<div class="related products">
	<?php
	$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Recently viewed', 'azo' ) );

	if ( $heading ) {
		?>
		<div class="product-related-section">
			<h2 class="product-section-heading">
				<?php echo esc_html( $heading ); ?>
			</h2>

			<div class="related-slider-shop">
				<button class="azo-arrow arrows-prev"></button>
				<button class="azo-arrow arrows-next"></button>
			</div>
		</div>
	<?php } ?>

	<div class="products azo-related-slider">
		<?php
		foreach ( $related_products as $related_product ) {
			$post_object = get_post( $related_product->get_id() );
			setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

			get_template_part( 'template-parts/content', 'product' );
		}

		wp_reset_postdata();
		?>
	</div>
</div>
