<?php
/**
 * Display all product reviews
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/shop-reviews.php
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 4.3.0
 */

defined( 'ABSPATH' ) || exit;

$rating = get_shop_rating();

if ( 0 >= $rating->rating_count ) {
	return;
}

$current_page = 1;
$per_page     = get_shop_reviews_per_page();
$offset       = ( $current_page - 1 ) * $per_page;
$shop_reviews = get_shop_reviews( $offset, $per_page );
?>
<div class="azo-shop-reviews woocommerce-Reviews">
	<div class="shop-reviews-header">
		<div class="row">
			<div class="col-md-6 shop-reviews-header-left-col">
				<div class="shop-reviews--rating-average-wrap">
					<div class="shop-reviews--rating-average">
						<?php echo esc_html( $rating->rating_avg ); ?>
					</div>
					<div class="shop-reviews--info">
						<?php render_rating( $rating->rating_avg ); ?>
						<div class="shop-reviews-count">
							<?php echo esc_html( sprintf( _n( '%s Review', '%s Reviews', $rating->rating_count, 'azo' ), $rating->rating_count ) ); ?>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-6 shop-reviews-header-right-col">
				<div class="row">
					<div class="col-sm-6 col-xs-6  shop-reviews--meta-item">
						<div class="shop-reviews--meta-heading shop-reviews--average">
							<?php echo esc_html( $rating->rating_avg ); ?>
						</div>
						<div class="shop-reviews--meta-description shop-reviews--average-help">
							<?php echo esc_html( sprintf( __( '%1$s out of 5 star average rating', 'azo' ), $rating->rating_avg ) ); ?>
						</div>
					</div>
					<div class="col-sm-6 col-xs-6 shop-reviews--meta-item shop-reviews-5-star-info">
						<?php
						$total_5_star_percent = Azo_Helper::calculate_percentage( $rating->count_by_value['5'], $rating->rating_count );
						?>
						<div class="shop-reviews--meta-heading shop-reviews--5-stars-percent">
							<?php echo esc_html( sprintf( __( '%1$s%%', 'azo' ), $total_5_star_percent ) ); ?>
						</div>
						<div class="shop-reviews--meta-description shop-reviews--5-stars-percent-help">
							<?php echo esc_html( sprintf( __( '%1$s%% of reviews are 5 stars', 'azo' ), $total_5_star_percent ) ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="shop-reviews-form-filter-wrap">
			<h6 class="shop-reviews-form-filter-heading">
				<?php esc_html_e( 'Filter Reviews:', 'azo' ); ?>
			</h6>
			<form class="shop-reviews-form-filter" method="GET" action="">
				<div class="row-flex row-middle">
					<div class="col-grow">
						<div class="form-group">
							<label for="shop-reviews--ip-filter-content"
							       class="form-label"><?php esc_html_e( 'Search', 'azo' ); ?></label>
							<input type="text" id="shop-reviews--ip-filter-content" class="form-control form-input"
							       name="keyword"
							       placeholder="<?php esc_attr_e( 'Search reviews', 'azo' ); ?>">
						</div>
					</div>
					<div class="col-shrink">
						<div class="form-group">
							<label for="shop-reviews--ip-sorting"
							       class="form-label"><?php esc_html_e( 'Search', 'azo' ); ?></label>
							<?php
							$sort_options = [
								''               => __( 'Sort by', 'azo' ),
								'recent'         => __( 'Most Recent', 'azo' ),
								'highest-rating' => __( 'Highest Rating', 'azo' ),
								'lowest-rating'  => __( 'Lowest Rating', 'azo' ),
							];
							$sorted_by    = apply_filters( 'azo/shop_reviews/default_sorting', '' );
							?>
							<select class="form-control form-select" name="sorting" id="shop-reviews--ip-sorting">
								<?php foreach ( $sort_options as $value => $label ) : ?>
									<option <?php selected( $sorted_by, $value, true ); ?>
										value="<?php echo esc_attr( $value ); ?>"><?php echo esc_html( $label ); ?></option>
								<?php endforeach; ?>
							</select>
						</div>
					</div>
				</div>
				<div class="form-submit">
					<input type="hidden" name="action" value="azo_get_shop_reviews">
					<input type="hidden" name="current_page" value="1">
				</div>
			</form>
		</div>
	</div>

	<ol class="commentlist comment-list product-comment-list">
		<?php
		wp_list_comments(
			array(
				'style'       => 'ol',
				'callback'    => array( '\Azo\Woo\Shop_Reviews', 'output_shop_review_html' ),
				'short_ping'  => true,
				'avatar_size' => '60',
			),
			$shop_reviews
		);
		?>
	</ol>

	<div class="azo-shop-reviews-pagination azo-pagination pagination">
		<?php
		Azo_Templates::render_paginate_links(
			array(
				'format'  => '?current_page=%#%',
				'current' => $current_page,
				'total'   => ceil( $rating->rating_count / $per_page ),
			)
		);
		?>
	</div>
</div>
