<?php
/**
 * Review Comments Template
 *
 * Closing li is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

defined( 'ABSPATH' ) || exit;

$product_id = $comment->comment_post_ID;
$product    = new WC_Product( $product_id );
?>
<li itemprop="review" itemscope itemtype="https://schema.org/Review" <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	<div id="comment-<?php comment_ID(); ?>" class="comment_container">
		<div class="comment-meta-top">
			<?php woocommerce_review_display_rating(); ?>

			<time class="woocommerce-review__published-date comment-datetime" datetime="<?php echo get_comment_date( 'c' ); ?>">
				<?php printf( esc_html__( '%s at %s', 'azo' ), get_comment_date(), get_comment_time() ); ?>
			</time>
		</div>

		<div class="woo-comment-author">
			<?php
			/**
			 * The woocommerce_review_before hook
			 *
			 * @hooked woocommerce_review_display_gravatar - 10
			 */
			do_action( 'woocommerce_review_before', $comment );

			/**
			 * The woocommerce_review_meta hook.
			 *
			 * @hooked woocommerce_review_display_meta - 10
			 */
			do_action( 'woocommerce_review_meta', $comment );
			?>
		</div>

		<div class="woo-comment-content">
			<?php
			do_action( 'woocommerce_review_before_comment_text', $comment );
			do_action( 'woocommerce_review_comment_text', $comment );
			do_action( 'woocommerce_review_after_comment_text', $comment );
			?>

			<div class="comment-post-info">
				<div class="thumbnail">
					<a href="<?php echo esc_url( $product->get_permalink() ); ?>">
						<?php echo wp_kses_decode_entities( $product->get_image( 'thumbnail' ) ); ?>
					</a>
				</div>

				<h4 class="comment-post-title">
					<a href="<?php echo esc_url( $product->get_permalink() ); ?>">
						<?php echo esc_html( $product->get_name() ); ?>
					</a>
				</h4>
			</div>
		</div>
	</div>
