<?php
/**
 * Register the required plugins for this theme
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin, Gary Jones
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    https://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */

/*Include the TGM_Plugin_Activation class.*/
require_once AZO_DIR . 'tgm-plugin/class-tgm-plugin-activation.php';

/**
 * TGM_Plugin_Activation class constructor
 */
function azo_register_required_plugins() {
	$plugins = array(
		array(
			'name'   => esc_html__( 'Revolution Slider', 'azo' ),
			'slug'   => 'revolution-slider',
			'source' => AZO_DIR . 'inc/plugins/revolution.zip',
		),
		array(
			'name'     => esc_html__( 'Elementor', 'azo' ),
			'slug'     => 'elementor',
			'required' => true,
		),
		array(
			'name'   => esc_html__( 'Envato Market', 'azo' ),
			'slug'   => 'envato-market',
			'source' => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
		),
		array(
			'name'     => esc_html__( 'One Click Demo Import', 'azo' ),
			'slug'     => 'one-click-demo-import',
			'required' => true,
		),
		array(
			'name' => esc_html__( 'Boostify Header Footer Builder', 'azo' ),
			'slug' => 'boostify-header-footer-builder',
		),
		array(
			'name'     => esc_html__( 'Kirki', 'azo' ),
			'slug'     => 'kirki',
			'required' => true,
		),
		array(
			'name' => esc_html__( 'Woocommerce', 'azo' ),
			'slug' => 'woocommerce',
		),
		array(
			'name' => esc_html__( 'Variation Swatches for WooCommerce', 'azo' ),
			'slug' => 'woo-variation-swatches',
		),
		array(
			'name' => esc_html__( 'WPC Smart Wishlist for WooCommerce', 'azo' ),
			'slug' => 'woo-smart-wishlist',
		),
		array(
			'name' => esc_html__( 'WPC Smart Compare for WooCommerce', 'azo' ),
			'slug' => 'woo-smart-compare',
		),
		array(
			'name' => esc_html__( 'Contact Form 7', 'azo' ),
			'slug' => 'contact-form-7',
		),
		array(
			'name' => esc_html__( 'Advanced Custom Fields', 'azo' ),
			'slug' => 'advanced-custom-fields',
		),
		array(
			'name'    => esc_html__( 'Azo Plugin', 'azo' ),
			'slug'    => 'azo-plugin',
			'source'  => AZO_URI . 'inc/plugins/azo-plugin.zip',
			'version' => '1.0',
		),
		array(
			'name'    => esc_html__( 'Azo Advanced Filter', 'azo' ),
			'slug'    => 'azo-advanced-filter',
			'source'  => AZO_URI . 'inc/plugins/azo-advanced-filter.zip',
			'version' => '1.0',
		),
		array(
			'name'    => esc_html__( 'WPC Product Bundles for WooCommerce (Premium)', 'azo' ),
			'slug'    => 'woo-product-bundle-premium',
			'source'  => 'https://api.thememove.com/download/woo-product-bundle-premium-5.7.4-greGHtnqAH.zip',
			'version' => '5.7.4',
		),
		array(
			'name'    => esc_html__( 'WPC Frequently Bought Together for WooCommerce (Premium)', 'azo' ),
			'slug'    => 'woo-bought-together-premium',
			'source'  => 'https://api.thememove.com/download/woo-bought-together-premium-3.7.1-HTB1Kj1lhu.zip',
			'version' => '3.7.1',
		),
		array(
			'name' => esc_html__( 'Sales Countdown Timer', 'azo' ),
			'slug' => 'sales-countdown-timer',
		),
		array(
			'name' => esc_html__( 'Conditional Discounts for WooCommerce', 'azo' ),
			'slug' => 'woo-advanced-discounts',
		),
		array(
			'name' => esc_html__( 'DCO Comment Attachment', 'azo' ),
			'slug' => 'dco-comment-attachment',
		),
		array(
			'name' => esc_html__( 'Perfect Brands for WooCommerce', 'azo' ),
			'slug' => 'perfect-woocommerce-brands',
		),
		array(
			'name' => esc_html__( 'Dokan Lite', 'azo' ),
			'slug' => 'dokan-lite',
		),
	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'azo',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismisdozir'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismisdozir' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'azo_register_required_plugins' );
