<?php
/**
 * Single
 *
 * @package azo
 */

$sidebar = is_active_sidebar( 'blog-widget' ) ? get_theme_mod( 'blog_single_sidebar', 'right' ) : 'full';

$layout        = get_theme_mod( 'post_style', 'poststyle1' );
$layout_preset = isset( $_GET['post_preset'] ) ? Azo_Helper::data_clean( $_GET['post_preset'] ) : false;

if ( 'poststyle2' === $layout || 'preset2' === $layout_preset ) {
	?>
	<div class="hello-single">
		<div class="container">
			<div class="row row-new">
				<main id="main" class="col-md-12 col-lg-12">
					<?php
					if ( have_posts() ) {
						while ( have_posts() ) :
							the_post();
							get_template_part( 'template-parts/content', get_post_format() );
						endwhile;

						if ( false !== get_theme_mod( 'show_comment_post', true ) ) {
							if ( comments_open() || get_comments_number() ) {
								comments_template();
							}
						}
					} else {
						get_template_part( 'template-parts/content', 'none' );
					}
					?>
				</main>
			</div>
		</div>
	</div>
<?php } else { ?>
	<div class="hello-single">
		<div class="container">
			<div class="row row-new">
				<?php
				switch ( $sidebar ) :
					case 'left':
						get_sidebar();
						?>
						<main id="main" class="col-md-8 col-lg-8">
							<?php
							if ( have_posts() ) {
								while ( have_posts() ) :
									the_post();
									get_template_part( 'template-parts/content', get_post_format() );
								endwhile;

								if ( false !== get_theme_mod( 'show_comment_post', true ) ) {
									if ( comments_open() || get_comments_number() ) {
										comments_template();
									}
								}
							} else {
								get_template_part( 'template-parts/content', 'none' );
							}
							?>
						</main>
						<?php
						break;
					case 'right':
						?>
						<main id="main" class="col-md-8 col-lg-8">
							<?php
							if ( have_posts() ) {
								while ( have_posts() ) :
									the_post();
									get_template_part( 'template-parts/content', get_post_format() );
								endwhile;

								if ( false !== get_theme_mod( 'show_comment_post', true ) ) {
									if ( comments_open() || get_comments_number() ) {
										comments_template();
									}
								}
							} else {
								get_template_part( 'template-parts/content', 'none' );
							}
							?>
						</main>

						<?php
						get_sidebar();

						break;
					case 'full':
						?>
						<main id="main" class="col-md-12 col-lg-12">
							<?php
							if ( have_posts() ) {
								while ( have_posts() ) :
									the_post();
									get_template_part( 'template-parts/content', get_post_format() );
								endwhile;

								if ( false !== get_theme_mod( 'show_comment_post', true ) ) {
									if ( comments_open() || get_comments_number() ) {
										comments_template();
									}
								}
							} else {
								get_template_part( 'template-parts/content', 'none' );
							}
							?>
						</main>
						<?php
						break;
					endswitch;
				?>
			</div>
		</div>
	</div>
	<?php
}
