<?php
/**
 * Content Template
 *
 * @package azo
 */

$c_header    = azo_page_header_slug();
$layout      = get_theme_mod( 'post_style', 'poststyle1' );
$blog_preset = get_theme_mod( 'blog_preset', 'blog1' );

$layout_preset      = isset( $_GET['post_preset'] ) ? Azo_Helper::data_clean( $_GET['post_preset'] ) : false; //phpcs:ignore;
$blog_layout_preset = isset( $_GET['blog_preset'] ) ? Azo_Helper::data_clean( $_GET['blog_preset'] ) : false; //phpcs:ignore;

if ( ! is_single() ) {
	if ( ! $blog_layout_preset ) {
		azo_load_template( 'blog/preset', $blog_preset );
	}

	if ( $blog_layout_preset ) {
		switch ( $blog_layout_preset ) {
			case 'blog5':
				get_template_part( 'template-parts/blog/preset-blog5' );
				break;
			case 'blog1':
				get_template_part( 'template-parts/blog/preset-blog1' );
				break;
			case 'blog2':
				get_template_part( 'template-parts/blog/preset-blog2' );
				break;
			case 'blog3':
				get_template_part( 'template-parts/blog/preset-blog3' );
				break;
			case 'blog4':
				get_template_part( 'template-parts/blog/preset-blog4' );
				break;
		}
	}
}

if ( is_single() ) {
	if ( 'poststyle2' === $layout || 'preset2' === $layout_preset ) {
		get_template_part( 'template-parts/blog-single/preset2' );
	} elseif ( 'poststyle1' === $layout || 'preset1' === $layout_preset ) {
		get_template_part( 'template-parts/blog-single/preset1' );
	}
}
