<?php
/**
 * Blog Layout Preset Template
 *
 * @package azo
 */

$class = '';
if ( is_sticky() && is_home() && ! is_paged() ) {
	$class = 'sticky';
}
?>

<div class="blog-article blog-preset-4 <?php echo esc_attr( $class ); ?>" <?php azo_schema_markup( 'blog' ); ?>>
	<div class="item-blog entry-wrapper">
		<?php if ( has_post_thumbnail() && false !== get_theme_mod( 'image_blog', true ) ) { ?>
			<div class="entry-thumbnail">
				<?php azo_post_format(); ?>
			</div>
		<?php } ?>

		<div class="info-item-blog">
			<div class="info-blog-change">
				<span class="entry-meta blog-header-info">
					<?php if ( false !== azo_blog_categories() && false !== get_theme_mod( 'category_blog', true ) ) { ?>
						<span class="if-item if-cat">
							<?php echo wp_kses( azo_blog_categories(), azo_get_allowed_html() ); ?>
						</span>
					<?php } ?>
				</span>
			</div>

			<?php
			if ( is_sticky() && is_home() && ! is_paged() ) {
				echo '<span class="sticky-post"></span>';
			}

			the_title( '<h6 class="entry-title blog-entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h6>' );
			?>

			<div class="entry-content">
				<?php the_excerpt(); ?>
			</div>

			<?php if ( false !== get_theme_mod( 'button_readmore', true ) ) { ?>
				<div class="button-read-more">
					<a href="<?php the_permalink(); ?>" class="btnblog-readmore">
						<?php echo esc_html__( 'Continue Reading', 'azo' ); ?>
					</a>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
