<?php
/**
 * Blog Layout Preset Template
 *
 * @package azo
 */

$class = '';
if ( is_sticky() && is_home() && ! is_paged() ) {
	$class = 'sticky';
}
?>

<div class="ht-grid-item blog-preset-2 <?php echo esc_attr( $class ); ?>" itemscope="itemscope" itemtype="https://schema.org/Article">
	<div class="item-blog entry-wrapper">
		<?php if ( has_post_thumbnail() && false !== get_theme_mod( 'image_blog', true ) ) { ?>
			<div class="entry-thumbnail entry-image">
				<?php azo_post_format(); ?>
			</div>
		<?php } ?>

		<div class="info-blog-change">
			<span class="entry-meta blog-header-info">
				<?php if ( false !== azo_blog_categories() && false !== get_theme_mod( 'category_blog', true ) ) { ?>
					<span class="if-item if-cat">
						<?php echo wp_kses( azo_blog_categories(), azo_get_allowed_html() ); ?>
					</span>
				<?php } ?>
			</span>
		</div>

		<?php the_title( '<h6 class="entry-title blog-entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h6>' ); ?>

		<div class="entry-content" <?php azo_schema_markup( 'post_content' ); ?>>
			<?php the_excerpt(); ?>
		</div>
	</div>
</div>
