<?php
/**
 * Blog Single Template 2
 *
 * @package azo
 */

$layout = get_theme_mod( 'post_style', 'poststyle1' );

?>
<div class="blog-article hahaha <?php echo esc_attr( $layout ); ?>" <?php azo_schema_markup( 'blog' ); ?>>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php azo_schema_markup( 'blog_list' ); ?>>
		<div itemprop="mainEntityOfPage">
			<div class="blog-article-sum">
				<div class="container-poststyle2">
					<?php if ( has_post_thumbnail() && false !== get_theme_mod( 'image_blog_single', true ) ) { ?>
						<div class="entry-image">
							<?php azo_post_format(); ?>
						</div>
					<?php } ?>

					<div class="container-blog-post">
						<div class="blog-article-header">
							<?php azo_single_post_info(); ?>
						</div>

						<div class="entry-summary"><?php azo_seo_data(); ?></div>

						<div class="entry-content" <?php azo_schema_markup( 'post_content' ); ?>>
							<?php
							the_content();
							azo_wp_link_pages();
							?>
						</div>

						<div class="azo-ibox-footer">
							<div class="azo-entry-footer">
								<?php azo_blog_tags(); ?>
							</div>
						</div>
					</div>

					<footer class="entry-footer">
						<div class="related-box">
							<?php
								azo_post_related();
								azo_related_articles();
							?>
						</div>
					</footer>
				</div>
			</div>
		</div>
	</article>
</div>
