<?php
/**
 * Blog Single Template 1
 *
 * @package azo
 */

?>
<div class="blog-article" <?php azo_schema_markup( 'blog' ); ?>>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php azo_schema_markup( 'blog_list' ); ?>>
		<div itemprop="mainEntityOfPage">
			<div class="blog-article-sum">
				<?php if ( has_post_thumbnail() && false !== get_theme_mod( 'image_blog_single', true ) ) { ?>
					<div class="entry-image">
						<?php azo_post_format(); ?>
					</div>
				<?php } ?>

				<div class="container-blog-post">
					<div class="blog-article-header">
						<span class="entry-meta blog-header-info">
							<?php azo_single_post_info(); ?>
						</span>
					</div>

					<div class="entry-summary"><?php azo_seo_data(); ?></div>

					<div class="entry-content" <?php azo_schema_markup( 'post_content' ); ?>>
						<?php
							the_content();
							azo_wp_link_pages();
						?>
					</div>

					<div class="azo-entry-footer">
						<?php
						azo_blog_tags();
						azo_share_social();
						?>
					</div>
				</div>

				<footer class="entry-footer">
					<div class="related-box">
						<?php
							azo_post_related();
							azo_related_articles();
						?>
					</div>
				</footer>
			</div>
		</div>
	</article>
</div>
