<?php
/**
 * Archive
 *
 * @package azo
 */

$sidebar = is_active_sidebar( 'blog-widget' ) ? get_theme_mod( 'blog_sidebar', 'right' ) : 'right';
if ( ! is_active_sidebar( 'blog-widget' ) ) {
	$sidebar = get_theme_mod( 'blog_sidebar', 'full' );
}

$blog_preset        = get_theme_mod( 'blog_preset', 'blog1' );
$blog_layout_preset = isset( $_GET['blog_preset'] ) ? Azo_Helper::data_clean( $_GET['blog_preset'] ) : false; //phpcs:ignore;

if ( 'blog1' === $blog_layout_preset || 'blog1' === $blog_preset ) {
	$class = '';
} elseif ( 'blog2' === $blog_layout_preset || 'blog2' === $blog_preset ) {
	$class = 'wd-blog ht-grid ht-grid-2 ht-grid-tablet-2 ht-grid-mobile-1 widget-blog-post';
} elseif ( 'blog3' === $blog_layout_preset || 'blog3' === $blog_preset ) {
	$class = 'wd-blog ht-grid ht-grid-3 ht-grid-tablet-2 ht-grid-mobile-1 widget-blog-post';
} elseif ( 'blog4' === $blog_layout_preset || 'blog4' === $blog_preset ) {
	$class = '';
}
?>
<div class="hello-archive">
	<div class="container <?php echo esc_attr( $blog_preset ); ?>">
		<div class="row row-new">
			<?php
			switch ( $sidebar ) :
				case 'left':
					get_sidebar();
					?>
					<main id="main" class="col-md-8 col-lg-8 <?php echo esc_attr( $class ); ?>">
						<?php
						if ( have_posts() ) :
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', get_post_format() );
							endwhile;

							azo_paging();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</main>
					<?php
					break;
				case 'right':
					?>
					<main id="main" class="col-md-8 col-lg-8 <?php echo esc_attr( $class ); ?>">
						<?php
						if ( have_posts() ) :
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', get_post_format() );
							endwhile;

							azo_paging();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</main>

					<?php
					get_sidebar();
					break;
				case 'full':
					if ( '' !== $class ) {
						$sidebar = 'no-sidebar';
					}
					?>
					<main id="main" class="col-md-12 col-lg-12 <?php echo esc_attr( $sidebar ); ?> <?php echo esc_attr( $class ); ?>">
						<?php
						if ( have_posts() ) :
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', get_post_format() );
							endwhile;

							azo_paging();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</main>
					<?php
					break;
				endswitch;
			?>
		</div>
	</div>
</div>
