<?php
/**
 * 404
 *
 * @package azo
 */

$warning404 = get_theme_mod( 'warning404', 'Oops! Error 404' );
$oops       = get_theme_mod( 'not_found_oops', 'Page Not Found' );
$titlea     = get_theme_mod( 'not_found_title', "We can't seem to find the page you're looking for. Try to use the search." );
$subtitle   = get_theme_mod( 'not_found_subtitle', 'Or go to the home page to start over.' );
?>

<main id="main" class="site-main">
	<div class="not-found">
		<div class="container">
			<div class="row">
				<div class="col-md-1"></div>

				<div class="col-md-10">
					<div class="page-404-container">
						<?php if ( $warning404 ) { ?>
							<h1 class="warning404"><?php echo esc_html( $warning404 ); ?></h1>
						<?php } ?>

						<?php if ( $oops ) { ?>
							<h3 class="oops not-found-oops"><?php echo esc_html( $oops ); ?></h3>
						<?php } ?>

						<?php if ( $titlea ) { ?>
							<p class="title not-found-title"><?php echo esc_html( $titlea ); ?></p>
						<?php } ?>

						<?php get_search_form(); ?>

						<?php if ( $subtitle ) { ?>
							<p class="sub-title not-found-subtitle">
								<?php echo esc_html( $subtitle ); ?>
							</p>
						<?php } ?>

						<button href="<?php echo esc_url( home_url( '/' ) ); ?>" class="button-404">
							<?php esc_html_e( 'Go To Home Page', 'azo' ); ?>
						</button>
					</div>
				</div>


				<div class="col-md-1"></div>
			</div><!-- .row -->
		</div><!-- .container -->
	</div><!-- .not-found -->
</main>
