<?php
/**
 * Only search enable
 *
 * @package azo
 */

$post_type = 'product'; //phpcs:ignore

if ( isset( $post_type ) && locate_template( 'search-' . $post_type . '.php' ) && true == get_theme_mod( 'product_search', false ) ) { //phpcs:ignore
	get_template_part( 'search', $post_type );
	exit;
}

get_header();
$sidebar = is_active_sidebar( 'blog-widget' ) ? get_theme_mod( 'blog_sidebar', 'full' ) : 'full';
?>

<div class="hello-archive">
	<div class="container">
		<div class="row row-new">
			<?php
			switch ( $sidebar ) :
				case 'left':
					?>
					<?php get_sidebar(); ?>

					<main id="main" class="col-md-8 col-lg-8">
						<?php
						if ( have_posts() ) :
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', 'excerpt' );
							endwhile;
							azo_paging();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</main>
					<?php
					break;
				case 'right':
					?>
					<main id="main" class="col-md-8 col-lg-8">
						<?php
						if ( have_posts() ) :
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', 'excerpt' );
							endwhile;
							azo_paging();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</main>

					<?php get_sidebar(); ?>
					<?php
					break;
				case 'full':
					?>
					<main id="main" class="col-md-12 col-lg-12">
						<?php
						if ( have_posts() ) :
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', 'excerpt' );
							endwhile;
							azo_paging();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</main>
					<?php
					break;
				endswitch;
			?>
		</div>
	</div>
</div>
<?php
get_footer();
