<?php
/**
 * Page
 *
 * @package azo
 */

get_header();

$id = get_queried_object_id();

if ( azo_elementor_page( $id ) ) {
	$class = 'elementor-builder-hello';
} else {
	$class = 'no-builder-elementor';
}
?>
	<main id="main" class="page-content <?php echo esc_attr( $class ); ?>">
		<?php
		if ( have_posts() ) {
			while ( have_posts() ) {
				the_post();

				if ( azo_is_elementor() && azo_elementor_page( get_the_ID() ) ) {
					/*page build with Elementor*/
					get_template_part( 'template-parts/content', 'page' );
				} else {
					/*page without Elementor*/
					?>
					<div class="container">
						<?php
						get_template_part( 'template-parts/content', 'page' );

						if ( comments_open() || get_comments_number() ) {
							comments_template();
						}
						?>
					</div>
					<?php
				}
			}
		} else {
			?>
			<div class="container">
				<?php get_template_part( 'template-parts/content', 'none' ); ?>
			</div>
		<?php } ?>
	</main>
<?php
get_footer();
