<?php
/**
 * Azo Trust Badge
 *
 * @package  azo
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Trust_Badge' ) ) {
	/**
	 * Trust Badge
	 */
	class Trust_Badge {
		/**
		 * Instance Variable
		 *
		 * @var instance
		 */
		protected static $instance = null;

		/**
		 *  Initiator
		 */
		public static function instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Initialize
		 */
		public function initialize() {
			// Product data tabs.
			add_action( 'admin_head', [ $this, 'custom_panel_style' ] );
			add_filter( 'woocommerce_product_data_tabs', [ $this, 'add_product_data_tab' ], 10, 1 );
			add_action( 'woocommerce_product_data_panels', [ $this, 'add_product_data_panel' ] );
			add_action( 'woocommerce_process_product_meta', [ $this, 'save_product_meta' ] );
			add_action( 'woocommerce_single_product_summary', [ $this, 'show_trust_badge_image' ], 39 );
		}

		/**
		 * Custom panel style
		 */
		public function custom_panel_style() {
			?>
			<style>
				#woocommerce-product-data ul.wc-tabs li.azo_trust_badge_options a:before {
					font-family: WooCommerce;
					content: '\e00c';
				}
			</style>
			<?php
		}

		/**
		 * Add product data tab
		 *
		 * @param [type] $tabs type.
		 */
		public function add_product_data_tab( $tabs ) {
			$tabs['azo_trust_badge'] = array(
				'label'  => esc_html__( 'Trust Badge', 'azo' ),
				'target' => 'azo_trust_badge_settings',
			);

			return $tabs;
		}

		/**
		 * Add product data panel
		 */
		public function add_product_data_panel() {
			global $post;
			$post_id = $post->ID;
			?>
			<div id="azo_trust_badge_settings" class="panel woocommerce_options_panel">
				<div class="options_group">
					<?php
					woocommerce_wp_select(
						array(
							'id'       => '_show_trust_badge',
							'label'    => esc_html__( 'Trust Badge', 'azo' ),
							'desc_tip' => esc_html__( 'Show trust badge image below Add To Cart button.', 'azo' ),
							'options'  => array(
								''  => esc_html__( 'Default', 'azo' ),
								'0' => esc_html__( 'Hide', 'azo' ),
								'1' => esc_html__( 'Show', 'azo' ),
							),
						)
					);
					?>
				</div>
			</div>
			<?php
		}

		/**
		 * Save product meta
		 *
		 * @param  [type] $post_id type.
		 */
		public function save_product_meta( $post_id ) {
			if ( isset( $_POST['_show_trust_badge'] ) ) {
				update_post_meta( $post_id, '_show_trust_badge', sanitize_text_field( $_POST['_show_trust_badge'] ) );
			}
		}

		/**
		 * Show trust badge image
		 */
		public function show_trust_badge_image() {
			global $product;

			$enable = get_post_meta( $product->get_id(), '_show_trust_badge', true );

			if ( '' === $enable ) {
				$enable = get_theme_mod( 'single_product_trust_badge_enable' );
			}

			if ( '0' === $enable || ! class_exists( 'kirki' ) ) {
				return;
			}

			$trust_badge_image = get_theme_mod( 'single_product_trust_badge_image' );

			if ( false === $trust_badge_image ) {
				$trust_badge_image = AZO_URI . 'images/woocommerce/product-trust-badge.png';
			}

			?>
			<div class="azo-product-trust-badge">
				<img src="<?php echo esc_url( $trust_badge_image ); ?>" alt="<?php esc_attr_e( 'Trust Badge', 'azo' ); ?>">
			</div>
			<?php
		}
	}

	Trust_Badge::instance()->initialize();
}
