<?php
/**
 * Azo Single_Product
 *
 * @package  azo
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Single_Product' ) ) {

	/**
	 * Single Product
	 */
	class Single_Product {
		/**
		 * Instance Variable
		 *
		 * @var instance
		 */
		protected static $instance = null;

		/**
		 *  Initiator
		 */
		public static function instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Initialize
		 */
		public function initialize() {
			add_filter( 'woocommerce_product_tabs', [ $this, 'move_reviews_out_of_tabs' ] );

			add_action( 'woocommerce_after_single_product', [ $this, 'add_bottom_tabs' ], 30 );

			add_filter( 'azo/product/bottom_tabs', [ $this, 'add_default_bottom_tabs' ] );
			add_filter( 'azo/product/bottom_tabs', 'woocommerce_sort_product_tabs', 99 );

			//add_filter( 'comment_form_submit_button', array( $this, 'add_attachment_button' ) );

			// Action on attachment field.
			add_filter( 'dco_ca_form_element_label', array( $this, 'remove_text_comment_form_attachment' ) );
			add_filter( 'dco_ca_form_element_upload_size', array( $this, 'remove_text_comment_form_attachment' ) );
			add_filter( 'dco_ca_form_element_file_types', array( $this, 'remove_text_comment_form_attachment' ) );
			add_filter( 'dco_ca_form_element_autoembed_links', array( $this, 'remove_text_comment_form_attachment' ) );
			add_filter( 'dco_ca_attachment_field', array( $this, 'remove_attachment_field' ) );
		}

		/**
		 * Move review of tabs
		 *
		 * @see woocommerce_default_product_tabs()
		 *
		 * @param $tabs
		 *
		 * @return array $tabs
		 */
		public function move_reviews_out_of_tabs( $tabs ) {
			unset( $tabs['reviews'] );

			return $tabs;
		}

		public function add_bottom_tabs() {
			wc_get_template( 'single-product/tabs/bottom-tabs.php' );
		}

		public function output_product_data_tabs_as_toggles() {
			wc_get_template( 'single-product/tabs/toggles.php' );
		}

		public function add_default_bottom_tabs( $tabs = array() ) {
			global $product;

			if ( comments_open() ) {
				$tabs['reviews'] = array(
					'title'    => __( 'Reviews', 'azo' ),
					'priority' => 10,
					'callback' => 'comments_template',
				);

				$tabs['questions'] = array(
					'title'    => __( 'Questions', 'azo' ),
					'priority' => 20,
					'callback' => array( $this, 'product_question' ),
				);
			}

			return $tabs;
		}

		public function product_question() {
			wc_get_template( 'single-product-questions.php' );
		}

		// Keep button only on comment form attachment.
		public function remove_text_comment_form_attachment( $output ) {
			$output = '';
			return $output;
		}

		// Remove Attachment field on single post.
		public function remove_attachment_field( $output ) {
			if ( 'product' != get_post_type() ) {
				return '';
			}

			return $output;
		}

		// Add a attachment button next to submit button.
		public function add_attachment_button( $submit_button ) {
			$button  = '<button type="button" class="comment-form__attachment-button attachment-button">';
			$button .= '<span class="button-icon svg-icon"><i class="fa fa-camera-retro"></i></span>';
			$button .= '<span class="button-text">' . esc_html__( 'Add Photos', 'azo' ) . '</span>';
			$button .= '</button>';

			return $button . $submit_button;
		}
	}

	Single_Product::instance()->initialize();
}
