/**
 * Elementor preview
 *
 * @package azo
 */

'use strict';

// Elementor not print a 'product' class for product item. We add this. Please fix it.
var azoHandle = function() {
	var products = document.querySelectorAll( '.azo-product-slider > li' );
	if ( ! products.length ) {
		return;
	}

	products.forEach(
		function( el ) {
			if ( el.classList.contains( 'product' ) ) {
				return;
			}

			el.classList.add( 'product' );
		}
	);
}

// Carousel widget.
var azoCarousel = function( selector ) {
	var element = document.querySelectorAll( selector );

	if ( ! element.length ) {
		return;
	}

	for ( var i = 0, j = element.length; i < j; i++ ) {

		if ( element[i].classList.contains( 'tns-slider' ) ) {
			continue;
		}

		var options = JSON.parse( element[i].getAttribute( 'data-tiny-slider' ) );

		options.container = element[i];

		var slider = tns( options );
	}
}

// Slider widget.
var azoSlider = function() {
	var sliderWidget = document.getElementsByClassName( 'azo-slider-widget' );

	if ( ! sliderWidget.length ) {
		return;
	}

	for ( var i = 0, j = sliderWidget.length; i < j; i++ ) {
		// Ignore if slider initialized.
		if ( sliderWidget[i].classList.contains( 'tns-slider' ) ) {
			continue;
		}

		// Get slider options.
		var options = JSON.parse( sliderWidget[i].getAttribute( 'data-tiny-slider' ) );

		options.container = sliderWidget[i];

		// Animated class.
		var animated = 'animated';

		// Callback to be run on initialization.
		options.onInit = function( info ) {
			var startAnimate      = info.slideItems[info.index].getAttribute( 'data-animate' ),
				startSlideContent = info.slideItems[info.index].querySelector( '.azo-slide-container' );

			// Add the first animation.
			startSlideContent.classList.add( startAnimate, animated );
		}

		// Slider init.
		var slider = tns( options );

		// Bind function to event.
		slider.events.on(
			'transitionEnd',
			function( info, event ) {
				for ( var x = 0, y = info.slideItems.length; x < y; x++ ) {
					// Select slide content.
					var slideContent = info.slideItems[x].querySelector( '.azo-slide-container' );

					// Remove all animation available.
					slideContent.classList.remove( 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble', 'jello', 'heartBeat', 'zoomIn', 'fadeIn', 'flipInX', 'flipInY', 'lightSpeedIn', 'fadeInLeft', 'fadeInRight', 'fadeInUp', 'fadeInDown', 'animated' );
				}

				// Select current slide.
				var currentSlide    = info.slideItems[info.index],
					getSlideAnimate = currentSlide.getAttribute( 'data-animate' ),
					getSlideContent = currentSlide.querySelector( '.azo-slide-container' );

				// Add current slide animation.
				getSlideContent.classList.add( getSlideAnimate, animated );
			}
		);
	}
}

// Countdown widget.
var azoCountdown = function() {
	var el = document.querySelectorAll( '.azo-countdown-widget' );
	if ( ! el.length ) {
		return;
	}

	for ( var i = 0, j = el.length; i < j; i++ ) {
		var date  = el[i].getAttribute( 'data-date' ),
			days  = el[i].querySelector( '.azo-countdown-days' ).id,
			hours = el[i].querySelector( '.azo-countdown-hours' ).id,
			mins  = el[i].querySelector( '.azo-countdown-mins' ).id,
			secs  = el[i].querySelector( '.azo-countdown-seconds' ).id;

		var counter = WoostifyCountdown(
			{
				targetDate: date,
				ids: {
					days: days,
					hours: hours,
					mins: mins,
					secs: secs,
				}
			}
		);

		counter.setup();
	}
}

// DOM loaded.
document.addEventListener(
	'DOMContentLoaded',
	function() {
		// For preview mode.
		if ( 'function' === typeof( onElementorLoaded ) ) {
			onElementorLoaded(
				function() {
					window.elementorFrontend.hooks.addAction(
						'frontend/element_ready/global',
						function() {
							azoCarousel( '.azo-post-slider' );
							azoCarousel( '.azo-product-slider' );
							azoHandle();
							azoSlider();
							azoCountdown();

							// Countdown with real time.
							if ( 'function' === typeof( azoCountdownUrgency ) ) {
								azoCountdownUrgency();
							}

							// Variation swatches.
							if ( 'function' === typeof( azoVariationSwatches ) ) {
								azoVariationSwatches();
							}

							// Swatch list.
							if ( 'function' === typeof( azoSwatchList ) ) {
								azoSwatchList();
							}

							// Quick view.
							if ( 'function' === typeof( azoQuickView ) ) {
								azoQuickView();
							}
						}
					);

					// Product tabs.
					window.elementorFrontend.hooks.addAction(
						'frontend/element_ready/azo-products-tabs.default',
						function() {
							if ( 'function' === typeof( azoInitSliderFirstTab ) ) {
								azoInitSliderFirstTab();
							}

							if ( 'function' === typeof( azoProductTab ) ) {
								azoProductTab();
							}
						}
					);
				}
			);
		}

		// For frontend.
		window.addEventListener(
			'load',
			function() {
				azoCarousel( '.azo-post-slider' );
				azoCarousel( '.azo-product-slider' );
				azoSlider();

				// Countdown with real time.
				if ( 'function' === typeof( azoCountdownUrgency ) ) {
					setTimeout(
						function() {
							azoCountdownUrgency();
						},
						1000
					);
				}
			}
		);

		azoCountdown();
	}
);
