<?php

namespace azo;

defined( 'ABSPATH' ) || exit;

/**
 * Comments
 */
class Comments extends \WC_Comments {
	protected static $instance = null;

	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function initialize() {
		add_filter( 'preprocess_comment', [ $this, 'check_comment_title' ], 0 );

		add_action( 'comment_post', [ $this, 'add_comment_title' ] );

		add_action( 'woocommerce_review_before_comment_text', [ $this, 'add_comment_title_html' ] );
	}

	public function check_comment_title( $comment_data ) {
		// If posting a comment (not trackback etc) and not logged in.
		if ( ! is_admin() && isset( $_POST['comment_post_ID'], $_POST['title'], $comment_data['comment_type'] ) && 'product' === get_post_type( absint( $_POST['comment_post_ID'] ) ) && empty( $_POST['comment_title'] ) ) { // WPCS: input var ok, CSRF ok.
			wp_die( esc_html__( 'Please add review title.', 'azo' ) );
			exit;
		}

		return $comment_data;
	}

	/**
	 * Title field for comments.
	 *
	 * @param int $comment_id Comment ID.
	 */
	public function add_comment_title( $comment_id ) {
		if ( ! empty( $_POST['comment_title'] ) && isset( $_POST['comment_post_ID'] ) && 'product' === get_post_type( absint( $_POST['comment_post_ID'] ) ) ) { // WPCS: input var ok, CSRF ok.
			add_comment_meta( $comment_id, 'comment_title', wp_kses( $_POST['comment_title'], azo_get_allowed_html() ), true ); // WPCS: input var ok, CSRF ok.
		}
	}

	/**
	 * @param \WP_Comment $comment
	 */
	public function add_comment_title_html( $comment ) {
		$comment_title = get_comment_meta( $comment->comment_ID, 'comment_title', true );

		if ( empty( $comment_title ) ) {
			return;
		}
		?>
		<h6 class="woocommerce-review__title"><?php echo esc_html( $comment_title ); ?></h6>
		<?php
	}
}

Comments::instance()->initialize();
