/**
 * Teammenber direction aware js
 *
 * @package azo
 */

'use strict';

(function ($) {
	var AzoTeamMember = function AzoTeamMember($scope, $) {
		var slide = $scope.find('.js-teammember-slider'),
		    showdot = slide.attr('data-dot'),
		    show = $scope.find('.teammember-slider-wrapper').attr('data-show') || 2,
		    showtablet = $scope.find('.teammember-slider-wrapper').attr('data-show-tablet') || show,
		    showmobile = $scope.find('.teammember-slider-wrapper').attr('data-show-mobile') || show,
		    autoplay = '1' == $('.teammember-slider-wrapper').data('autoplay') ? true : false;

		if (slide.attr('data-dot') === 'yes') {
			showdot = true;
		} else {
			showdot = false;
		}

		$(slide).slick({
			dots: showdot,
			arrows: false,
			infinite: true,
			speed: 1000,
			centerMode: true,
			centerPadding: '0px',
			autoplay: autoplay,
			autoplaySpeed: 3000,
			slidesToShow: show,
			slidesToScroll: 1,
			appendDots: $scope.find(".teammember-slider-dots"),
			customPaging: function customPaging(slider, i) {
				return '<span class="dots-bullet"></span>';
			},
			responsive: [{
				breakpoint: 1622,
				settings: { slidesToShow: show }
			}, {
				breakpoint: 1025,
				settings: { slidesToShow: showtablet }
			}, {
				breakpoint: 768,
				settings: { slidesToShow: showmobile }
			}]
		});

		$('.teammember-slider-wrapper .arrows-prev').click(function () {
			$(slide).slick('slickPrev');
		});

		$('.teammember-slider-wrapper .arrows-next').click(function () {
			$(slide).slick('slickNext');
		});
	};

	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/azo-team-member.default', AzoTeamMember);
	});
})(jQuery);