/**
 * Tab Content js
 *
 * @package azo
 */

'use strict';

(function ($) {
	/**
  * Widget Tab Content Slider Handler
  *
  * @param $scope The widget wrapper element as a jQuery element
  * @param $ The jQuery alias
  */
	var WidgetTabContentHandler = function WidgetTabContentHandler() {
		$('.tab-content-area .tab-content-item:first-child').addClass('current');
		$('ul.nav-tabs li:first-child').addClass('current');
		$('ul.nav-tabs li').click(function () {
			var tab_id = $(this).attr('data-select');
			$('ul.nav-tabs li').removeClass('current');
			$('.tab-content-item').removeClass('current');

			$(this).addClass('current');
			$("#" + tab_id).addClass('current');
		});
	};

	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/azo-tab-content.default', WidgetTabContentHandler);
	});
})(jQuery);