/**
 * Category slider js
 *
 * @package azo
 */

'use strict';

(function ($) {
	var AzoCategorySlider = function AzoCategorySlider($scope, $) {
		var slide = $scope.find('.js-category-slideshow'),
		    showdot = slide.attr('data-dot'),
		    show = $scope.find('.images-slider-wrapper').attr('data-show') || 1,
		    showtablet = $scope.find('.images-slider-wrapper').attr('data-show-tablet') || show,
		    showmobile = $scope.find('.images-slider-wrapper').attr('data-show-mobile') || show;

		if (slide.attr('data-dot') === 'yes') {
			showdot = true;
		} else {
			showdot = false;
		}

		$(slide).slick({
			dots: showdot,
			arrows: false,
			slidesToScroll: 1,
			autoplay: true,
			autoplaySpeed: 3000,
			slidesToShow: show,
			appendDots: $scope.find(".category-slider-dots"),
			customPaging: function customPaging(slider, i) {
				return '<span class="dots-bullet"></span>';
			},
			responsive: [{
				breakpoint: 1622,
				settings: {
					slidesToShow: show,
					slidesToScroll: 1
				}
			}, {
				breakpoint: 1170,
				settings: {
					slidesToShow: showtablet,
					slidesToScroll: 1
				}
			}, {
				breakpoint: 480,
				settings: {
					slidesToShow: showmobile,
					slidesToScroll: 1
				}
			}]
		});

		$('.images-slider-wrapper .arrows-prev').click(function () {
			$(slide).slick('slickPrev');
		});

		$('.images-slider-wrapper .arrows-next').click(function () {
			$(slide).slick('slickNext');
		});
	};

	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/azo-category-slider.default', AzoCategorySlider);
	});
})(jQuery);