/**
 * Product Slider JS
 *
 * @package azo
 */

'use strict';

(function ($) {

	/**
  * Product Slider
  *
  * @param $scope The widget wrapper element as a jQuery element
  * @param $ The jQuery alias
  */
	var WidgetProductSlider = function WidgetProductSlider($scope, $) {
		/**
   * Slider JS
   */
		var slide = $scope.find('.js-products-slider1'),
		    slide2 = $scope.find('.js-products-slider2'),
		    slide3 = $scope.find('.js-products-slider3'),
		    show = $scope.find('.product-js-products-slider').attr('data-show') || 1,
		    showtablet = $scope.find('.product-js-products-slider').attr('data-show-tablet') || 2,
		    showmobile = $scope.find('.product-js-products-slider').attr('data-show-mobile') || 1,
		    rows = $scope.find('.product-js-products-slider').attr('data-rows') || 1;

		$(slide).on('init', function (event, slick) {
			quick_view_ajax();
		});

		$(slide).slick({
			dots: true,
			arrows: true,
			prevArrow: $('.arrows-prev1'),
			nextArrow: $('.arrows-next1'),
			rows: rows,
			adaptiveHeight: true,
			infinite: true,
			centerMode: true,
			centerPadding: '0px',
			slidesToShow: show,
			slidesToScroll: 1,
			autoplay: true,
			autoplaySpeed: 3000,
			appendDots: $scope.find('.product-slider-dots'),
			focusOnSelect: true,
			customPaging: function customPaging(slider, i) {
				return '<span class="dots-bullet"></span>';
			},
			responsive: [{
				breakpoint: 1622,
				settings: { slidesToShow: show }
			}, {
				breakpoint: 960,
				settings: { slidesToShow: showtablet }
			}, {
				breakpoint: 600,
				settings: { slidesToShow: showmobile }
			}]
		});

		$(slide2).on('init', function (event, slick) {
			quick_view_ajax();
		});

		$(slide2).slick({
			dots: true,
			arrows: true,
			prevArrow: $('.arrows-prev2'),
			nextArrow: $('.arrows-next2'),
			rows: rows,
			adaptiveHeight: true,
			infinite: true,
			centerMode: true,
			centerPadding: '0px',
			slidesToShow: show,
			slidesToScroll: 1,
			autoplay: true,
			autoplaySpeed: 3000,
			appendDots: $scope.find('.product-slider-dots'),
			focusOnSelect: true,
			customPaging: function customPaging(slider, i) {
				return '<span class="dots-bullet"></span>';
			},
			responsive: [{
				breakpoint: 1622,
				settings: { slidesToShow: show }
			}, {
				breakpoint: 960,
				settings: { slidesToShow: showtablet }
			}, {
				breakpoint: 600,
				settings: { slidesToShow: showmobile }
			}]
		});

		$(slide3).on('init', function (event, slick) {
			quick_view_ajax();
		});

		$(slide3).slick({
			dots: true,
			arrows: true,
			prevArrow: $('.arrows-prev3'),
			nextArrow: $('.arrows-next3'),
			rows: rows,
			adaptiveHeight: true,
			infinite: true,
			centerMode: true,
			centerPadding: '0px',
			slidesToShow: show,
			slidesToScroll: 1,
			autoplay: true,
			autoplaySpeed: 3000,
			appendDots: $scope.find('.product-slider-dots'),
			focusOnSelect: true,
			customPaging: function customPaging(slider, i) {
				return '<span class="dots-bullet"></span>';
			},
			responsive: [{
				breakpoint: 1622,
				settings: { slidesToShow: show }
			}, {
				breakpoint: 960,
				settings: { slidesToShow: showtablet }
			}, {
				breakpoint: 600,
				settings: { slidesToShow: showmobile }
			}]
		});
	};

	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/azo-product-slider.default', WidgetProductSlider);
	});
})(jQuery);