<?php
// @codingStandardsIgnoreStart

/*DISABLE ALL STYLESHEETS*/
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

if ( ! function_exists( 'azo_wishlist_page_url' ) ) {
	/**
	 * Get TI wishlist page url
	 */
	function azo_wishlist_page_url() {
		if ( ! defined( 'TINVWL_FVERSION' ) ) {
			return '#';
		}

		if ( class_exists( 'TINVWL_FVERSION' ) ) {
			$shortcode = '[ti_wishlistsview]';
		}

		global $wpdb;
		$id = $wpdb->get_results( $wpdb->prepare( 'SELECT ID FROM ' . $wpdb->prefix . 'posts WHERE post_content LIKE "%' . $shortcode . '%" AND post_parent = 0' ) );

		if ( $id ) {
			$id  = intval( $id[0]->ID );
			$url = get_the_permalink( $id );

			return $url;
		}

		return '#';
	}
}

/*ICON HEADER MENU*/
if ( ! function_exists( 'azo_wc_header_action' ) ) {
	function azo_wc_header_action() {
		global $woocommerce;
		$count = $woocommerce->cart->cart_contents_count;

		echo wp_kses( azo_wishlist(), azo_get_allowed_html() );
		?>
		<div class="menu-woo-cart">
			<a href="<?php echo wc_get_cart_url(); ?>" class="js-cart-button">
				<?php azo_get_svg( 'cart' ); ?>
				<span class="shop-cart-count"><?php echo esc_html( $count ); ?></span>
			</a>
		</div>
		<?php
	}
}

if ( ! function_exists( 'azo_wishlist' ) ) {
	function azo_wishlist() {
		if ( class_exists( 'WPCleverWoosw' ) ) {
			?>
			<div class="site-header-wishlist">
				<a class="header-wishlist" href="<?php echo esc_url( WPCleverWoosw::get_url() ); ?>">
					<?php azo_get_svg( 'heart' ); ?>
					<span class="count-wishlist"><?php echo esc_html( WPCleverWoosw::get_count() ); ?></span>
				</a>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'azo_wc_header_login' ) ) {
	function azo_wc_header_login() {
		?>
		<a href="<?php echo esc_url( home_url( '/my-account/' ) ); ?>" class="menu-profile-azo">
			<?php azo_get_svg( 'user' ); ?>
		</a>
		<?php
	}
}

/*REMOVE BREADCRUMBS*/
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );

/*CONTENT WRAPPER*/
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10, 0 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10, 0 );

add_action( 'azo_product_search_shop_content_start', 'azo_shop_open_tag' );
add_action( 'woocommerce_before_main_content', 'azo_shop_open_tag', 5 );
if ( ! function_exists( 'azo_shop_open_tag' ) ) {
	function azo_shop_open_tag() {
		$shop_sidebar = ! is_active_sidebar( 'shop-widget' ) ? 'full' : get_theme_mod( 'shop_sidebar', 'full' );
		$shop_class   = '';

		$shop_class .= is_product() ? 'with-full-sidebar' : 'with-' . $shop_sidebar . '-sidebar';
		if ( get_theme_mod( 'flexible_sidebar' ) ) {
			$shop_class .= ' has-flexible-sidebar';
		}
		if ( get_theme_mod( 'filter_area' ) ) {
			$shop_class .= ' has-filter-area';
		}

		$shop_layout_preset = isset( $_GET['shop_sidebar_preset'] ) ? Azo_Helper::data_clean( $_GET['shop_sidebar_preset'] ) : false;
		if ( 'nosidebar' === $shop_layout_preset ) {
			$shop_class = 'with-full-sidebar';
		}
		?>
		<div class="shop-container <?php echo esc_attr( $shop_class ); ?>">
			<div class="container">
				<div class="content-shop-archive">
					<div class="shop-content">
					<?php
					if ( get_theme_mod( 'flexible_sidebar' ) && 'full' !== $shop_sidebar && ! is_product() ) :
					?>
						<div class="sidebar-overlay"></div>
						<a href="#" class="sidebar-toggle js-sidebar-toggle">
							<span class="screen-reader-text"><?php esc_html_e( 'Toggle Shop Sidebar', 'azo' ); ?></span>
							<i class="ion-android-options toggle-icon"></i>
						</a>
					<?php
					endif;
	}
}

add_action( 'woocommerce_after_main_content', 'azo_shop_close_tag', 50 );
if ( ! function_exists( 'azo_shop_close_tag' ) ) {
	function azo_shop_close_tag() {
		?>
		</div>
		<?php
		if ( ! is_singular( 'product' ) ) {
			do_action( 'woocommerce_sidebar' );
		}
		?>
		</div>
		</div>
		</div>
		<?php
	}
}

/*REMOVE SHOP TITLE*/
add_filter( 'woocommerce_show_page_title', 'azo_remove_shop_title' );
if ( ! function_exists( 'azo_remove_shop_title' ) ) {
	function azo_remove_shop_title() {
		return false;
	}
}

/*TOTAL CART ITEM - AJAX UPDATE*/
add_filter( 'woocommerce_add_to_cart_fragments', 'azo_cart_item' );
if ( ! function_exists( 'azo_cart_item' ) ) {
	function azo_cart_item( $fragments ) {
		global $woocommerce;
		$total = $woocommerce->cart->cart_contents_count;

		ob_start();
		?>
		<span class="shop-cart-count"><?php echo esc_html( $total ); ?></span>
		<?php

		$fragments['span.shop-cart-count'] = ob_get_clean();

		return $fragments;
	}
}

/*CART LIST ITEM - AJAX UPDATE*/
add_filter( 'woocommerce_add_to_cart_fragments', 'azo_cart_list' );
if ( ! function_exists( 'azo_cart_list' ) ) {
	function azo_cart_list( $fragments ) {
		global $woocommerce;
		$total_item = $woocommerce->cart->cart_contents_count;

		ob_start();
		?>
		<div class="cart-sidebar-content">
			<?php woocommerce_mini_cart(); ?>
		</div>
		<?php

		$fragments['div.cart-sidebar-content'] = ob_get_clean();

		return $fragments;
	}
}

/*MODIFY SEARCH WIDGET*/
add_filter( 'get_product_search_form', 'azo_product_search_form_widget' );
if ( ! function_exists( 'azo_product_search_form_widget' ) ) {
	function azo_product_search_form_widget( $form ) {
		$form = '<form role="search" method="get" class="search-form" action="' . esc_url( get_permalink( wc_get_page_id( 'shop' ) ) ) . '" >';
		$form .= '<label class="screen-reader-text">' . esc_html__( 'Search for:', 'azo' ) . '</label>';
		$form .= '<input type="text" class="search-field" placeholder="' . esc_attr__( 'Search....', 'azo' ) . '" value="' . get_search_query() . '" name="s" autocomplete="off" required/>';
		$form .= '<button type="submit" class="search-submit icoros-icon_search"></button>';
		$form .= '</form>';

		return $form;
	}
}

/*ADD CUSTOM CLASS IN SINGLE PRODUCT*/
add_filter( 'post_class', 'azo_single_product_cls', 10, 3 );
if ( ! function_exists( 'azo_single_product_cls' ) ) {
	function azo_single_product_cls( $classes, $class, $post_id ) {
		if ( is_singular( 'product' ) ) {
			global $product;
			if ( ! $product ) {
				return $classes;
			}

			if ( ! empty( $gallery_id ) ) {
				$classes[] = 'this-product-has-gallery-image';
			}
		}

		return $classes;
	}
}

/*CHECK PRODUCT ALREADY IN CART*/
if ( ! function_exists( 'azo_product_check_in' ) ) :
	function azo_product_check_in( $pid = null, $in_cart = true, $qty_in_cart = false ) {
		global $woocommerce;
		$_cart    = $woocommerce->cart->get_cart();
		$_product = wc_get_product( $pid );
		$variable = $_product->is_type( 'variable' );

		if ( true == $in_cart ) {
			foreach ( $_cart as $key ) {
				$product_id = $key['product_id'];

				if ( $product_id == $pid ) {
					return true;
				}
			}

			return false;
		}

		if ( true == $qty_in_cart ) {
			if ( $variable ) {
				$arr = array();
				foreach ( $_cart as $key ) {
					if ( $key['product_id'] == $pid ) {
						$qty   = $key['quantity'];
						$arr[] = $qty;
					}
				}

				return array_sum( $arr );
			} else {
				foreach ( $_cart as $key ) {
					if ( $key['product_id'] == $pid ) {
						$qty = $key['quantity'];

						return $qty;
					}
				}
			}

			return 0;
		}
	}
endif;

/*PRODUCT ACTION*/
if ( ! function_exists( 'azo_product_action' ) ) :
	function azo_product_action() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return;
		}
		global $woocommerce;
		$total = $woocommerce->cart->cart_contents_count;
		$count = $woocommerce->cart->cart_contents_count;

		$content_sidebar_cart = get_theme_mod( 'content_sidebar_cart' );
		$allowed_html         = azo_shape_space_allowed_html();

		if ( ! $content_sidebar_cart ) {
			$content_sidebar_cart = 'Free shipping on all orders over $75';
		}
		?>
		<div id="shop-quick-view" data-view_id='0'>
			<div class="quickview-block">
				<button class="quick-view-close-btn ion-ios-close-empty"></button>
				<div class="quick-view-content"></div>
			</div>
		</div>

		<div id="shop-cart-sidebar">
			<div class="cart-sidebar-head">
				<h4 class="cart-sidebar-title"><?php esc_html_e( 'Your Cart', 'azo' ); ?></h4>

				<div class="menu-woo-cart">
					<div class="icoros-icon_shopping_cart">
						<span class="shop-cart-count"><?php echo esc_html( $count ); ?></span>
					</div>
				</div>

				<button id="close-cart-sidebar" class="icoros-icon_Close"></button>
			</div>

			<div class="cart-sidebar-content">
				<?php woocommerce_mini_cart(); ?>
			</div>

			<div class="cart-sidebar-after-cart">
				<span class="shipping-cart">
					<?php echo wp_kses( $content_sidebar_cart, $allowed_html ); ?>
				</span>
			</div>
		</div>

		<div id="shop-overlay"></div>
		<?php
	}
endif;

/*PRODUCT LABEL*/
if ( ! function_exists( 'azo_product_label' ) ) {
	/**
	 * Display product label
	 *
	 * @param $product The product
	 * @return $label markup
	 */
	function azo_product_label( $product ) {
		if ( ! $product ) {
			return;
		}

		$label = '';

		// Show new & hot product.
		azo_custom_field_product();

		// Out of stock label.
		if ( ! $product->is_in_stock() ) {
			$label = '<span class="azo-product-label sold-out-label">' . esc_html__( 'Sold out', 'azo' ) . '</span>';
		}

		return $label;
	}
}

// Get query var.

// Get Next page link.
if ( ! function_exists( 'azo_get_next_shop_page' ) ) {
	function azo_get_next_shop_page( $widget = false, $total = null ) {
		if ( false == $widget ) {
			if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
				return;
			}
		}

		$args = array(
			'total'   => wc_get_loop_prop( 'total_pages' ),
			'current' => wc_get_loop_prop( 'current_page' ),
			'base'    => esc_url_raw( add_query_arg( 'product-page', '%#%', false ) ),
			'format'  => '?product-page=%#%',
		);

		if ( ! wc_get_loop_prop( 'is_shortcode' ) ) {
			$args['format'] = '';
			$args['base']   = esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
		}

		$total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
		$current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
		$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
		$format  = isset( $format ) ? $format : '';

		if ( $total <= 1 ) {
			return;
		}

		$paged = 0 == get_query_var( 'paged' ) ? 1 : get_query_var( 'paged' );
		if ( $paged >= $total ) {
			return;
		}

		$paged += 1;
		?>
		<div class="ht-pagination <?php echo false == $widget ? 'text-center' : ''; ?>">
			<a class="load-more-product-btn" href="<?php echo esc_url( get_pagenum_link( $paged ) ); ?>"><?php esc_html_e( 'Load More', 'azo' ); ?></a>
		</div>
		<?php
	}
}

// Remove default WC pagination.
add_action( 'wp', 'azo_woocommerce_pagination' );
if ( ! function_exists( 'azo_woocommerce_pagination' ) ) {
	function azo_woocommerce_pagination() {
		if ( true == get_theme_mod( 'product_load_more', false ) ) {
			remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
			add_action( 'woocommerce_after_shop_loop', 'azo_get_next_shop_page', 10 );
		}
	}
}


// FOR PRODUCT IMAGES.
if ( ! function_exists( 'azo_get_last_product_id' ) ) {
	function azo_get_last_product_id() {
		$args = array(
			'post_type'           => 'product',
			'posts_per_page'      => 1,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
		);

		$query = new WP_Query( $args );

		$id = false;

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();

				$id = get_the_ID();
			}

			wp_reset_postdata();
		}

		return $id;
	}
}


if ( ! function_exists( 'azo_get_variation_gallery' ) ) {
	/**
	 * Get variation gallery
	 *
	 * @param      object $product  The product.
	 *
	 * @return     array
	 */
	function azo_get_variation_gallery( $product ) {
		$images = array();

		if ( ! $product->is_type( 'variable' ) || ! class_exists( 'Woo_Variation_Gallery' ) ) {
			return $images;
		}

		$variations = array_values( $product->get_available_variations() );

		$images = array();
		foreach ( $variations as $k ) {
			array_unshift( $k['variation_gallery_images'], array( 'variation_id' => $k['variation_id'] ) );
			array_push( $images, $k['variation_gallery_images'] );
		}

		return $images;
	}
}

if ( ! function_exists( 'azo_get_default_gallery' ) ) {
	/**
	 * Get variation gallery
	 *
	 * @param      object $product  The product.
	 *
	 * @return     array
	 */
	function azo_get_default_gallery( $product ) {
		$images                 = array();
		$product_id             = $product->get_id();
		$gallery_images         = $product->get_gallery_image_ids();
		$has_default_thumbnails = false;

		if ( ! empty( $gallery_images ) ) {
			$has_default_thumbnails = true;
		}

		if ( has_post_thumbnail( $product_id ) ) {
			array_unshift( $gallery_images, get_post_thumbnail_id( $product_id ) );
		}

		if ( ! empty( $gallery_images ) ) {
			foreach ( $gallery_images as $i => $image_id ) {
				$images[ $i ]                           = wc_get_product_attachment_props( $image_id );
				$images[ $i ]['image_id']               = $image_id;
				$images[ $i ]['has_default_thumbnails'] = $has_default_thumbnails;
			}
		}

		return $images;
	}
}

if ( ! function_exists( 'azo_global_for_vartiation_gallery' ) ) {
	/**
	 * Get global variables for variation gallery
	 */
	function azo_global_for_vartiation_gallery() {
		global $product;
		if ( ! is_object( $product ) ) {
			$product_id = azo_get_last_product_id();
			if ( ! $product_id ) {
				return;
			}

			$product = wc_get_product( $product_id );
		}

		// azo Variation gallery.
		wp_localize_script(
			'product-images',
			'azo_variation_gallery',
			azo_get_variation_gallery( $product )
		);

		// azo default gallery.
		wp_localize_script(
			'product-images',
			'azo_default_gallery',
			azo_get_default_gallery( $product )
		);
	}
}


// Wrapper product images and summary.
if ( ! function_exists( 'azo_wrapper_product_content_open' ) ) {
	add_action( 'woocommerce_before_single_product_summary', 'azo_wrapper_product_content_open', 5 );
	function azo_wrapper_product_content_open() {
		$layout       = get_theme_mod( 'shop_gallery_layout', 'horizontal' );
		$align_layout = get_theme_mod( 'shop_layout_align', 'left' );
		$width_layout = get_theme_mod( 'gallery_layout_width', 'default' );

		global $product;
		$gallery_id = $product->get_gallery_image_ids();
		if ( ! empty( $gallery_id ) ) {
			$name_gallery = 'gallery-product';
		} else {
			$name_gallery = 'no-gallery-product';
		}

		$layout_product = isset( $_GET['layout_product'] ) ? Azo_Helper::data_clean( $_GET['layout_product'] ) : false;
		$layout_align   = isset( $_GET['layout_align'] ) ? Azo_Helper::data_clean( $_GET['layout_align'] ) : false;

		if ( false === $layout_align ) {
			$align_layout = get_theme_mod( 'shop_layout_align', 'left' );
		} else {
			$align_layout = $layout_align;
		}

		if ( false === $layout_product ) {
			?>
			<div class="wrapper-product-content layout-<?php echo esc_attr( $layout ); ?> align-shop-<?php echo esc_attr( $align_layout ); ?> <?php echo esc_attr( $name_gallery ); ?> <?php echo esc_attr( $width_layout ); ?>">
			<?php
		} else {
			?>
			<div class="wrapper-product-content layout-<?php echo esc_attr( $layout_product ); ?> align-shop-<?php echo esc_attr( $align_layout ); ?> <?php echo esc_attr( $name_gallery ); ?> <?php echo esc_attr( $width_layout ); ?>">
			<?php
		}
	}
}

if ( ! function_exists( 'azo_wrapper_product_content_close' ) ) {
	add_action( 'woocommerce_after_single_product_summary', 'azo_wrapper_product_content_close', 5 );
	function azo_wrapper_product_content_close() {
		?>
		</div>
		<?php
	}
}

$layout         = get_theme_mod( 'shop_gallery_layout', 'horizontal' );
$layout_product = isset( $_GET['layout_product'] ) ? Azo_Helper::data_clean( $_GET['layout_product'] ) : false;

if ( ( 'fullall' === $layout && false === $layout_product ) || ( 'fullall' === $layout_product && false !== $layout_product ) ) {
	if ( ! function_exists( 'azo_class_for_full' ) ) {
		add_action( 'woocommerce_single_product_summary', 'azo_class_for_full', 4 );
		function azo_class_for_full() {
			?>
			<div class="row">
				<div class="azo-class-for-full col-md-7 col-lg-7">
			<?php
		}
	}

	if ( ! function_exists( 'azo_class_for_full_close' ) ) {
		add_action( 'woocommerce_single_product_summary', 'azo_class_for_full_close', 21 );
		function azo_class_for_full_close() {
			?>
			</div>

			<div class="azo-class-for-cart col-md-5 col-lg-5">
			<?php
		}
	}

	if ( ! function_exists( 'azo_class_for_full_cart_close' ) ) {
		add_action( 'woocommerce_after_single_product_summary', 'azo_class_for_full_cart_close', 9 );
		function azo_class_for_full_cart_close() {
			?>
				</div>
			</div>
			<?php
		}
	}
}

// Add text thankyou page.
add_filter( 'woocommerce_thankyou_order_received_text', 'azo_add_thank_you_title', 20, 2 );
function azo_add_thank_you_title( $thank_you_title, $order ){
	?>
	<div class="woocommerce-azo-thankyou-order-received">
		<i class="icon-thankyou-order icoros-check-2"></i>
		<h3 class="woocommerce-thankyou-order-completed">
			<?php esc_html_e( 'Your order is completed', 'azo' ); ?>
		</h3>
		<p class="woocommerce-notice-thanks">
			<?php esc_html_e( 'Thank you! Your order has been received.', 'azo' ); ?>
		</p>
	</div>
	<?php
}
