<?php
/**
 * Content Single Product
 *
 * @package azo
 */

if ( ! function_exists( 'azo_get_metabox' ) ) {
	/**
	 * Get metabox option
	 *
	 * @param int    $page_id      The page ID.
	 * @param string $metabox_name Metabox option name.
	 */
	function azo_get_metabox( $page_id = false, $metabox_name ) {
		$page_id             = $page_id ? intval( $page_id ) : azo_get_page_id();
		$metabox             = get_post_meta( $page_id, $metabox_name, true );
		$is_product_category = class_exists( 'woocommerce' ) && is_product_category();

		if ( ! $metabox || $is_product_category ) {
			$metabox = 'default';
		}

		return $metabox;
	}
}

if ( get_theme_mod( 'product_gallery_default' ) !== true ) {
	remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
	add_action( 'woocommerce_before_single_product_summary', 'azo_product_gallery', 20 );
}

/**
 * PRODUCT IMAGE
 */
function azo_product_gallery() {
	/*PRODUCT ATTRIBUTE*/
	global $product;
	$product_id   = $product->get_id();
	$image_id     = $product->get_image_id();
	$image_alt    = azo_img_alt( $image_id, esc_attr__( 'product image', 'azo' ) );
	$get_img_size = wc_get_image_size( 'woocommerce_single' );
	$image_size   = $get_img_size['width'] . 'x' . ! empty( $get_img_size['height'] ) ? $get_img_size['height'] : $get_img_size['width'];
	$slider_tag   = 'div';

	if ( $image_id ) {
		$image_small_src  = wp_get_attachment_image_src( $image_id, 'thumbnail' );
		$image_medium_src = wp_get_attachment_image_src( $image_id, 'woocommerce_single' );
		$image_full_src   = wp_get_attachment_image_src( $image_id, 'full' );
		$image_size       = $image_full_src[1] . 'x' . $image_full_src[2];
	} else {
		$image_small_src[0]  = wc_placeholder_img_src();
		$image_medium_src[0] = wc_placeholder_img_src();
		$image_full_src[0]   = wc_placeholder_img_src();
	}

	$gallery_id = $product->get_gallery_image_ids();
	$class_name = 'pro-single-image';
	$video_url  = '';

	/*LAYOUT*/
	$layout = get_theme_mod( 'shop_gallery_layout', 'horizontal' );

	/*ZOOM JS*/
	wp_enqueue_script( 'easyzoom' );
	// This script for All image on Main slider ZOOM.
	if ( true === get_theme_mod( 'show_image_zoom', false ) ) {
		wp_add_inline_script(
			'easyzoom',
			"document.addEventListener( 'DOMContentLoaded', function(){
				if ( window.matchMedia( '( min-width: 992px )' ).matches ) {
					jQuery( '.ez-zoom' ).easyZoom();
				}
			} );",
			'after'
		);
	}

	// Photoswipe.
	wp_enqueue_script( 'photoswipe-init' );

	$slider_tag = 'figure';

	get_template_part( 'template-parts/content', 'photoswipe' );

	/*PRODUCT OPTION*/
	global $product;
	if ( ! $product || ! is_object( $product ) ) {
		return;
	}

	wp_enqueue_style( 'lity-style' );
	wp_enqueue_script( 'lity-script' );
	$product_id = $product->get_id();

	$video_url = azo_get_metabox( $product_id, 'azo_product_video_metabox' );

	$layout_product = isset( $_GET['layout_product'] ) ? Azo_Helper::data_clean( $_GET['layout_product'] ) : false;

	// SLIDER FOR vertical and horizontal LAYOUT.
	if ( ! empty( $gallery_id ) && false === $layout_product ) {
		switch ( $layout ) {
			case 'vertical':
				$class_name  = '';
				$mode        = 'vertical';
				$gutter      = 0;
				$fixed_width = 0;

				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){
						var image_carousel = tns({
							loop: false,
							container: '#gallery-image',
							navContainer: '#gallery-thumb',
							items: 1,
							navAsThumbnails: true,
							autoHeight: true
						});

						var thumb_carousel = tns({
							loop: false,
							container: '#gallery-thumb',
							gutter: {$gutter},
							items: 5,
							mouseDrag: true,
							nav: false,
							fixedWidth: {$fixed_width},
							controls: false,
							axis: '{$mode}'
						});

						document.addEventListener( 'load', function() {
							var _prev = document.querySelector( '[data-controls=\'prev\']' ),
								_next = document.querySelector( '[data-controls=\'next\']' );

							_prev.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'prev' );
							});
							_next.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'next' );
							});
						} );

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
							thumb_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			case 'fullall':
				$class_name  = 'azo-full';
				$mode        = 'horizontal';
				$gutter      = 20;
				$fixed_width = 100;

				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){
						var image_carousel = tns({
							loop: false,
							container: '#gallery-image',
							responsive: {
								425: {
									items: 1,
								},
								768: {
									items: 3,
								}
							},
							autoHeight: true,
							gutter: {$gutter},
							nav: false,
						});

						document.addEventListener( 'load', function() {
							var _prev = document.querySelector( '[data-controls=\'prev\']' ),
								_next = document.querySelector( '[data-controls=\'next\']' );
						} );

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			case 'list':
				$class_name = '';

				// Rebuild slider on mobile device.
				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){

						if ( window.matchMedia( '( min-width: 768px )' ).matches ) {
							return;
						}

						var image_carousel = tns({
							container: '#gallery-image',
							items: 1,
							autoHeight: true,
							mouseDrag: true
						});

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			case 'grid':
				$class_name = '';

				// Rebuild slider on mobile device.
				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){

						if ( window.matchMedia( '( min-width: 768px )' ).matches ) {
							return;
						}

						var image_carousel = tns({
							container: '#gallery-image',
							items: 1,
							autoHeight: true,
							mouseDrag: true
						});

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			default:
				$class_name  = '';
				$mode        = 'horizontal';
				$gutter      = 10;
				$fixed_width = 80;

				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){
						var image_carousel = tns({
							loop: false,
							container: '#gallery-image',
							navContainer: '#gallery-thumb',
							items: 1,
							navAsThumbnails: true,
							autoHeight: true
						});

						var thumb_carousel = tns({
							loop: false,
							container: '#gallery-thumb',
							gutter: {$gutter},
							items: 5,
							mouseDrag: true,
							nav: false,
							fixedWidth: {$fixed_width},
							controls: false,
							axis: '{$mode}'
						});

						document.addEventListener( 'load', function() {
							var _prev = document.querySelector( '[data-controls=\'prev\']' ),
								_next = document.querySelector( '[data-controls=\'next\']' );

							_prev.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'prev' );
							});
							_next.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'next' );
							});
						} );

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
							thumb_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
		}
	}

	if ( ! empty( $gallery_id ) && false !== $layout_product ) {
		switch ( $layout_product ) {
			case 'vertical':
				$class_name  = '';
				$mode        = 'vertical';
				$gutter      = 0;
				$fixed_width = 0;

				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){
						var image_carousel = tns({
							loop: false,
							container: '#gallery-image',
							navContainer: '#gallery-thumb',
							items: 1,
							navAsThumbnails: true,
							autoHeight: true
						});

						var thumb_carousel = tns({
							loop: false,
							container: '#gallery-thumb',
							gutter: {$gutter},
							items: 5,
							mouseDrag: true,
							nav: false,
							fixedWidth: {$fixed_width},
							controls: false,
							axis: '{$mode}'
						});

						document.addEventListener( 'load', function() {
							var _prev = document.querySelector( '[data-controls=\'prev\']' ),
								_next = document.querySelector( '[data-controls=\'next\']' );

							_prev.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'prev' );
							});
							_next.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'next' );
							});
						} );

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
							thumb_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
				break;
			case 'fullall':
				$class_name  = 'azo-full';
				$mode        = 'horizontal';
				$gutter      = 20;
				$fixed_width = 100;

				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){
						var image_carousel = tns({
							loop: false,
							container: '#gallery-image',
							responsive: {
								425: {
									items: 1,
								},
								768: {
									items: 3,
								}
							},
							autoHeight: true,
							gutter: {$gutter},
							nav: false,
						});

						document.addEventListener( 'load', function() {
							var _prev = document.querySelector( '[data-controls=\'prev\']' ),
								_next = document.querySelector( '[data-controls=\'next\']' );
						} );

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			case 'list':
				$class_name = '';

				// Rebuild slider on mobile device.
				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){

						if ( window.matchMedia( '( min-width: 768px )' ).matches ) {
							return;
						}

						var image_carousel = tns({
							container: '#gallery-image',
							items: 1,
							autoHeight: true,
							mouseDrag: true
						});

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			case 'grid':
				$class_name = '';

				// Rebuild slider on mobile device.
				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){

						if ( window.matchMedia( '( min-width: 768px )' ).matches ) {
							return;
						}

						var image_carousel = tns({
							container: '#gallery-image',
							items: 1,
							autoHeight: true,
							mouseDrag: true
						});

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
				break;
			default:
				$class_name  = '';
				$mode        = 'horizontal';
				$gutter      = 10;
				$fixed_width = 80;

				wp_add_inline_script(
					'tiny-slider',
					"document.addEventListener( 'DOMContentLoaded', function(){
						var image_carousel = tns({
							loop: false,
							container: '#gallery-image',
							navContainer: '#gallery-thumb',
							items: 1,
							navAsThumbnails: true,
							autoHeight: true
						});

						var thumb_carousel = tns({
							loop: false,
							container: '#gallery-thumb',
							gutter: {$gutter},
							items: 5,
							mouseDrag: true,
							nav: false,
							fixedWidth: {$fixed_width},
							controls: false,
							axis: '{$mode}'
						});

						document.addEventListener( 'load', function() {
							var _prev = document.querySelector( '[data-controls=\'prev\']' ),
								_next = document.querySelector( '[data-controls=\'next\']' );

							_prev.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'prev' );
							});
							_next.addEventListener( 'click', function () {
								thumb_carousel.goTo( 'next' );
							});
						} );

						var reset_slider = function(){
							image_carousel.goTo( 'first' );
							thumb_carousel.goTo( 'first' );
						}

						jQuery( document.body ).on( 'found_variation', 'form.variations_form', function( event, variation ){
							reset_slider();
						});

						jQuery( '.reset_variations' ).on( 'click', function(){
							reset_slider();
						});
					});",
					'after'
				);
		}
	}

	$shop_full_class = '';
	if ( 'fullall' === $layout || 'fullall' === $layout_product ) { //phpcs:ignore
		global $product;
		$align_layout = get_theme_mod( 'shop_layout_align', 'left' );

		if ( $product->is_type( 'simple' ) ) {
			$shop_full_class = '<div class="summary-fullall is-simple-producst ' . $align_layout . '">';
		} else {
			$shop_full_class = '<div class="summary-fullall ' . $align_layout . '">';
		}
	}

	?>
	<div class="single-product-gallery <?php echo esc_attr( $class_name ); ?>">
		<?php /*MAIN CAROUSEL*/ ?>
		<div class="pro-carousel-image">
			<div id="gallery-image">
				<<?php echo esc_attr( $slider_tag ); ?> class="pro-img-item ez-zoom"
				<?php if ( true === get_theme_mod( 'show_image_zoom', false ) ) { ?>
					data-zoom="<?php echo esc_attr( $image_full_src[0] ); ?>"
				<?php } ?>>
					<a href="<?php echo esc_url( $image_full_src[0] ); ?>" data-size="<?php echo esc_attr( $image_size ); ?>" data-elementor-open-lightbox="no">
						<img src="<?php echo esc_url( $image_medium_src[0] ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
					</a>
				</<?php echo esc_attr( $slider_tag ); ?>>

				<?php
				if ( ! empty( $gallery_id ) ) :
					foreach ( $gallery_id as $key ) :
						$g_full_img_src   = wp_get_attachment_image_src( $key, 'full' );
						$g_medium_img_src = wp_get_attachment_image_src( $key, 'woocommerce_single' );
						$g_image_size     = $g_full_img_src[1] . 'x' . $g_full_img_src[2];
						$g_img_alt        = azo_image_alt( $key, esc_attr__( 'product image', 'azo' ) );
						$g_img_srcset     = function_exists( 'wp_get_attachment_image_srcset' ) ? wp_get_attachment_image_srcset( $key, 'woocommerce_single' ) : '';
						?>
						<<?php echo esc_attr( $slider_tag ); ?> class="pro-img-item ez-zoom" data-zoom="<?php echo esc_attr( $g_full_img_src[0] ); ?>">
							<a href="<?php echo esc_url( $g_full_img_src[0] ); ?>" data-size="<?php echo esc_attr( $g_image_size ); ?>" data-elementor-open-lightbox="no">
								<img width="<?php echo esc_attr( $g_full_img_src[1] ); ?>" height="<?php echo esc_attr( $g_full_img_src[2] ); ?>"  src="<?php echo esc_url( $g_medium_img_src[0] ); ?>" alt="<?php echo esc_attr( $g_img_alt ); ?>" srcset="<?php echo wp_kses( $g_img_srcset, azo_get_allowed_html() ); ?>">
							</a>
						</<?php echo esc_attr( $slider_tag ); ?>>
						<?php
					endforeach;
				endif;
				?>
			</div>
		</div>

		<?php /*THUMB CAROUSEL*/ ?>
		<?php if ( ! empty( $gallery_id ) ) { ?>
			<?php if ( ( false === $layout_product && ( 'vertical' === $layout || 'horizontal' === $layout ) ) || ( false !== $layout_product && ( 'vertical' === $layout_product || 'horizontal' === $layout_product ) ) ) { ?>
				<div class="pro-carousel-thumb">
					<div id="gallery-thumb">
						<div class="pro-thumb">
							<img src="<?php echo esc_url( $image_small_src[0] ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
						</div>

						<?php
						foreach ( $gallery_id as $key ) :
							$g_thumb_src = wp_get_attachment_image_src( $key, 'thumbnail' );
							$g_thumb_alt = azo_img_alt( $key, esc_attr__( 'product image', 'azo' ) );
							?>
							<div class="pro-thumb">
								<img src="<?php echo esc_url( $g_thumb_src[0] ); ?>" alt="<?php echo esc_attr( $g_thumb_alt ); ?>">
							</div>
						<?php endforeach; ?>
					</div>
				</div>
				<?php
			}
		}

		if ( 'default' !== $video_url ) {
			?>
				<a href="<?php echo esc_url( $video_url ); ?>" data-lity class="video-popup-btn azo-lightbox-button">
					<span class="azo-icon-text">
						<?php esc_html_e( 'View Video', 'azo' ); ?>
					</span>

					<span class="ion-ios-play"></span>
				</a>
			<?php
		}

		/* PRODUCT LABEL SINGLE PRODUCT */
		echo azo_product_label( $product ); // phpcs:ignore
		?>
	</div>

	<?php if ( 'fullall' === $layout || 'fullall' === $layout_product ) { //phpcs:ignore ?>
		</div>
	<?php } ?>

	<?php echo wp_kses( $shop_full_class, azo_get_allowed_html() ); ?>

	<?php
}

/*REMOVE DESCRIPTION HEADING*/
add_filter( 'woocommerce_product_description_heading', '__return_empty_string' );

/*AFTER ADD TO CART BUTTON*/
add_action( 'woocommerce_after_add_to_cart_button', 'additional_simple_add_to_cart', 20 );
/**
 * [additional_simple_add_to_cart description]
 */
function additional_simple_add_to_cart() {
	/*AJAX SINGLE ADD TO CART VALUE===*/
	global $product;
	$pid       = $product->get_id();
	$in_stock  = get_post_meta( $pid, '_manage_stock', true ); // RETURN yes or no.
	$stock_qty = $product->get_stock_quantity(); // RETUNR `INT` VALUE.

	/*CHECK PRODUCT IN CART && CHECK QUANTITY IF IT ALREADY IN CART*/
	$in_cart_qty = azo_product_check_in( $pid, $in_cart = true, $qty_in_cart = false ) ? azo_product_check_in( $pid, $in_cart = false, $qty_in_cart = true ) : 0; // phpcs:ignore

	/*WARNING TEXT*/
	$not_enough   = esc_html__( 'You cannot add that amount of this product to the cart because there is not enough stock.', 'azo' );
	$out_of_stock = sprintf( esc_html__( 'You cannot add that amount to the cart - we have %1$s in stock and you already have %1$s in your cart', 'azo' ), $stock_qty ); // phpcs:ignore
	$valid_qty    = esc_html__( 'Please enter a valid quantity for this product', 'azo' );
	?>
	<input class="in-cart-qty" type="hidden" value="<?php echo esc_attr( $in_cart_qty ); ?>"
	data-in_stock="<?php echo esc_attr( $in_stock ); ?>"
	data-out_of_stock="<?php echo esc_attr( $out_of_stock ); ?>"
	data-valid_qty="<?php echo esc_attr( $valid_qty ); ?>"
	data-not_enough="<?php echo esc_attr( $not_enough ); ?>">
	<?php
}

add_action( 'woocommerce_after_add_to_cart_button', 'additional_buy_now', 25 );
/**
 * BUY NOW BUTTON
 */
function additional_buy_now() {
	if ( true === get_theme_mod( 'show_button_buy_now', false ) ) {
		global $product;
		?>
			<button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button button alt" id="buy_now_button">
				<?php echo esc_html__( 'Buy Now', 'azo' ); ?>
			</button>
			<input type="hidden" name="is_buy_now" id="is_buy_now" value="0" />
		<?php
	}
}

add_action( 'woocommerce_after_single_product', 'azo_sticky_button', 20 );
/**
 * Azo sticky button description
 */
function azo_sticky_button() {
	if ( true === get_theme_mod( 'show_sticky_button', false ) ) {
		global $product;

		// Product type.
		$simple   = $product->is_type( 'simple' );
		$variable = $product->is_type( 'variable' );
		$external = $product->is_type( 'external' );
		$grouped  = $product->is_type( 'grouped' );
		$bundle   = $product->is_type( 'woosb' );

		$product_type = get_the_terms( $product_id, 'product_type' )[0]->slug;

		if ( 'outofstock' === $product->get_stock_status() ) {
			return;
		}

		// Section classes.
		$class[] = 'sticky-add-to-cart-section';
		$class[] = $variable ? 'variations-product' : 'no-variations-product';
		$class[] = $variable && 1 >= count( $product->get_available_variations() ) ? 'no-need-update-price' : '';
		$class[] = $product->get_stock_status();
		$class   = implode( ' ', array_filter( $class ) );
		?>
		<div class="azo-stick-container <?php echo esc_attr( $class ); ?>">
			<div class="container azo-block-bottom">
				<div class="sticky-product-title">
					<div class="sticky-product-image">
						<?php echo wp_kses_decode_entities( $product->get_image( 'thumbnail' ) ); ?>
					</div>

					<h6 class="sticky-atc-title">
						<?php echo esc_html( $product->get_title() ); ?>
					</h6>
				</div>

				<div class="product-information-sticky">
					<p class="price">
						<?php echo wp_kses( $product->get_price_html(), azo_get_allowed_html() ); ?>
					</p>

					<?php
					if ( $simple || $external ) {
						global $product;
						do_action( 'woocommerce_' . $product->get_type() . '_add_to_cart' );
					} elseif ( $variable ) {
						?>
						<button class="js-to-summary azo-select-options">
							<?php esc_html_e( 'Select Options', 'azo' ); ?>
						</button>
						<?php
					} elseif ( $bundle ) {
						?>
						<button class="js-to-bundled azo-select-options">
							<?php esc_html_e( 'Select Options', 'azo' ); ?>
						</button>
						<?php
					} elseif ( $grouped ) {
						?>
						<button class="js-to-grouped azo-select-options">
							<?php esc_html_e( 'Add to cart', 'azo' ); ?>
						</button>
						<?php
					}
					?>
				</div>
			</div>
		</div>
		<?php
	}
}

add_filter( 'woocommerce_product_additional_information_heading', 'azo_remove_additional_information_heading' );
/**
 * REMOVE ADDITIONAL INFORMATION HEADING
 */
function azo_remove_additional_information_heading() {
	return '';
}

add_filter( 'woocommerce_upsell_display_args', 'azo_column_related' );
add_filter( 'woocommerce_output_related_products_args', 'azo_column_related' );
/**
 * SET COLUMN FOR RELATED || UPSELL PRODUCT
 *
 * @param  [type] $args string.
 */
function azo_column_related( $args ) {
	$number = (int) get_theme_mod( 'related_product_item', 4 );
	$column = (int) get_theme_mod( 'related_column', 4 );

	$args['posts_per_page'] = $number;
	$args['columns']        = $column;
	return $args;
}

add_action( 'wp_ajax_single_add_to_cart', 'azo_single_add_to_cart' );
add_action( 'wp_ajax_nopriv_single_add_to_cart', 'azo_single_add_to_cart' );
/**
 * AJAX SINGLE ADD TO CART
 */
function azo_single_add_to_cart() {

	$response = array(
		'status'  => 500,
		'message' => esc_html__( 'Something is wrong, please try again later...', 'azo' ),
		'content' => false,
	);

	if ( ! isset( $_POST['product_id'] ) || ! isset( $_POST['product_qty'] ) || ! isset( $_POST['nonce'] ) ) { //phpcs:ignore
		echo wp_json_encode( $response );
		exit();
	}

	$product_id        = absint( $_POST['product_id'] ); //phpcs:ignore
	$product_qty       = absint( $_POST['product_qty'] ); //phpcs:ignore
	$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $product_qty );

	if ( isset( $_POST['variation_id'] ) ) { //phpcs:ignore
		$variation_id = sanitize_key( $_POST['variation_id'] ); //phpcs:ignore
	}

	if ( isset( $_POST['variations'] ) ) { //phpcs:ignore
		$variations = (array) json_decode( sanitize_text_field( wp_unslash( $_POST['variations'] ) ) ); //phpcs:ignore
	}

	if ( $variation_id && $passed_validation ) {
		WC()->cart->add_to_cart( $product_id, $product_qty, $variation_id, $variations );
	} else {
		WC()->cart->add_to_cart( $product_id, $product_qty );
	}

	$count = WC()->cart->get_cart_contents_count();

	ob_start();

	$response = array(
		'status' => 200,
		'item'   => $count,
	);

	woocommerce_mini_cart();

	$response['content'] = ob_get_clean();

	echo wp_json_encode( $response );
	exit();
}


add_action( 'wp_ajax_get_count_product_already_in_cart', 'azo_get_count_product_already_in_cart' );
add_action( 'wp_ajax_nopriv_get_count_product_already_in_cart', 'azo_get_count_product_already_in_cart' );
/**
 * GET NUMBER CURRENT PRODUCT IN CART
 */
function azo_get_count_product_already_in_cart() {
	$response = array(
		'in_cart' => 0,
	);

	if ( ! isset( $_POST['product_id'] ) ) { //phpcs:ignore
		echo wp_json_encode( $response );
		exit();
	}

	$product_id  = intval( $_POST['product_id'] ); //phpcs:ignore
	$in_cart_qty = azo_product_check_in( $product_id, $in_cart = false, $qty_in_cart = true );

	ob_start();

	$response['in_cart'] = $in_cart_qty;

	ob_get_clean();

	echo wp_json_encode( $response );
	exit();
}

/**
 * Show or hide product categories and tags based on customizer option
 */

// Remove default single product meta template.
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );

/**
 * Create custom single product meta template
 */
function azo_template_single_meta() {
	global $product;
	?>
	<div class="product_meta">
		<?php
		do_action( 'woocommerce_product_meta_start' );
		if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) {
			?>
				<span class="sku_wrapper meta_detail">
					<span class="title-meta-detail"><?php esc_html_e( 'SKU:', 'azo' ); ?></span>
					<span class="sku">
						<?php echo esc_html( $product->get_sku() ? $product->get_sku() : esc_html__( 'N/A', 'azo' ) ); ?>
					</span>
				</span>
			<?php
		}

		if ( get_theme_mod( 'show_product_category', 'true' ) ) {
			echo wp_kses( wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in meta_detail">' . _n( ' <span class="title-meta-detail"> Categories: </span>', '<span class="title-meta-detail"> Categories: </span>', count( $product->get_category_ids() ), 'azo' ) . ' ', '</span>' ), azo_get_allowed_html() ); //phpcs:ignore
		}

		if ( get_theme_mod( 'show_product_tag', 'true' ) ) {
			echo wp_kses( wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as meta_detail">' . _n( '<span class="title-meta-detail"> Tag:</span>', '<span class="title-meta-detail"> Tags: </span>', count( $product->get_tag_ids() ), 'azo' ) . ' ', '</span>' ), azo_get_allowed_html() ); //phpcs:ignore
		}
		?>
	</div>
	<?php
}
add_action( 'woocommerce_single_product_summary', 'azo_template_single_meta', 40 );

if ( ! function_exists( 'azo_filter_single_post_pagination' ) ) {
	/**
	 * Filter_single_post_pagination description
	 *
	 * @param  [type] $output type.
	 * @param  [type] $format type.
	 * @param  [type] $link   type.
	 * @param  [type] $post   type.
	 */
	function azo_filter_single_post_pagination( $output, $format, $link, $post ) {
		if ( ! $post ) {
			return;
		}

		$title        = get_the_title( $post );
		$url          = get_permalink( $post->ID );
		$product_meta = get_post_meta( $post->ID );
		if ( ! empty( $product_meta['_thumbnail_id'] ) ) {
			$image = wp_get_attachment_image( $product_meta['_thumbnail_id'][0], array( 85, 85 ) );
		}
		$pricesd = get_post_meta( $post->ID, '_price', true );
		$price   = wc_price( $pricesd );
		?>
		<span class="nav-pro">
			<a href="<?php echo esc_url( $url ); ?>"></a>
		</span>

		<div class="wrapper-short">
			<div class="product-short">
				<?php if ( ! empty( $product_meta['_thumbnail_id'] ) ) { ?>
					<div class="product-short-image">
						<a href="<?php echo esc_url( $url ); ?>" class="product-thumb">
							<?php echo wp_kses_decode_entities( $image ); ?>
						</a>
					</div>
				<?php } ?>

				<div class="product-short-description">
					<a href="<?php echo esc_url( $url ); ?>" class="azo-entities-title">
						<?php echo wp_kses( $title, azo_get_allowed_html() ); ?>
					</a>

					<span class="price">
						<?php echo wp_kses( $price, azo_get_allowed_html() ); ?>
					</span>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'azo_prev_next_product' ) ) {
	/**
	 * Azo prev next product description
	 */
	function azo_prev_next_product() {
		if ( true === get_theme_mod( 'shop_single_nav', true ) ) {
			if ( is_product() ) {
				add_filter( 'previous_post_link', 'azo_filter_single_post_pagination', 10, 4 );
				add_filter( 'next_post_link', 'azo_filter_single_post_pagination', 10, 4 );
				?>
				<div class="prev_next_buttons">
					<div class="azo-product-navigation">
						<div class="product-btn product-prev">
							<?php echo esc_html( previous_post_link() ); ?>
						</div>

						<a href="<?php echo esc_url( home_url( '/shop' ) ); ?>" class="spacenav-shop hint--bounce hint--bottom" data-hint="Shop">
							<i class="icoros-icon_grid_2"></i>
						</a>

						<div class="product-btn product-next">
							<?php echo esc_html( next_post_link() ); ?>
						</div>
					</div>
				</div>
				<?php
			}
		}
	}
}

add_action( 'woocommerce_grouped_product_list_before_label', 'azo_woocommerce_grouped_product_thumbnail' );
/**
 * Azo woocommerce grouped product thumbnail
 *
 * @param  [type] $product type.
 */
function azo_woocommerce_grouped_product_thumbnail( $product ) {
	$image_size    = array( 60, 60 );
	$attachment_id = get_post_meta( $product->get_id(), '_thumbnail_id', true );
	$link          = get_the_permalink( $product->get_id() );
	?>
	<td class="woocommerce-grouped-product-list-item__thumbnail">
		<a href="<?php echo esc_url( $link ); ?>">
			<?php echo wp_get_attachment_image( $attachment_id, $image_size ); ?>
		</a>
	</td>
	<?php
}

add_filter( 'woocommerce_grouped_product_columns', 'azo_filter_grouped_product', 10, 2 );
/**
 * Onestore filter grouped product
 *
 * @param  [type] $array   type.
 * @param  [type] $product type.
 */
function azo_filter_grouped_product( $array, $product ) {
	$array = array( 'label', 'price', 'quantity' );
	return $array;
}

/**
 * Change In Stock / Out of Stock Text
 *
 * @param  [type] $availability type.
 * @param  [type] $variation type.
 */
function wcs_custom_get_availability( $availability, $variation ) {
	// Change In Stock Text.
	if ( $variation->is_in_stock() ) {
		$availability['availability'] = __( 'In Stock', 'azo' );
	}

	// Change Out of Stock Text.
	if ( ! $variation->is_in_stock() ) {
		$availability['availability'] = __( 'Out Of Stock', 'azo' );
	}

	return $availability;
}
add_filter( 'woocommerce_get_availability', 'wcs_custom_get_availability', 1, 2 );

/**
 * Custom woo reviews summary
 */
function custom_woo_reviews_summary() {
	global $product;
	$product_id       = $product->get_id();
	$get_rating_count = get_post_meta( $product_id, '_wc_rating_count', true );
	$get_review_count = get_post_meta( $product_id, '_wc_review_count', true );
	$get_rating_text  = array(
		'5' => '<i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>',
		'4' => '<i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="far fa-star"></i>',
		'3' => '<i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="far fa-star"></i><i class="far fa-star"></i>',
		'2' => '<i class="fas fa-star"></i><i class="fas fa-star"></i><i class="far fa-star"></i><i class="far fa-star"></i><i class="far fa-star"></i>',
		'1' => '<i class="fas fa-star"></i><i class="far fa-star"></i><i class="far fa-star"></i><i class="far fa-star"></i><i class="far fa-star"></i>',
	);

	for ( $i = 5; $i > 0; $i -- ) {
		if ( ! isset( $get_rating_count[ $i ] ) ) {
			$get_rating_count[ $i ] = 0;
		}
		$percentage = 0;
		if ( $get_rating_count[ $i ] > 0 ) {
			$percentage = round( ( $get_rating_count[ $i ] / $get_review_count ) * 100 );
		}
		?>
		<div class="reviews-bar">
			<div class="stars-title">
				<?php echo wp_kses_decode_entities( $get_rating_text[ $i ] ); ?>
			</div>

			<div class="rating-graph" title="<?php printf( '%s%%', $percentage ); ?>">
				<div class="percentage bar" style="width: <?php echo esc_attr( $percentage ); ?>%"></div>
			</div>

			<div class="rating-percentage">
				<?php echo esc_html( sprintf( __( '%1$d%%', 'azo' ), $percentage ) ); ?>
			</div>
		</div>
		<?php
	}
}

/**
 * Reviews/Questions Summary
 *
 * @param  [type] $product type.
 */
function reviews_summary( $product ) {
	if ( ! $product ) {
		return;
	}

	$product_id      = $product->get_id();
	$_rating_average = $product->get_average_rating();
	$count           = $product->get_review_count();

	$questions = get_comments(
		array(
			'type'    => 'question',
			'post_id' => $product_id,
			'status'  => 'approve',
		)
	);

	$question_count = count( $questions );

	?>
	<div class="reviews-summary">
		<div class="content-review">
			<div class="review-content">
				<div class="rating-average secondary-font primary-color"><?php echo esc_html( $_rating_average ); ?></div>

				<?php
				Azo_Templates::render_rating(
					$_rating_average,
					array(
						'wrapper_class' => 'entry-product-star-rating',
					)
				);
				?>

				<div class="reviews-count">
					<?php
					$reviews_count_text = sprintf( esc_html( _n( '%1$s Review', '%1$s Reviews', $count, 'azo' ) ), $count );
					echo esc_html( $reviews_count_text );

					$question_count_text = _n( 'Q&#38;A', 'Q&#38;As', $question_count, 'azo' );
					echo ', <span class="question-count">' . $question_count . '</span> ' . esc_html( $question_count_text );
					?>
				</div>
			</div>

			<div class="bar-review">
				<?php custom_woo_reviews_summary(); ?>
			</div>
		</div>

		<div class="reviews-summary-buttons">
			<?php
			if ( comments_open() ) :
				render_button(
					array(
						'wrapper_class' => 'woocommerce-review-btn',
						'extra_class'   => 'button-alt',
						'text'          => esc_html__( 'Write a review', 'azo' ),
						'link'          => array(
							'url' => '#tab-reviews',
						),
						'icon'          => 'ph-pencil',
					)
				);

				render_button(
					array(
						'wrapper_class' => 'woocommerce-question-btn',
						'extra_class'   => 'button-alt',
						'text'          => esc_html__( 'Ask a Question', 'azo' ),
						'link'          => array(
							'url' => '#tab-questions',
						),
						'icon'          => 'ph-chats-circle',
					)
				);
			endif;
			?>
		</div>
	</div>
	<?php
}

remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_action( 'woocommerce_after_single_product', 'azo_woocommerce_output_related_products', 35 );
/**
 * Woocommerce output related products
 */
function azo_woocommerce_output_related_products() {
	?>
	<div class="related-azo-bottom">
		<?php
		woocommerce_output_related_products();
		?>
	</div>
	<?php
}

// Build Bought Together.
function azo_bought_together() {
	if ( class_exists( 'WPCleverWoobt' ) ) {
		if ( '' !== do_shortcode( '[woobt]' ) ) {
			?>
			<div class="content-bough-together">
				<h2 class="title-bought">
					<?php esc_html_e( 'Frequently Bought Together', 'azo' ); ?>
				</h2>

				<?php echo do_shortcode( '[woobt]' ); ?>
			</div>
			<?php
		}
	}
}
add_action( 'woocommerce_after_single_product', 'azo_bought_together', 27 );

// Build Content sidebar single.
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

function azo_div_builder_single_sidebar() {
	$class = '';

	if ( false === is_active_sidebar( 'shop-single-widget' ) ) {
		$class = 'no-sidebar-product';
	}
	?>
	<div class="content-shop-single">
		<div class="shop-single-content <?php echo esc_attr( $class ); ?>">
	<?php
}
add_action( 'woocommerce_after_single_product', 'azo_div_builder_single_sidebar', 28 );

add_action( 'woocommerce_after_single_product', 'woocommerce_output_product_data_tabs', 29 );

function azo_div_close_builder_single_sidebar() {
	?>
		</div>

		<?php if ( is_active_sidebar( 'shop-single-widget' ) ) { ?>
			<div class="sidebar-single-product">
				<?php dynamic_sidebar( 'shop-single-widget' ); ?>
			</div>
		<?php } ?>
	</div>
	<?php
}
add_action( 'woocommerce_after_single_product', 'azo_div_close_builder_single_sidebar', 31 );

add_action( 'woocommerce_after_shop_loop_item', 'azo_sold_by_vendor', 9 );
/**
 * Show Store name on the product thumbnail For Dokan Multivendor plugin
 */
function azo_sold_by_vendor() {
	$show_vendor   = get_theme_mod( 'show_sold_by_vendor', 'false' );
	$soldby_vendor = isset( $_GET['soldby_vendor'] ) ? Azo_Helper::data_clean( $_GET['soldby_vendor'] ) : false; //phpcs:ignore;

	if ( defined( 'DOKAN_FILE' ) && 'show' === $soldby_vendor ) {
		global $product;
		$seller = get_post_field( 'post_author', $product->get_id() );
		$author = get_user_by( 'id', $seller );
		$vendor = dokan()->vendor->get( $seller );

		$store_info = dokan_get_store_info( $author->ID );
		if ( ! empty( $store_info['store_name'] ) ) {
			?>
			<span class="details-vendor">
				<?php esc_html_e( 'Sold by: ', 'azo' ); ?>
				<?php printf( '<a href="%s">%s</a>', $vendor->get_shop_url(),  $vendor->get_shop_name() ); ?>
			</span>
			<?php
		}
	}
}

// Custome rating for Vendor.
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
/**
 * Azo rating new product open
 */
function azo_rating_div_open() {
	?>
	<div class="rating-vendor">
	<?php
}
add_action( 'woocommerce_single_product_summary', 'azo_rating_div_open', 14 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 15 );

/**
 * Azo product stock
 */
function azo_product_stock() {
	?>
		<div class="product-stock">
			<?php
			global $product;
			$stock_quantity = $product->get_stock_quantity();

			$sold        = get_theme_mod( 'show_sold', 'false' );
			$layout_sold = isset( $_GET['layout_sold'] ) ? Azo_Helper::data_clean( $_GET['layout_sold'] ) : false; //phpcs:ignore;

			if ( $stock_quantity && 0 !== $stock_quantity ) {
				if ( true === $sold || 'show' === $layout_sold ) {
					$sold = get_post_meta( $product->get_id(), 'total_sales', true );
					?>
					<div class="sold">
						<span class="label"><?php esc_html_e( 'Sold: ', 'azo' ); ?></span>
						<span class="value"><?php echo esc_html( $sold ); ?></span>
					</div>
					<?php
				}
			}

			$position_vendor = get_theme_mod( 'position_vendor_align', 'none' );
			$layout_vendor   = isset( $_GET['layout_vendor'] ) ? Azo_Helper::data_clean( $_GET['layout_vendor'] ) : false; //phpcs:ignore;

			if ( defined( 'DOKAN_FILE' ) && ( 'after_ratting' === $position_vendor || '1' === $layout_vendor ) ) {
				$seller = get_post_field( 'post_author', $product->get_id() );
				$author = get_user_by( 'id', $seller );
				$vendor = dokan()->vendor->get( $seller );

				$store_info = dokan_get_store_info( $author->ID );
				if ( ! empty( $store_info['store_name'] ) ) {
					?>
					<span class="detail-vendor">
						<?php esc_html_e( 'Vendor: ', 'azo' ); ?>
						<?php printf( '<a href="%s">%s</a>', $vendor->get_shop_url(),  $vendor->get_shop_name() ); ?>
					</span>
					<?php
				}
			}
			?>
		</div>
	</div><!-- Azo rating new product close -->
	<?php
}
add_action( 'woocommerce_single_product_summary', 'azo_product_stock', 16 );

/**
 * Azo author vendor
 */
function azo_author_vendor() {
	$position_vendor = get_theme_mod( 'position_vendor_align', 'none' );
	$layout_vendor   = isset( $_GET['layout_vendor'] ) ? Azo_Helper::data_clean( $_GET['layout_vendor'] ) : false; //phpcs:ignore;

	if ( defined( 'DOKAN_FILE' ) && ( 'after_add_to_cart' === $position_vendor || '2' === $layout_vendor ) ) {
		?>
		<div class="product-stock-new">
			<?php
			global $product;
			$seller = get_post_field( 'post_author', $product->get_id() );
			$author = get_user_by( 'id', $seller );
			$vendor = dokan()->vendor->get( $seller );

			$store_info = dokan_get_store_info( $author->ID );

			$store_rating = $vendor->get_rating();

			if ( ! empty( $store_info['store_name'] ) ) {
				?>
				<div class="detail-vendor-new">
					<div class="seller-avatar">
						<a href="<?php echo esc_url( $store_url ); ?>">
							<img src="<?php echo esc_url( $vendor->get_avatar() ); ?>" alt="<?php echo esc_attr( $vendor->get_shop_name() ); ?>" size="65">
						</a>
					</div>

					<div class="store-data-container">
						<p class="sold-by">
							<?php esc_html_e( 'Sold by: ', 'azo' ); ?>
						</p>

						<?php printf( '<a href="%s">%s</a>', $vendor->get_shop_url(),  $vendor->get_shop_name() ); ?>

						<?php if ( ! empty( $store_rating['count'] ) ) { ?>
							<div class="dokan-seller-rating" title="<?php echo sprintf( esc_attr__( 'Rated %s out of 5', 'azo' ), esc_attr( $store_rating['rating'] ) ) ?>">
								<?php echo dokan_generate_ratings( $store_rating['rating'], 5 ); ?>
							</div>
						<?php } ?>
					</div>

					<a href="<?php echo esc_url( $vendor->get_shop_url() ); ?>" class="inquiry">
						<?php esc_html_e( 'Inquiry', 'azo' ); ?>
					</a>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	}
}
add_action( 'woocommerce_single_product_summary', 'azo_author_vendor', 39 );
