<?php
/**
 * WooCommerce Content Product
 *
 * @package azo
 */

add_filter( 'woocommerce_sale_flash', 'azo_sale_flash', 10, 2 );
/**
 * SALE FLASH
 */
function azo_sale_flash() {
	global $product;

	$sale       = $product->is_on_sale();
	$price_sale = $product->get_sale_price();
	$price      = $product->get_regular_price();
	$simple     = $product->is_type( 'simple' );
	$stylesale  = get_theme_mod( 'shop_style_sale', 'stylesale2' );

	if ( $sale && $simple && $product->is_in_stock() && 'stylesale1' === $stylesale ) {
		?>
			<span class="onsale">
				<?php
					$final_price = ( ( $price - $price_sale ) / $price ) * 100;
					echo esc_html__( 'Sale', 'azo' );
				?>
			</span>
		<?php
	}

	if ( $sale && $simple && $product->is_in_stock() && 'stylesale2' === $stylesale ) {
		?>
			<span class="onsale">
				<?php
				if ( $simple ) {
					$final_price = ( ( $price - $price_sale ) / $price ) * 100;
					echo '-' . esc_html( round( $final_price ) ) . '%';
				}
				?>
			</span>
		<?php
	}
}

add_action( 'woocommerce_single_product_summary', 'azo_sale_div', 9 );
/**
 * SALE FLASH DIV
 */
function azo_sale_div() {
	global $product;

	$sale       = $product->is_on_sale();
	$price_sale = $product->get_sale_price();
	$price      = $product->get_regular_price();
	$simple     = $product->is_type( 'simple' );

	if ( $sale && $simple && $product->is_in_stock() ) {
		echo '<div class="sale-div">';
	}
}

add_action( 'woocommerce_single_product_summary', 'azo_sale', 11 );
/**
 * SALE FLASH
 */
function azo_sale() {
	global $product;

	$sale       = $product->is_on_sale();
	$price_sale = $product->get_sale_price();
	$price      = $product->get_regular_price();
	$simple     = $product->is_type( 'simple' );

	if ( $sale && $simple && $product->is_in_stock() ) {
		?>
			<span class="price-onsale">
				<?php
				if ( $simple ) {
					$final_price = ( ( $price - $price_sale ) / $price ) * 100;
					echo 'Saved ' . esc_html( round( $final_price ) ) . '%';
				}
				?>
			</span>
		</div>
		<?php
	}
}

add_filter( 'woocommerce_dropdown_variation_attribute_options_html', 'azo_get_variation_attribute_options_html', 10, 2 );
/**
 * QUICKVIEW
 *
 * @param  [type] $html type.
 * @param  [type] $args type.
 */
function azo_get_variation_attribute_options_html( $html, $args ) {
	if ( ! function_exists( 'TA_WCVS' ) ) {
		return $html;
	}

	$swatch_types = TA_WCVS()->types;
	$attr         = TA_WCVS()->get_tax_attribute( $args['attribute'] );

	if ( empty( $attr ) ) {
		return $html;
	}

	if ( ! array_key_exists( $attr->attribute_type, $swatch_types ) ) {
		return $html;
	}

	$options   = $args['options'];
	$product   = $args['product'];
	$attribute = $args['attribute'];
	$class     = "variation-selector variation-select-{$attr->attribute_type}";
	$swatches  = '';

	if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
		$attributes = $product->get_variation_attributes();
		$options    = $attributes[ $attribute ];
	}

	if ( array_key_exists( $attr->attribute_type, $swatch_types ) ) {
		if ( ! empty( $options ) && $product && taxonomy_exists( $attribute ) ) {
			$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );

			foreach ( $terms as $term ) {
				if ( in_array( $term->slug, $options ) ) { //phpcs:ignore
					$swatches .= apply_filters( 'tawcvs_swatch_html', '', $term, $attr, $args );
				}
			}
		}

		if ( ! empty( $swatches ) ) {
			$class .= ' hidden';

			$swatches = '<div class="tawcvs-swatches" data-attribute_name="attribute_' . esc_attr( $attribute ) . '">' . $swatches . '</div>';
			$html     = '<div class="' . esc_attr( $class ) . '">' . $html . '</div>' . $swatches;
		}
	}

	return $html;
}

add_filter( 'tawcvs_swatch_html', 'azo_swatch_html', 5, 4 );
/**
 * Azo swatch html
 *
 * @param  [type] $html type.
 * @param  [type] $term type.
 * @param  [type] $type type.
 * @param  [type] $args type.
 */
function azo_swatch_html( $html, $term, $type, $args ) {
	if ( ! function_exists( 'TA_WCVS' ) ) {
		return $html;
	}

	$selected = sanitize_title( $args['selected'] ) === $term->slug ? 'selected' : '';
	$name     = esc_html( apply_filters( 'woocommerce_variation_option_name', $term->name ) );

	switch ( $type ) {
		case 'color':
			$color             = get_term_meta( $term->term_id, 'color', true );
			list( $r, $g, $b ) = sscanf( $color, "#%02x%02x%02x" ); //phpcs:ignore
			$html              = sprintf(
				'<span class="swatch swatch-color swatch-%s %s" style="background-color:%s;color:%s;" title="%s" data-value="%s">%s</span>',
				esc_attr( $term->slug ),
				$selected,
				esc_attr( $color ),
				"rgba($r,$g,$b,0.5)",
				esc_attr( $name ),
				esc_attr( $term->slug ),
				$name
			);
			break;

		case 'image':
			$image = get_term_meta( $term->term_id, 'image', true );
			$image = $image ? wp_get_attachment_image_src( $image ) : '';
			$image = $image ? $image[0] : WC()->plugin_url() . '/assets/images/placeholder.png';
			$html  = sprintf(
				'<span class="swatch swatch-image swatch-%s %s" title="%s" data-value="%s"><img src="%s" alt="%s">%s</span>',
				esc_attr( $term->slug ),
				$selected,
				esc_attr( $name ),
				esc_attr( $term->slug ),
				esc_url( $image ),
				esc_attr( $name ),
				esc_attr( $name )
			);
			break;

		case 'label':
			$label = get_term_meta( $term->term_id, 'label', true );
			$label = $label ? $label : $name;
			$html  = sprintf(
				'<span class="swatch swatch-label swatch-%s %s" title="%s" data-value="%s">%s</span>',
				esc_attr( $term->slug ),
				$selected,
				esc_attr( $name ),
				esc_attr( $term->slug ),
				esc_html( $label )
			);
			break;
	}

	return $html;
}

add_action( 'wp_ajax_quick_view', 'azo_quick_view' );
add_action( 'wp_ajax_nopriv_quick_view', 'azo_quick_view' );
if ( ! function_exists( 'azo_quick_view' ) ) {
	/**
	 * Azo quick view
	 */
	function azo_quick_view() {
		$response = array(
			'status'  => 500,
			'message' => esc_html__( 'Something is wrong, please try again later...', 'azo' ),
			'content' => false,
		);

		if ( ! isset( $_POST['product_id'] ) ||
			! isset( $_POST['nonce'] ) ||
			! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'azo_product_nonce' ) ) :

			echo wp_json_encode( $response );
			exit();
		endif;

		$product_id = intval( $_POST['product_id'] );

		/*FOR `cazos-sells` CART PAGE*/
		$get_product = wc_get_product( $product_id );
		$parent_id   = $get_product->get_parent_id();
		if ( $parent_id ) {
			$product_id = $parent_id;
		}

		wp( 'p=' . $product_id . '&post_type=product' );

		ob_start();

		if ( have_posts() ) {
			while ( have_posts() ) :
				the_post();
				?>
				<div <?php wc_product_class(); ?>>
					<?php
					$product   = wc_get_product( $product_id );
					$image_id  = $product->get_image_id();
					$image_alt = azo_img_alt( $image_id, esc_attr__( 'product image', 'azo' ) );

					if ( $image_id ) {
						$image_medium_src = wp_get_attachment_image_src( $image_id, 'woocommerce_single' );
					} else {
						$image_medium_src[0] = wc_placeholder_img_src();
					}

					$gallery_id = $product->get_gallery_image_ids();
					$attr       = '';

					if ( ! empty( $gallery_id ) ) {
						$attr = 'class="quick-view-slider"';
					}

					$attachment_ids   = $product->get_gallery_image_ids();
					$attachment_count = count( $gallery_id );
					$attributes       = array(
						'title' => esc_attr( get_the_title( get_post_thumbnail_id() ) ),
					);
					?>
					<div class="quick-view-images">
						<div id="quick-view-gallery" <?php echo wp_kses( $attr, azo_get_allowed_html() ); ?>>
							<?php
							if ( has_post_thumbnail() ) {
								echo '<figure class="woocommerce-product-gallery__image">' . get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'woocommerce_single' ), $attributes ) . '</figure>';

								if ( $attachment_count > 0 ) {
									foreach ( $attachment_ids as $attachment_id ) {
										echo '<div class="product-image-wrap"><figure class="woocommerce-product-gallery__image">' . wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', 'woocommerce_single' ), false, array( 'class' => apply_filters( 'azo_single_product_gallery_image_class', 'wp-post-image' ) ) ) . '</figure></div>';
									}
								}
							} else {
								?>
								<figure class="woocommerce-product-gallery__image--placeholder">
									<?php
									apply_filters(
										'woocommerce_single_product_image_html',
										sprintf( '<img src="%s" alt="%s" />', wc_placeholder_img_src(), esc_html_e( 'Placeholder', 'azo' ) ),
										$post->ID
									);
									?>
								</figure>
								<?php
							}
							?>
						</div>

						<?php /* PRODUCT LABEL */ ?>
						<?php azo_product_label( $product ); ?>
					</div>

					<div class="summary entry-summary">
						<?php do_action( 'woocommerce_single_product_summary' ); ?>
					</div>
				</div>

				<?php
				$response = array(
					'status' => 200,
				);
				endwhile;
		} else {
			$response = array(
				'status'  => 201,
				'message' => esc_html__( 'Sorry, nothing found', 'azo' ),
			);
		}

		$response['content'] = ob_get_clean();

		echo wp_json_encode( $response );
		exit();
	}
}

if ( ! function_exists( 'azo_image_alt' ) ) {
	/**
	 * Get image alt
	 *
	 * @param      bolean $id          The image id.
	 * @param      string $alt         The alternate.
	 * @param      bolean $placeholder The bolean.
	 *
	 * @return     string  The image alt
	 */
	function azo_image_alt( $id = null, $alt = '', $placeholder = false ) {
		if ( ! $id ) {
			if ( $placeholder ) {
				return esc_attr__( 'Placeholder image', 'azo' );
			}
			return esc_attr__( 'Error image', 'azo' );
		}

		$data    = get_post_meta( $id, '_wp_attachment_image_alt', true );
		$img_alt = ! empty( $data ) ? $data : $alt;

		return $img_alt;
	}
}

if ( ! function_exists( 'azo_get_product_thumbnail' ) ) {
	/**
	 * Loop product image
	 */
	function azo_get_product_thumbnail() {
		global $product;

		if ( ! $product ) {
			return '';
		}

		$size       = 'woocommerce_thumbnail';
		$img_id     = $product->get_image_id();
		$img_alt    = azo_image_alt( $img_id, esc_attr__( 'Product image', 'azo' ) );
		$img_origin = wp_get_attachment_image_src( $img_id, $size );
		$image_attr = array(
			'alt'      => $img_alt,
			'data-src' => $img_origin[0],
			'class'    => 'attachment-' . $size . ' size-' . $size . ' product-loop-image',
		);

		return $product->get_image( $size, $image_attr );
	}
}

/* ADD PERMALINK TO LOOP PRODUCT TITLE */
add_action(
	'init',
	function () {
		// removing the woocommerce hook.
		remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
		remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
		remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	}
);

add_action( 'woocommerce_shop_loop_item_title', 'azo_template_loop_product_title', 11 );
/**
 * Azo template loop product title
 */
function azo_template_loop_product_title() {
	?>
	<div class="content-info-product">
		<div class="product-information">
			<?php if ( true === get_theme_mod( 'shop_category' ) ) { ?>
				<div class="azo-product-cats">
					<?php
					global $product;
					echo wp_kses( wc_get_product_category_list( $product->get_id() ), azo_get_allowed_html() );
					?>
				</div>
			<?php } ?>

			<a href="<?php echo esc_url( get_permalink() ); ?> ">
				<h2 class="woocommerce-loop-product__title">
					<?php echo esc_html( get_the_title() ); ?>
				</h2>
	<?php
}

/**
 * Azo close contentinfoproduct
 */
function azo_close_contentinfoproduct() {
	// Close div content-info-product.
	?>
	</div>
	<!-- /.content-info-product -->
	<?php
}
add_action( 'woocommerce_after_shop_loop_item', 'azo_close_contentinfoproduct', 11 );

add_action( 'woocommerce_before_shop_loop_item_title', 'azo_wrap_product_image', 10 );
/**
 * WRAP PRODUCT THUMBNAIL INSIDE `.product-image-wrapper`
 *
 * @param  string $size type.
 * @param  array  $args type.
 */
function azo_wrap_product_image( $size = 'woocommerce_thumbnail', $args = array() ) {
	global $product;

	$image_size = apply_filters( 'single_product_archive_thumbnail_size', $size );

	$gallery = $product->get_gallery_image_ids();

	if ( $product ) {
		?>
		<div class="product-image-wrapper">
			<?php
			// PRODUCT IMAGE open tag <a>.
			woocommerce_template_loop_product_link_open();

            echo azo_get_product_thumbnail();

			/* HOVER IMAGE */
			if ( ! empty( $gallery ) ) {
				$hover = wp_get_attachment_image_src( $gallery[0], $image_size );
				?>
				<img class="hover-product-image" src="<?php echo esc_url( $hover[0] ); ?>" alt="<?php esc_attr_e( 'image-product-hover', 'azo' ); ?>">
				<?php
			}
			// close tag </a>.

			woocommerce_template_loop_product_link_close();

			/* LOOP ACTION */
			$loop_action_classes = 'loop-action';
			$quick_action        = get_theme_mod( 'quick_action', 'false' );
			if ( $quick_action ) {
				$loop_action_classes .= ' loop-action--visible-on-mobile';
			}
			?>
			<div class="<?php echo esc_attr( $loop_action_classes ); ?>">
				<?php
				/*SHOW IN QUICK VIEW BTN*/
				if ( '0' !== get_theme_mod( 'shop_archive_quick_view', '1' ) ) {
					?>
					<div class="product-quick-view-btn hint--bounce hint--left" data-hint="<?php esc_attr_e( 'Quick view', 'azo' ); ?>" data-pid="<?php echo esc_attr( $product->get_id() ); ?>">
						<span class="icoros-icon_view"></span>
					</div>
					<?php
				}

				/*ADD TO WISHLIST BUTTON*/
				if ( '0' !== get_theme_mod( 'shop_archive_wishlist', '1' ) ) {
					echo wp_kses( azo_get_wishlist_button_template(), azo_get_allowed_html() );
				}

				/*Show compare button*/
				if ( '0' !== get_theme_mod( 'shop_archive_compare', '1' ) ) {
					echo wp_kses( azo_get_compare_button_template(), azo_get_allowed_html() );
				}
				?>
			</div>

			<?php /* PRODUCT LABEL */ ?>
			<?php echo wp_kses( azo_product_label( $product ), azo_get_allowed_html() ); ?>
		</div>
		<?php
	}
}

/**
 * Azo get wishlist button template
 */
function azo_get_wishlist_button_template() {
	if ( class_exists( 'WPCleverWoosw' ) ) {
		global $product;
		$product_id = $product->get_id();
		?>
		<div class="product-action-wishlist hint--bounce hint--left" data-hint="<?php esc_attr_e( 'Add to Wishlist', 'azo' ); ?>">
			<?php echo do_shortcode( '[woosw id="' . $product_id . '" type="link"]' ); ?>
		</div>
		<?php
	}
}

/**
 * Azo get compare button template
 */
function azo_get_compare_button_template() {
	if ( class_exists( 'WPCleverWoosc' ) ) {
		global $product;
		$product_id = $product->get_id();
		?>
		<div class="product-action-compare hint--bounce hint--left" data-hint="<?php esc_attr_e( 'Compare', 'azo' ); ?>">
			<?php echo do_shortcode( '[woosc id="' . $product_id . '" type="link"]' ); ?>
		</div>
		<?php
	}
}


if ( ! function_exists( 'azo_modify_loop_add_to_cart_class' ) ) {
	/**
	 * Modify loop add to cart class name
	 */
	function azo_modify_loop_add_to_cart_class() {
		global $product;

		$args = array(
			'class'      => implode(
				' ',
				array_filter(
					array(
						'azo-add-to-cart-btn button',
						'button',
						'product_type_' . $product->get_type(),
						$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
						$product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
					)
				)
			),
			'attributes' => array(
				'data-product_id'  => $product->get_id(),
				'data-product_sku' => $product->get_sku(),
				'title'            => $product->add_to_cart_description(),
				'rel'              => 'nofollow',
			),
		);

		return $args;
	}
}

if ( ! function_exists( 'azo_modified_add_to_cart_button' ) ) {
	/**
	 * Woostify add to cart button
	 */
	function azo_modified_add_to_cart_button() {
		$args = azo_modify_loop_add_to_cart_class();
		woocommerce_template_loop_add_to_cart( $args );
	}
}

/**
 * Adjust the quantity input values
 */
add_filter( 'woocommerce_quantity_input_args', 'azo_woocommerce_quantity_input_args', 10, 2 ); // Simple products.

/**
 * Azo woocommerce quantity input args
 *
 * @param  [type] $args    type.
 * @param  [type] $product type.
 */
function azo_woocommerce_quantity_input_args( $args, $product ) {
	if ( is_singular( 'product' ) ) {
		$args['input_value'] = 1;
	}
	$args['min_value'] = 1; // Minimum value.
	$args['step']      = 1; // Quantity steps.
	return $args;
}

add_filter( 'woocommerce_available_variation', 'azo_woocommerce_available_variation' ); // Variations.

/**
 * Azo woocommerce available variation
 *
 * @param  [type] $args type.
 */
function azo_woocommerce_available_variation( $args ) {
	$args['min_qty'] = 1; // Minimum value (variations).
	return $args;
}

/* REMOVE DEFAULT OPEN AND CLOSE A TAG WRAP PRODUCT IMAGE */
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );

add_action( 'woocommerce_before_shop_loop_item', 'azo_woocommerce_add_aff_link_open', 10 );
/**
 * Azo woocommerce add aff link open
 */
function azo_woocommerce_add_aff_link_open() {
	?>
	<div class="azo-style">
		<div class="content-product-imagin"></div>
	<?php
}

/**
 * Azo product stock bar
 */
function azo_product_stock_bar() {
	global $product;
	$stock_quantity = $product->get_stock_quantity();
	if ( $stock_quantity && 0 !== $stock_quantity ) {
		$sold        = get_post_meta( $product->get_id(), 'total_sales', true );
		$stock_first = (int) ( $stock_quantity + $sold );
		$available   = (float) ( 100 - ( 100 / $stock_first ) * ( $stock_quantity ) );
		?>

		<div class="loop-product-stock">
			<div class="product-stock-status">
				<span class="label"><?php esc_html_e( 'Sold: ', 'azo' ); ?></span>

				<div class="sold">
					<span class="value"><?php echo esc_html( $sold ); ?></span>
				</div>

				<?php esc_html_e( '/', 'azo' ); ?>

				<div class="available">
					<span class="value"><?php echo esc_html( $stock_quantity ); ?></span>
				</div>
			</div>

			<div class="status-bar">
				<div class="sold-bar" style="width: <?php echo esc_attr( $available ); ?>%"></div>
			</div>
		</div>
		<?php
	}
}
if ( true === get_theme_mod( 'show_stock_bar', false ) ) {
	add_action( 'woocommerce_shop_loop_item_title', 'azo_product_stock_bar', 10 );
}

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'azo_woocommerce_add_aff_link_close', 12 );
/**
 * Azo woocommerce add aff link close
 */
function azo_woocommerce_add_aff_link_close() {
	?>
		</div>
	</div>
	<!-- /.close-wrapper -->
	<?php
}

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'azo_transform_price', 8 );
/**
 * Product information
 */
function azo_transform_price() {
	?>
	<div class="azo-transform-price">
		<div class="azo-transform-loop-price">
			<?php wc_get_template( 'loop/price.php' ); ?>
		</div>

		<div class="azo-transform-loop-buttons">
			<?php azo_modified_add_to_cart_button(); ?>
		</div>
	</div>
	<?php
}

/**
 * Azo woo add custom general field
 */
function azo_woo_add_custom_general_field() {
	global $woocommerce, $post;

	echo '<div class="options_group">';

	// Checkbox.
	woocommerce_wp_checkbox(
		array(
			'id'            => '_checkbox',
			'wrapper_class' => '',
			'label'         => __( 'Hot', 'azo' ),
			'description'   => __( 'Check for Hot Product', 'azo' ),
		)
	);

	echo '</div>';
}

/**
 * Azo woo add custom general fields save
 *
 * @param  [type] $post_id type.
 */
function azo_woo_add_custom_general_fields_save( $post_id ) {
	$woocommerce_checkbox = isset( $_POST['_checkbox'] ) ? 'yes' : 'no'; //phpcs:ignore
	update_post_meta( $post_id, '_checkbox', $woocommerce_checkbox );
}

// Save Fields.
add_action( 'woocommerce_process_product_meta', 'azo_woo_add_custom_general_fields_save' );

// Display Fields.
add_action( 'woocommerce_product_options_general_product_data', 'azo_woo_add_custom_general_field' );

/**
 * Azo woo add new product
 */
function azo_woo_add_new_product() {
	global $woocommerce, $post;

	echo '<div class="options_group">';

	// Checkbox.
	woocommerce_wp_checkbox(
		array(
			'id'            => '_checkboxnewproduct',
			'wrapper_class' => '',
			'label'         => __( 'New', 'azo' ),
			'description'   => __( 'Check for New Product', 'azo' ),
		)
	);

	echo '</div>';
}

/**
 * Azo woo add custom general fields save
 *
 * @param  [type] $post_id type.
 */
function azo_woo_add_new_products_save( $post_id ) {
	$woocommerce_new_checkbox = isset( $_POST['_checkboxnewproduct'] ) ? 'yes' : 'no'; //phpcs:ignore
	update_post_meta( $post_id, '_checkboxnewproduct', $woocommerce_new_checkbox );
}

// Display Fields.
add_action( 'woocommerce_product_options_general_product_data', 'azo_woo_add_new_product' );
// Save Fields.
add_action( 'woocommerce_process_product_meta', 'azo_woo_add_new_products_save' );

/**
 * Azo custom new & hot product
 */
function azo_custom_field_product() {
	global $product;
	$id     = $product->get_id();
	$is_hot = get_post_meta( $id, '_checkbox', true );
	$is_new = get_post_meta( $id, '_checkboxnewproduct', true );
	$sale   = $product->is_on_sale();

	if ( $sale ) {
		$is_sale = 'sale-product';
	} else {
		$is_sale = '';
	}

	?>
	<span class="open-label-shop <?php echo esc_attr( $is_sale ); ?>">
		<?php
		if ( $product->is_in_stock() && 'yes' === $is_new ) {
			?>
				<span class="new-product">
					<?php esc_html_e( 'New!', 'azo' ); ?>
				</span>
			<?php
		}

		if ( $product->is_in_stock() && 'yes' === $is_hot ) {
			?>
				<span class="hot-product">
					<?php esc_html_e( 'Hot', 'azo' ); ?>
				</span>
			<?php
		}
		?>
	</span>
	<?php
}

