<?php
/**
 * Archive Shop
 *
 * @package azo
 */

/*TOP BAR*/

add_action( 'woocommerce_before_shop_loop', 'azo_top_bar_wrap_open', 15 );
/**
 * Shop top bar open div
 */
function azo_top_bar_wrap_open() {
	?>
	<div class="shop-top-bar">
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_top_bar_left_open', 20 );
/**
 * Shop top bar left open div
 */
function azo_top_bar_left_open() {
	?>
	<div class="shop-top-bar-left">
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_button_filter_toggle', 20 );
/**
 * Filter toggle button
 */
function azo_button_filter_toggle() {
	if ( ! get_theme_mod( 'filter_area', false ) || 'full' !== get_theme_mod( 'shop_sidebar', 'full' ) ) {
		return;
	}
	?>
	<button class="filter-toggle-btn js-filter-toggle-btn"><i class="ti-filter"></i><span><?php echo esc_html__( 'Filters', 'azo' ); ?></span></button>
	<?php
}

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
add_action( 'woocommerce_before_shop_loop', 'azo_result_count', 20 );

/**
 * Azo result count
 */
function azo_result_count() {
	if ( ! get_theme_mod( 'result_count', true ) ) {
		return;
	}

	$total = wc_get_loop_prop( 'total' );
	/* translators: %s: Result count */
	$result = sprintf( _n( '%s product', '%s products', $total, 'azo' ), $total );
	/* translators: %s: result count html */
	printf( '<p class="woocommerce-result-count">There are <span>%s</span> available</p>', esc_html( $result ) );
}

add_action( 'woocommerce_before_shop_loop', 'azo_top_bar_left_close', 25 );
/**
 * Shop top bar left close div
 */
function azo_top_bar_left_close() {
	?>
	</div>
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_shop_tools_open_div', 25 );
/**
 * Shop tools open div
 */
function azo_shop_tools_open_div() {
	?>
	<div class="azo-shop-tools">
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_shop_tools_products_per_page', 25 );
/**
 * Shop tools: Products per page
 */
function azo_shop_tools_products_per_page() {
	if ( ! get_theme_mod( 'tool_product_per_page', true ) ) {
		return;
	}

	global $wp;
	$values = array( 12, 24, -1 );
	apply_filters( 'woostify_shop_tools_products_per_page_values', $values );
	$values_count  = count( $values );
	$curr_per_page = isset( $_GET['per_page'] ) ? (int) $_GET['per_page'] : ''; //phpcs:ignore

	$curr_uri          = home_url( add_query_arg( null, null ) );
	$curr_query_string = isset( explode( '?', $curr_uri )[1] ) ? explode( '?', $curr_uri )[1] : '';
	parse_str( $curr_query_string, $params );
	?>
	<div class="azo-products-per-page">
		<div class="per-page-title"><?php esc_html_e( 'Show', 'azo' ); ?></div>
		<div class="per-page-variation-wrap">
			<?php
			for ( $i = 0; $i < $values_count; $i++ ) {
				$params['per_page'] = $values[ $i ];
				$param_str          = array_map(
					function ( $v, $k ) {
						return sprintf( '%s=%s', $k, $v ); },
					$params,
					array_keys( $params )
				);
				$current_url        = add_query_arg( implode( '&', $param_str ), '', home_url( $wp->request ) );
				?>
				<a href="<?php echo esc_url( $current_url ); ?>" rel="nofollow noopener" data-per_page="<?php echo esc_attr( $values[ $i ] ); ?>" class="per-page-variation <?php echo ( '' !== $curr_per_page && $curr_per_page === $values[ $i ] ) ? 'active' : ''; ?> ">
					<span><?php echo -1 !== $values[ $i ] ? (int) $values[ $i ] : esc_html__( 'All', 'azo' ); ?></span>
				</a>
			<?php } ?>
		</div>
	</div>
	<?php
}

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
add_action( 'woocommerce_before_shop_loop', 'azo_catalog_ordering', 30 );

/**
 * Azo Catalog Ordering
 */
function azo_catalog_ordering() {
	if ( ! get_theme_mod( 'ordering_woocommerce', true ) ) {
		return;
	}
	?>
		<div class="azo-woo-ordering">
			<span class="azo-sort-label"><?php echo esc_html__( 'Sort By', 'azo' ); ?></span>
			<?php woocommerce_catalog_ordering(); ?>
		</div>

	<?php
}

/**
 * Woocommerce catalog orderingd
 */
function woocommerce_catalog_ordering() {
	if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
		return;
	}
	$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
	$catalog_orderby_options = apply_filters(
		'woocommerce_catalog_orderby',
		array(
			'menu_order' => __( 'Default sorting', 'azo' ),
			'popularity' => __( 'Popularity', 'azo' ),
			'rating'     => __( 'Average rating', 'azo' ),
			'date'       => __( 'Latest', 'azo' ),
			'price'      => __( 'Price: low to high', 'azo' ),
			'price-desc' => __( 'Price: high to low', 'azo' ),
		)
	);

	$default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
	$orderby         = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby; // WPCS: sanitization ok, input var ok, CSRF ok.

	if ( wc_get_loop_prop( 'is_search' ) ) {
		$catalog_orderby_options = array_merge( array( 'relevance' => __( 'Relevance', 'azo' ) ), $catalog_orderby_options );

		unset( $catalog_orderby_options['menu_order'] );
	}

	if ( ! $show_default_orderby ) {
		unset( $catalog_orderby_options['menu_order'] );
	}

	if ( ! wc_review_ratings_enabled() ) {
		unset( $catalog_orderby_options['rating'] );
	}

	if ( ! array_key_exists( $orderby, $catalog_orderby_options ) ) {
		$orderby = current( array_keys( $catalog_orderby_options ) );
	}

	wc_get_template(
		'loop/orderby.php',
		array(
			'catalog_orderby_options' => $catalog_orderby_options,
			'orderby'                 => $orderby,
			'show_default_orderby'    => $show_default_orderby,
		)
	);
}

add_action( 'woocommerce_before_shop_loop', 'azo_shop_tools_close_div', 30 );
/**
 * Shop tools close div
 */
function azo_shop_tools_close_div() {
	?>
	</div>
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_top_bar_wrap_close', 35 );
/**
 * Shop top bar close div
 */
function azo_top_bar_wrap_close() {
	?>
	</div>
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_shop_filter_top', 40 );
/**
 * Shop Filter top
 */
function azo_shop_filter_top() {
	if ( ! get_theme_mod( 'filter_area', false ) || 'full' !== get_theme_mod( 'shop_sidebar', 'full' ) ) {
		return;
	}
	?>
	<div class="azo-shop-filter">
		<div class="azo-shop-filter-container">
		<?php dynamic_sidebar( 'shop-filter-widget' ); ?>
		</div>
	</div>
	<?php
}

add_action( 'woocommerce_before_shop_loop', 'azo_top_bar_actived_filters', 45 );
/**
 * Shop actived filters
 */
function azo_top_bar_actived_filters() {
	if ( ! get_theme_mod( 'filter_area', false ) || 'full' !== get_theme_mod( 'shop_sidebar', 'full' ) ) {
		return;
	}
	?>
	<?php the_widget( 'Azo_Widget_Active_Filters', 'title=' ); ?>
	<?php
}

/**
 * Change number of products that are displayed per page (shop page)
 *
 * @param  [type] $cols type.
 */
function azo_new_loop_shop_per_page( $cols ) {
	$cols = get_theme_mod( 'shop_archive_number_item', 12 );
	return $cols;
}
add_filter( 'loop_shop_per_page', 'azo_new_loop_shop_per_page', 20 );

/* ADD SWATCHES LIST */
if ( is_shop() || is_product() ) {
	add_filter( 'woocommerce_after_shop_loop_item_title', 'azo_loop_add_to_cart', 9 );
}

/**
 * Azo loop add to_cart
 */
function azo_loop_add_to_cart() {
	echo azo_swatches_list(); //phpcs:ignore
}

if ( ! function_exists( 'azo_swatches_list' ) ) {
	/**
	 * SWATCH LIST FOR VARIABLE PRODUCT ON ARCHIVE && PRODUCTS WIDGET
	 *
	 * @param string $size type.
	 */
	function azo_swatches_list( $size = 'woocommerce_single' ) {
		global $product;

		$output       = '';
		$color_output = $image_output = $label_output = ''; //phpcs:ignore
		$pid          = $product->get_id();

		if ( empty( $pid ) || ! $product->is_type( 'variable' ) ) {
			return $output;
		}

		$default_attr = method_exists( $product, 'get_default_attributes' ) ? $product->get_default_attributes() : array();
		$vars         = $product->get_available_variations();
		$attributes   = $product->get_attributes();

		if ( empty( $attributes ) ) {
			return $output;
		}

		foreach ( $attributes as $key ) {
			$attr_name = $key['name'];

			$terms = wc_get_product_terms( $pid, $attr_name, array( 'fields' => 'all' ) );

			/*GET TYPE OF PRODUCT ATTRIBUTE BY ID*/
			$attr_type = wc_get_attribute( $key['id'] );

			if ( empty( $terms ) ) {
				return $output;
			}

			$id_slug = $id_name = array(); //phpcs:ignore

			foreach ( $terms as $val ) {
				$id_slug[ $val->term_id ] = $val->slug;
				$id_name[ $val->name ]    = $val->slug;
			}

			$color     = $img_id = $label = ''; //phpcs:ignore
			$empty_arr = array();

			foreach ( $vars as $key ) {
				$slug = isset( $key['attributes']['attribute_' . $attr_name] ) ? $key['attributes']['attribute_' . $attr_name] : ''; //phpcs:ignore

				if ( ! in_array( $slug, $empty_arr ) ) { //phpcs:ignore
					array_push( $empty_arr, $slug );
				} else {
					continue;
				}

				if ( empty( $slug ) ) {
					continue;
				}

				$_id    = array_search( $slug, $id_slug ); //phpcs:ignore
				$name   = array_search( $slug, $id_name ); //phpcs:ignore
				$src    = wp_get_attachment_image_src( $key['image_id'], $size );
				$_class = ( isset( $default_attr[$attr_name] ) && $slug == $default_attr[$attr_name] ) ? 'active' : ''; //phpcs:ignore

				switch ( $attr_type->type ) {
					case 'color':
						$color         = get_term_meta( $_id, 'color', true );
						$color_output .= '<span class="p-attr-swatch p-attr-color ' . esc_attr( $_class) . '" title="' . esc_attr( $name ) . '" data-src="' . esc_attr( $src[0] ) . '" style="background-color:' . esc_attr( $color ) . '"></span>'; //phpcs:ignore
						break;

					case 'image':
						$img_id        = get_term_meta( $_id, 'image', true );
						$img_alt       = azo_img_alt( $img_id, esc_attr__( 'Swatch image', 'azo' ) );
						$image_output .= '<span class="p-attr-swatch p-attr-image '. esc_attr( $_class) .'" title="'. esc_attr( $name ) .'" data-src="'. esc_attr( $src[0] ) .'"><img src="' . wp_get_attachment_url( $img_id ) . '" alt="'. esc_attr( $img_alt ) .'"></span>'; //phpcs:ignore
						break;

					case 'label':
						$label         = get_term_meta( $_id, 'label', true );
						$label_output .= '<span class="p-attr-swatch p-attr-label '. esc_attr( $_class) .'" title="'. esc_attr( $name ) .'" data-src="'. esc_attr( $src[0] ) .'">'. esc_html( $label ) .'</span>'; //phpcs:ignore
						break;
				}
			}
		}

		if ( ! empty( $color_output ) ) {
			$output .= $color_output;
		} elseif ( ! empty( $image_output ) ) {
			$output .= $image_output;
		} else {
			$output .= $label_output;
		}

		return '<div class="pro-swatch-list">' . $output . '</div>';
	}
}

if ( ! function_exists( 'azo_brand_shop' ) ) {
	/**
	 * Azo search product
	 */
	function azo_brand_shop() {
		$shop_layout        = get_theme_mod( 'show_brand_slider' );
		$shop_layout_preset = isset( $_GET['shop_preset'] ) ? Azo_Helper::data_clean( $_GET['shop_preset'] ) : false;

		if ( is_404() || is_product() || is_product_category() || ! class_exists( 'QL_Widget' ) ) {
			return;
		}

		if ( true === $shop_layout || 'brand' === $shop_layout_preset ) {
			?>
			<div class="shop-container-slider-brand">
				<div class="brand-slider-shop">
					<?php
					$args = array(
						'taxonomy' => 'pwb-brand',
					);

					$product_brands = get_terms( $args );

					?>
					<div class="azo-brand-slider-shop">
						<?php
						foreach ( $product_brands as $brand ) {
							$brands_in_loop  = get_option( 'wc_pwb_admin_tab_brands_in_loop' );
							$brand_link      = get_term_link( $brand->term_id, 'pwb-brand' );
							$attachment_id   = get_term_meta( $brand->term_id, 'pwb_brand_image', 1 );
							$attachment_html = wp_get_attachment_image( $attachment_id, array( 140, 80 ) );
							?>
							<div class="product-brand-azo">
								<div class="container-brand">
									<a href="<?php echo esc_url( $brand_link ); ?>">
										<div class="product-brand-azo-image">
											<?php echo wp_kses_decode_entities( $attachment_html ); ?>
										</div>
									</a>
								</div>
							</div>
							<?php
						}

						wp_reset_postdata();
						?>
					</div>

					<div class="brand-slider-arrow">
						<button class="arrows-prev"></button>
						<button class="arrows-next"></button>
					</div>
				</div>
			</div>
			<?php
		}
	}
}
add_action( 'woocommerce_before_main_content', 'azo_brand_shop', 23 );

if ( ! function_exists( 'azo_header_shop_product' ) ) {
	/**
	 * Azo search product
	 */
	function azo_header_shop_product() {
		if ( is_404() ) {
			return;
		}

		$shop_header        = get_theme_mod( 'show_shop_header', false );
		$shop_layout_preset = isset( $_GET['shop_preset'] ) ? Azo_Helper::data_clean( $_GET['shop_preset'] ) : false;

		if ( is_shop() && ( true === $shop_header || 'header' === $shop_layout_preset ) ) {
			?>
			<div class="azo-pageheader-shop">
				<div class="box-pageheader-shop">
					<span class="shop-description">
						<?php esc_html_e( 'NEW ARRIVAL', 'azo' ); ?>
					</span>

					<h2 class="shop-title">
						<?php echo wp_kses( 'GET THE PACK<br /><span class="text-new">20% OFF</span>', azo_get_allowed_html() ); ?>
					</h2>
				</div>
			</div>
			<?php
		}
	}
}
add_action( 'woocommerce_before_main_content', 'azo_header_shop_product', 22 );

if ( ! function_exists( 'azo_category_shop' ) ) {
	/**
	 * Azo search product
	 */
	function azo_category_shop() {
		$shop_category      = get_theme_mod( 'show_category_slider', false );
		$shop_layout_preset = isset( $_GET['shop_preset'] ) ? Azo_Helper::data_clean( $_GET['shop_preset'] ) : false;

		if ( is_404() || is_product() || is_product_category() ) {
			return;
		}

		if ( true === $shop_category || 'category' === $shop_layout_preset ) {
			?>
			<div class="shop-container-slider-category">
				<div class="container">
					<div class="category-slider-shop">
						<?php
						$args = array(
							'taxonomy' => 'product_cat',
						);

						$product_categories = get_terms( $args );

						?>
						<div class="azo-category-slider-shop">
							<?php
							foreach ( $product_categories as $cat ) {
								$thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
								$image_url    = wp_get_attachment_url( $thumbnail_id );
								?>
								<div class="product-category-azo">
									<div class="container-category">
										<?php if ( false !== $image_url ) { ?>
											<div class="product-category-azo-image">
												<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_html( $cat->name ); ?>" class="">
											</div>
										<?php } ?>

										<a href="<?php echo esc_url( get_category_link( $cat->term_id ) ); ?>" class="category-product-name">
											<?php echo esc_html( $cat->name ); ?>
										</a>
									</div>
								</div>
								<?php
							}

							wp_reset_postdata();
							?>
						</div>

						<div class="category-slider-arrow">
							<button class="arrows-prev"></button>
							<button class="arrows-next"></button>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}
}
add_action( 'woocommerce_before_main_content', 'azo_category_shop', 4 );

/**
 * Replace star ratings
 *
 * @param  [type] $html   type.
 * @param  [type] $rating type.
 */
function azo_replace_star_ratings( $html, $rating ) {
	$html = ''; // Erase default HTML.

	for ( $i = 0; $i < 5; $i++ ) {
		$html .= $i < $rating ? '<i class="fas fa-star"></i>' : '<i class="far fa-star"></i>';
	}
	return $html;
}
add_filter( 'woocommerce_get_star_rating_html', 'azo_replace_star_ratings', 10, 2 );

$shop_layout_columns = isset( $_GET['shop_preset_columns'] ) ? Azo_Helper::data_clean( $_GET['shop_preset_columns'] ) : false;
if ( '4' === $shop_layout_columns ) {
	/**
	 * Override theme default specification for product # per row
	 */
	function azo_demo_loop_columns() {
		return 4; // 4 products per row.
	}
	add_filter( 'loop_shop_columns', 'azo_demo_loop_columns', 999 );
}
