<?php
/**
 * Get svg icon.
 *
 * @package azo
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'azo_get_svg' ) ) {
	/**
	 * Get svg icon
	 *
	 * @param  string  $name Icon name.
	 * @param  boolean $echo Echo.
	 */
	function azo_get_svg( $name = '', $echo = true ) {
		$svg = '';

		switch ( $name ) {
			case 'user':
				$svg = '<svg version="1.1" width="1em" height="1em" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 48 48" style="enable-background:new 0 0 48 48;" xml:space="preserve"><path d="M5.4,47c-1,0-1.7-0.8-1.7-1.7v-8c0-3.5,2.3-6.9,6.3-9.1c3.7-2.1,8.7-3.2,14-3.2c5.3,0,10.3,1.1,14,3.2
	c4,2.3,6.3,5.6,6.3,9.1v8c0,1-0.8,1.7-1.7,1.7H5.4z M24,28.4c-4.7,0-9.1,1-12.3,2.8c-3,1.7-4.6,3.8-4.6,6.1v6.2h33.7v-6.2
	c0-2.3-1.6-4.4-4.6-6.1C33.1,29.4,28.7,28.4,24,28.4L24,28.4z M24,22.2c-5.8,0-10.6-4.8-10.6-10.6S18.2,1,24,1s10.6,4.8,10.6,10.6
	S29.8,22.2,24,22.2z M24,4.5c-3.9,0-7.1,3.2-7.1,7.1c0,3.9,3.2,7.1,7.1,7.1c3.9,0,7.1-3.2,7.1-7.1C31.1,7.7,27.9,4.5,24,4.5z"/></svg>';
				break;
			case 'heart':
				$svg = '<svg version="1.1" width="1em" height="1em" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 48 48" style="enable-background:new 0 0 48 48;" xml:space="preserve"><path d="M13.1,4.1c-3.1,0-6.2,1.2-8.6,3.6c-4.7,4.8-4.7,12.5,0,17.3l18.4,18.5l0,0c0.3,0.3,0.7,0.5,1.1,0.5c0.4,0,0.8-0.2,1.1-0.5
	c6.1-6.2,12.3-12.4,18.4-18.5c4.7-4.8,4.7-12.5,0-17.3c-4.7-4.8-12.4-4.8-17.2,0L24,10l-2.3-2.3C19.3,5.3,16.2,4.1,13.1,4.1
	L13.1,4.1z M13.1,7.1c2.3,0,4.6,0.9,6.4,2.7l3.4,3.4h0c0.3,0.3,0.7,0.5,1.1,0.5c0.4,0,0.8-0.2,1.1-0.5l3.4-3.4
	c3.6-3.6,9.2-3.6,12.8,0c3.6,3.6,3.6,9.4,0,13C35.5,28.6,29.8,34.4,24,40.2L6.7,22.8c-3.6-3.6-3.6-9.4,0-13C8.5,8,10.8,7.1,13.1,7.1
	L13.1,7.1z"/></svg>';
				break;
			case 'compare':
				$svg = '<svg width="1em" height="1em" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 48 48" style="enable-background:new 0 0 48 48;" xml:space="preserve"><g><g><g><path d="M37.3,14.3H3c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2h34.2c1.1,0,2,0.9,2,2C39.2,13.4,38.3,14.3,37.3,14.3z"/><path d="M12.4,23.6c-0.5,0-1-0.2-1.4-0.6l-9.4-9.3c-0.7-0.8-0.7-2,0-2.8l9.3-9.3c0.8-0.8,2-0.8,2.8,0s0.8,2,0,2.8l-8,8l8,8
				c0.7,0.8,0.7,2,0,2.8C13.4,23.4,12.8,23.6,12.4,23.6z"/><path d="M45,37.6H10.8c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2H45c1.1,0,2,0.9,2,2C47,36.8,46.1,37.6,45,37.6z"/><path d="M35.7,47c-0.5,0-1-0.2-1.4-0.6c-0.7-0.8-0.7-2,0-2.8l8-8l-8-8c-0.8-0.8-0.8-2,0-2.8c0.8-0.8,2-0.8,2.8,0l9.3,9.3
				c0.7,0.8,0.7,2,0,2.8l-9.3,9.4C36.7,46.8,36.2,47,35.7,47z"/></g></g></g></svg>';
				break;
			case 'cart':
				$svg = '<svg version="1.1" width="1em" height="1em" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 48 48" style="enable-background:new 0 0 48 48;" xml:space="preserve"><path d="M2.5,3.6C1.7,3.6,1,4.2,1,5.1c0,0.8,0.7,1.5,1.5,1.5h5.1c2.5,6.3,5,12.6,7.6,18.9l-2.3,5.6c-0.2,0.5-0.1,1,0.1,1.4
	c0.3,0.4,0.8,0.7,1.3,0.7h25.6c0.8,0,1.6-0.7,1.6-1.5c0-0.8-0.7-1.5-1.6-1.5H16.6l1.3-3.2l24.6-2c0.6-0.1,1.2-0.6,1.4-1.2L47,10.5
	c0.2-0.9-0.6-1.9-1.5-1.9H11.7l-1.7-4.2c-0.2-0.6-0.8-1-1.4-1L2.5,3.6z M13,11.7h30.6l-2.4,10.3l-23.3,1.9L13,11.7z M19.4,34.2
	c-2.8,0-5.1,2.3-5.1,5.1s2.3,5.1,5.1,5.1s5.1-2.3,5.1-5.1S22.2,34.2,19.4,34.2z M34.7,34.2c-2.8,0-5.1,2.3-5.1,5.1s2.3,5.1,5.1,5.1
	s5.1-2.3,5.1-5.1S37.5,34.2,34.7,34.2z M19.4,37.3c1.1,0,2,0.9,2,2s-0.9,2-2,2c-1.1,0-2-0.9-2-2C17.4,38.2,18.3,37.3,19.4,37.3z
	 M34.7,37.3c1.1,0,2,0.9,2,2c0,1.1-0.9,2-2,2c-1.1,0-2-0.9-2-2S33.6,37.3,34.7,37.3z"/></svg>';
				break;
		}

		$name = str_replace( '-', '_', $name );
		$svg  = apply_filters( "azo_svg_icon_$name", $svg );

		if ( $echo ) {
			echo wp_kses( $svg, azo_kses_svg_allowed() );
		} else {
			return $svg;
		}
	}
}

if ( ! function_exists( 'azo_kses_svg_allowed' ) ) {
	/**
	 * Get kses svg
	 */
	function azo_kses_svg_allowed() {
		$kses_defaults = wp_kses_allowed_html( 'post' );

		// Support scrset attr for image.
		if ( isset( $kses_defaults['img'] ) ) {
			$kses_defaults['img']['srcset'] = true;
			$kses_defaults['img']['sizes']  = true;
		}

		$svg_args = array(
			'focusable'   => true,
			'aria-label'  => true,
			'aria-hidden' => true,
			'tabindex'    => true,
			'svg'         => array(
				'class'           => true,
				'aria-hidden'     => true,
				'aria-labelledby' => true,
				'role'            => true,
				'xmlns'           => true,
				'width'           => true,
				'height'          => true,
				'viewbox'         => true,
				'viewbox'         => true,
				'fill'            => true,
				'stroke'          => true,
			),
			'g'           => array(
				'fill' => true,
			),
			'title'       => true,
			'path'        => array(
				'd'                 => true,
				'fill'              => true,
				'fill-rule'         => true,
				'stroke'            => true,
				'stroke-linecap'    => true,
				'stroke-miterlimit' => true,
				'stroke-width'      => true,
				'stroke-linejoin'   => true,
			),
			'circle'      => array(
				'cx'              => true,
				'cy'              => true,
				'r'               => true,
				'fill'            => true,
				'stroke'          => true,
				'stroke-linecap'  => true,
				'stroke-linejoin' => true,
				'stroke-width'    => true,
			),
			'rect'        => array(
				'x'               => true,
				'y'               => true,
				'width'           => true,
				'height'          => true,
				'rx'              => true,
				'fill'            => true,
				'stroke'          => true,
				'stroke-linejoin' => true,
				'stroke-width'    => true,
			),
		);
		return array_merge( $kses_defaults, $svg_args );
	}
}
