<?php
/**
 * Hook
 *
 * @package azo
 */

// @codingStandardsIgnoreStart
defined( 'ABSPATH' ) || exit;

/**
 * THEME SETUP
 */
add_action( 'after_setup_theme', 'azo_action_theme_setup' );
if ( ! function_exists( 'azo_action_theme_setup' ) ) :
	/**
	 * Azo action theme setup
	 */
	function azo_action_theme_setup() {
		load_theme_textdomain( 'azo', get_template_directory() . '/languages' );

		// Add woo sp.
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'title-tag' );
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 64,
				'width'       => 20,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
		add_theme_support( 'boostify-header-footer' );

		add_theme_support( 'boostify-demo-preview' );

		add_theme_support(
			'post-formats',
			array(
				'aside',
				'image',
				'video',
				'audio',
				'quote',
				'link',
				'gallery',
			)
		);

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		add_filter( 'use_default_gallery_style', '__return_false' );
	}
endif;


/**
 * BODY CLASSES
 */
add_filter( 'body_class', 'azo_body_classes' );
/**
 * Azo body classes
 *
 * @param  [type] $classes type.
 */
function azo_body_classes( $classes ) {
	if ( true === get_theme_mod( 'sticky_add_to_cart_and_checkout', false ) ) {
		$classes[] = 'shop-buttons-is-sticky';
	}

	// BROWSER DETECT.
	global $is_IE, $is_edge, $is_safari, $is_iphone;

	if ( $is_iphone ) {
		$classes[] = 'iphone-detected';
	} elseif ( $is_IE ) {
		$classes[] = 'ie-detected';
	} elseif ( $is_edge ) {
		$classes[] = 'edge-detected';
	} elseif ( $is_safari ) {
		$classes[] = 'safari-detected';
	}

	// THEME START.
	if ( ! class_exists( 'kirki' ) ) {
		$classes[] = 'no-kirki-customize';
	}

	// BLOG CLASS.
	if ( azo_blog() ) {
		$classes[] = 'group-blog';

		$sidebar = is_active_sidebar( 'blog-widget' ) ? get_theme_mod( 'blog_sidebar', 'full' ) : 'full';
		if ( 'full' !== $sidebar ) {
			$classes[] = 'group-blog-sidebar-' . $sidebar;
		}
	}

	// SINGLE PRODUCT GALLERY.
	if ( is_singular( array( 'product', 'elementor_library' ) ) ) {
		$layout         = get_theme_mod( 'shop_gallery_layout', 'horizontal' );
		$layout_product = isset( $_GET['layout_product'] ) ? Azo_Helper::data_clean( $_GET['layout_product'] ) : false;

		if ( false === $layout_product ) {
			if ( 'vertical' === $layout || 'horizontal' === $layout ) {
				$classes[] = 'single-gallery-slider single-gallery-' . $layout;
			} else {
				$classes[] = 'single-gallery-image single-gallery-' . $layout;
			}
		} else {
			if ( 'vertical' === $layout_product || 'horizontal' === $layout_product ) {
				$classes[] = 'single-gallery-slider single-gallery-' . $layout_product;
			} else {
				$classes[] = 'single-gallery-image single-gallery-' . $layout_product;
			}
		}
	}

	// PAGE HEADER.
	$classes[] = 'is-page-header-' . azo_page_header_slug();

	/*OPTION ENABLE AJAX SINGLE ADD TO CART*/
	if ( true === get_theme_mod( 'ajax_single_atc', true ) ) {
		$classes[] = 'ajax-single-add-to-cart';
	}

	// Theme version.
	$theme     = wp_get_theme();
	$classes[] = 'azo-' . $theme->get( 'Version' );

	// Mobile sticky header menu.
	if ( true === get_theme_mod( 'sticky_header', false ) && true === get_theme_mod( 'mobile_sticky_header', false ) ) {
		$classes[] = 'mobile-header-menu-sticky';
	}

	// Menu layout.
	$classes[] = 'has-menu-' . azo_menu_slug();

	// Product load more button.
	if ( true === get_theme_mod( 'product_load_more', false ) ) {
		$classes[] = 'has-product-load-more-button';
	}

	// Show default Loop Add to cart button instaed for Icon.
	$default_button = get_theme_mod( 'default_add_to_cart_button', false );
	if ( $default_button ) {
		$classes[] = 'has-default-loop-add-to-cart-button';
	}

	return $classes;
}


/**
 * REGISTER WIDGET AREA
 */
add_action( 'widgets_init', 'azo_widgets_init' );
/**
 * Azo widgets init
 */
function azo_widgets_init() {
	// BLOG WIDGET.
	register_sidebar(
		array(
			'name'          => esc_html__( 'Blog Widget Area', 'azo' ),
			'id'            => 'blog-widget',
			'description'   => esc_html__( 'Appears in the blog sidebar section of the site.', 'azo' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>',
		)
	);

	// WOOCOMMERCE WIDGET.
	if ( class_exists( 'woocommerce' ) ) {
		register_sidebar(
			array(
				'name'          => esc_html__( 'Shop Widget Area', 'azo' ),
				'id'            => 'shop-widget',
				'description'   => esc_html__( 'Appears in the sidebar of shop page.', 'azo' ),
				'before_widget' => '<aside id="%1$s" class="widget shop %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h5 class="widget-title">',
				'after_title'   => '</h5>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Shop Filter Area', 'azo' ),
				'id'            => 'shop-filter-widget',
				'description'   => esc_html__( 'Appears in the top of shop page.', 'azo' ),
				'before_widget' => '<div id="%1$s" class="widget shop-filter-col %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="widget-title">',
				'after_title'   => '</h5>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Shop Single Widget Area', 'azo' ),
				'id'            => 'shop-single-widget',
				'description'   => esc_html__( 'Appears in the sidebar of shop single page.', 'azo' ),
				'before_widget' => '<aside id="%1$s" class="widget shop %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h5 class="widget-title">',
				'after_title'   => '</h5>',
			)
		);
	}
}


// KIRKI: COMPILES INLINE CSS TO THEME STYLESHEET.
add_filter( 'kirki_azo_stylesheet', 'azo_stylesheet_filter', 99 );
/**
 * Azo stylesheet filter
 *
 * @param  [type] $stylesheet type.
 */
function azo_stylesheet_filter( $stylesheet ) {
	return 'azo-theme-style';
}

// ADD A CUSTOM COLUMN IN POSTS AND CUSTOM POST TYPES ADMIN SCREEN.
/**
 * GET FEATURED IMAGE
 *
 * @param  [type] $post_ID type.
 */
function azo_get_featured_image( $post_ID ) {
	$img_id = get_post_thumbnail_id( $post_ID );
	if ( $img_id ) {
		$img_src = wp_get_attachment_image_src( $img_id, 'thumbnail' );

		return $img_src[0];
	}
}

/*ADD NEW COLUMN | `post`*/
add_filter( 'manage_post_posts_columns', 'azo_columns_head', 10 );
/**
 * Azo columns head
 *
 * @param  [type] $defaults type.
 */
function azo_columns_head( $defaults ) {
	$order = array();
	// `cb` = checkbox.
	$checkbox = 'cb';
	foreach ( $defaults as $key => $value ) {
		$order[ $key ] = $value;
		if ( $key === $checkbox ) {
			$order['thumbnail_image'] = esc_attr__( 'Image', 'azo' );
		}
	}

	return $order;
}

/*SHOW THE FEATURED IMAGE | `post` */
add_action( 'manage_post_posts_custom_column', 'azo_columns_content', 10, 2 );
/**
 * Azo columns content
 *
 * @param  [type] $column_name type.
 * @param  [type] $post_ID     type.
 */
function azo_columns_content( $column_name, $post_ID ) {
	if ( 'thumbnail_image' === $column_name ) {
		$_img_src = azo_get_featured_image( $post_ID );
		if ( $_img_src ) {
			?>
			<a href="<?php echo esc_url( get_edit_post_link( $post_ID ) ); ?>">
				<img src="<?php echo esc_url( $_img_src ); ?>"/>
			</a>
		<?php } else { ?>
			<a href="<?php echo esc_url( get_edit_post_link( $post_ID ) ); ?>">
				<img src="<?php echo esc_url( AZO_URI . 'images/thumbnail-default.jpg' ); ?>"/>
			</a>
			<?php
		}
	}
}

if ( ! function_exists( 'azo_open_content_container' ) ) {
	/**
	 * Azo open content container
	 */
	function azo_open_content_container() {
		if ( function_exists( 'hfe_render_header' ) && hfe_header_enabled() ) {
			return;
		}
			$menu_layout            = azo_menu_slug();
			$sidebar_menu           = 'sidebar-menu';
			$sidebar_menu_links     = get_theme_mod( 'sidebar_menu_links', '<ul class="sidebar-menu-links"><li><a href="#">About us</a></li><li><a href="#">Order & shipping</a></li><li><a href="#">FAQs</a></li></ul>' );
			$sidebar_menu_social    = get_theme_mod( 'sidebar_menu_social', '<ul class="menu-social sidebar-menu-social"><li><a href="//facebook.com/azo"></a></li><li><a href="//twitter.com/azo"></a></li><li><a href="//instagram.com/azo"></a></li></ul>' );
			$sidebar_menu_copyright = get_theme_mod( 'sidebar_menu_copyright', '<div class="sidebar-menu-copyright">&copy; 2020 <a href="#">azo</a>. All Rights Reserved.</div>' );

		if ( 'layout-2' === $menu_layout ) {
			$sidebar_menu = $sidebar_menu . ' sidebar-menu--md-visible';
		}
		?>
			<div id="sidebar-menu-content" class="menu-layout menu-<?php echo esc_attr( $menu_layout ); ?> <?php echo esc_attr( $sidebar_menu ); ?>">
				<div class="sidebar-menu-top">
					<?php
					if ( 'layout-2' === $menu_layout ) {
						$sidebar_logo = get_theme_mod( 'sidebar_logo' );
						?>
							<a href="<?php echo esc_url( '/' ); ?>">
								<img src="<?php echo esc_url( $sidebar_logo ); ?>" alt="<?php esc_attr_e( 'logo-sidebar', 'azo' ); ?>">
							</a>
					<?php } ?>

				</div><!-- .sidebar-menu-top -->

				<div class="sidebar-menu-middle">
					<?php
					if ( has_nav_menu( 'primary' ) ) :
						wp_nav_menu(
							array(
								'theme_location' => 'primary',
								'menu_class'     => 'theme-primary-menu theme-sidebar-menu',
								'container'      => '',
							)
						);
					endif;
					if ( 'layout-2' === $menu_layout ) :
						?>
						<div class="header-action">
							<button class="azo-search js-search-button"></button>
							<?php
							if ( class_exists( 'woocommerce' ) ) {
								azo_wc_header_action();
							}
							?>
						</div><!-- .header-action -->
						<?php
					endif;
					?>
				</div><!-- .sidebar-menu-middle -->

				<div class="sidebar-menu-bottom">
					<?php
					if ( 'layout-2' !== $menu_layout ) {
						azo_wc_sidebar_action();
					}

					if ( ! empty( $sidebar_menu_social ) && 'layout-2' === $menu_layout ) {
						echo wp_kses_decode_entities( $sidebar_menu_social );
					}

					if ( ! empty( $sidebar_menu_copyright ) && 'layout-2' === $menu_layout ) {
						echo wp_kses_decode_entities( $sidebar_menu_copyright );
					}
					?>
				</div><!-- .sidebar-menu-bottom -->
			</div><!-- #sidebar-menu-content -->
		<?php
	}
}

if ( ! function_exists( 'azo_layout2_customize' ) ) {
	/**
	 * Azo layout2 customize
	 */
	function azo_layout2_customize() {
		$menu_layout = azo_menu_slug();
		if ( 'layout-2' === $menu_layout ) {
			echo '<div class="content-container"><div id="theme-menu-pusher">';
		} else {
			echo '<div id="theme-menu-pusher">';
		}
	}
}

add_action( 'azo_before_content', 'azo_open_content_container' );
add_action( 'azo_before_content', 'azo_layout2_customize', 20 );

/**
 * Close content container
 */
if ( ! function_exists( 'azo_after_content' ) ) {
	/**
	 * Azo after content
	 */
	function azo_after_content() {
		do_action( 'azo_after_content' );
	}
}

if ( ! function_exists( 'azo_close_content_container' ) ) {
	/**
	 * Azo close content container
	 */
	function azo_close_content_container() {
		$menu_layout = azo_menu_slug();

		if ( 'layout-2' === $menu_layout ) {
			echo '</div></div>';
		} else {
			echo '</div>';
		}
	}

	add_action( 'azo_after_content', 'azo_close_content_container' );
}

/**
 * Ajax search for WooCommerce Products
 */
if ( ! function_exists( 'azo_ajax_search_handler' ) ) {
	/**
	 * Azo ajax search handler
	 */
	function azo_ajax_search_handler() {
		check_ajax_referer( 'search_nonce' );

		$suggestions = array();

		$limit = 0 == get_theme_mod( 'ajax_search_limit_search_results', 5 ) ? -1 : get_theme_mod( 'ajax_search_limit_search_results', 5 );

		$args = array(
			's'                   => sanitize_text_field( $_REQUEST['search_key'] ),
			'post_type'           => 'product',
			'post_status'         => 'publish',
			'posts_per_page'      => $limit,
			'ignore_sticky_posts' => 1,
			'order'               => 'asc',
			'orderby'             => 'title',
		);

		if ( isset( $_REQUEST['product_cat'] ) && '0' !== sanitize_text_field( $_REQUEST['product_cat'] )) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'product_cat',
					'field' => 'slug',
					'terms' => sanitize_text_field( $_REQUEST['product_cat'] ),
				)
			);
		}

		$products = get_posts( $args );

		if ( ! empty( $products ) ) {
			foreach ( $products as $post ) {
				$product = wc_get_product( $post );

				$suggestions[] = array(
					'id'        => $product->get_id(),
					'value'     => strip_tags( $product->get_title() ),
					'url'       => $product->get_permalink(),
					'thumbnail' => $product->get_image( 'shop_thumbnail' ),
					'price'     => $product->get_price_html(),
					'excerpt'   => wp_trim_words( $post->post_excerpt, 20 ),
				);
			}
		} else {
			$suggestions[] = array(
				'id'    => -1,
				'value' => esc_html__( 'No results', 'azo' ),
				'url'   => '',
			);
		}

		wp_reset_postdata();

		$suggestions = array(
			'suggestions' => $suggestions,
		);

		wp_send_json( $suggestions );
	}
	add_action( 'wp_ajax_azo_ajax_search_handler', 'azo_ajax_search_handler' );
	add_action( 'wp_ajax_nopriv_azo_ajax_search_handler', 'azo_ajax_search_handler' );
}

/**
 * Disable admin notice of Header Footer Elementor plugin
 */
if ( ! function_exists( 'azo_header_footer_elementor_support' ) ) {
	/**
	 * Azo header footer elementor support
	 */
	function azo_header_footer_elementor_support() {
		add_theme_support( 'header-footer-elementor' );
	}
	add_action( 'after_setup_theme', 'azo_header_footer_elementor_support' );
}

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function azo_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'azo_content_width', 1200 );
}
add_action( 'after_setup_theme', 'azo_content_width', 1200 );

// Display custom admin notice.

if ( ! function_exists( 'azo_dismiss_admin_notice' ) ) {
	/**
	 * Azo dismiss admin notice
	 */
	function azo_dismiss_admin_notice() {
		$user_id = get_current_user_id();
		if ( isset( $_GET['dismiss-azo-notice'] ) ) {
			add_user_meta( $user_id, 'azo_notice_dismissed', 'true', true );
		}
	}
}
add_action( 'admin_init', 'azo_dismiss_admin_notice' );

// Core element.
add_action( 'azo_theme_core_element', 'azo_search_form', 20 );
add_action( 'azo_theme_core_element', 'azo_after_footer', 30 );

if ( class_exists( 'woocommerce' ) ) {
	add_action( 'azo_theme_core_element', 'azo_product_action', 10 );
}


if ( ! function_exists( 'azo_bestseller' ) ) {
	/**
	 * GET PRODUCT BESTSELLER
	 */
	function azo_bestseller() {
		global $wpdb;

		$table_orders_meta = $wpdb->prefix . 'woocommerce_order_itemmeta';
		$order_meta        = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_orders_meta" ) );
		foreach ( $order_meta as $order ) {
			if ( '_product_id' === $order->meta_key ) {
				$product_id                                        = $order->meta_value;
				$order_item[ $order->order_item_id ]['product_id'] = $product_id;
			}
			if ( '_qty' === $order->meta_key ) {
				$qty                                        = $order->meta_value;
				$order_item[ $order->order_item_id ]['qty'] = $qty;
			}
		}

		if ( empty( $order_item ) ) {
			return;
		}

		$bestseller = array();

		foreach ( $order_item as $seller ) {
			if ( empty( $bestseller ) ) {
				$bestseller[ $seller['product_id'] ] = $seller['qty'];
			} else {
				if ( array_key_exists( $seller['product_id'], $bestseller ) ) {
					$bestseller[ $seller['product_id'] ] = $bestseller[ $seller['product_id'] ] + $seller['qty'];
				} else {
					$bestseller[ $seller['product_id'] ] = $seller['qty'];
				}
			}
		}
		arsort( $bestseller );
		wp_reset_postdata();
		return $bestseller;
	}
}

/**
 * GET PRODUCT RENCENT
 *
 * @param  [type] $number type.
 */
function azo_get_rencent_product( $number ) {
	$args = array(
		'numberposts' => $number,
		'post_type'   => 'product',
	);

	$recent_posts = wp_get_recent_posts( $args, OBJECT );
	return $recent_posts;
}

/**
 * GET PRODUCT ON SALE
 *
 * @param  [type] $products_per_page type.
 */
function azo_get_product_on_sale( $products_per_page ) {
	$args = array(
		'post_type'           => 'product',
		'posts_per_page'      => $products_per_page,
		'ignore_sticky_posts' => 1,
		'paged'               => get_query_var( 'paged' ),
		'post_status'         => 'publish',
		'meta_query'          => array( //phpcs:ignore
			'relation' => 'OR',
			array(
				'key'     => '_sale_price',
				'value'   => 0,
				'compare' => '>',
				'type'    => 'numeric',
			),
			array(
				'key'     => '_min_variation_sale_price',
				'value'   => 0,
				'compare' => '>',
				'type'    => 'numeric',
			),
		),
	);

	$products = new WP_Query( $args );

	return $products;
}

/**
 * GET PRODUCT TRENDING
 *
 * @param  [type] $products_per_page type.
 */
function azo_get_product_trending( $products_per_page ) {
	$args = array(
		'post_type'           => 'product',
		'posts_per_page'      => $products_per_page,
		'ignore_sticky_posts' => 1,
		'tax_query'           => array( //phpcs:ignore
			array(
				'taxonomy' => 'product_cat',
				'field'    => 'slug',
				'terms'    => 'trending',
			),
		),
	);
	$loop = new WP_Query( $args );

	return $loop;
}

/**
 * GET PRODUCT POPULAR
 *
 * @param  [type] $products_per_page type.
 */
function azo_get_product_popular( $products_per_page ) {
	$args = array(
		'post_type'           => 'product',
		'posts_per_page'      => $products_per_page,
		'ignore_sticky_posts' => 1,
		'meta_key'            => 'post_views_count', //phpcs:ignore
		'orderby'             => 'meta_value_num',
		'order'               => 'DESC',
	);

	$loop = new WP_Query( $args );

	return $loop;
}

/**
 * PRODUCT BESTSELLER TEMPLATE
 *
 * @param  [type] $number type.
 */
function azo_product_bestseller( $number ) {

	$bestseller = azo_bestseller();
	if ( empty( $bestseller ) ) {
		return;
	}

	foreach ( $bestseller as $id => $value ) {
		$args = array(
			'post_type' => 'product',
			'p'         => (int) $id,
		);

		$products[] = new WP_Query( $args );
	}

	if ( empty( $products ) ) {
		return;
	}
	?>
	<div class="products ht-grid data-content tab-bestseller data-content-filter js-products-slider" data-content="bestseller">
		<?php
		foreach ( $products as $key => $product ) {
			if ( $key < $number ) {
				if ( $product->have_posts() ) {
					$product->the_post();
					get_template_part( 'template-parts/content', 'product' );
				}
			}
		}
		?>
	</div
	<?php
	wp_reset_postdata();
}

/**
 * PRODUCT POPULAR TEMPLATE
 *
 * @param  [type] $products_per_page type.
 */
function azo_product_popular( $products_per_page ) {
	$products = azo_get_product_popular( $products_per_page );

	if ( ! $products->have_posts() ) {
		return;
	}
	?>
	<div class="products ht-grid data-content tab-popular data-content-filter js-products-slider" data-content='popular'>
		<?php
		while ( $products->have_posts() ) {
			$products->the_post();
			get_template_part( 'template-parts/content', 'product' );
		}
		?>
	</div
	<?php
	wp_reset_postdata();
}

/**
 * PRODUCT TRENDING TEMPLATE
 *
 * @param  [type] $products_per_page type.
 */
function azo_product_trending( $products_per_page ) {
	$products = azo_get_product_trending( $products_per_page );

	if ( ! $products->have_posts() ) {
		return;
	}
	?>
	<div class="products ht-grid data-content tab-trending data-content-filter js-products-slider" data-content='trending'>
		<?php
		while ( $products->have_posts() ) {
			$products->the_post();
			get_template_part( 'template-parts/content', 'product' );
		}
		?>
	</div>
	<?php
	wp_reset_postdata();
}

/**
 * PRODUCT ON SALE TEMPLATE
 *
 * @param  [type] $products_per_page type.
 */
function azo_product_on_sale( $products_per_page ) {
	$products = azo_get_product_on_sale( $products_per_page );

	if ( ! $products->have_posts() ) {
		return;
	}
	?>
	<div class="products ht-grid data-content tab-onsalet data-content-filter js-products-slider" data-content='onsalet'>
		<?php
		while ( $products->have_posts() ) {
			$products->the_post();
			get_template_part( 'template-parts/content', 'product' );
		}
		?>
	</div>
	<?php
	wp_reset_postdata();
}

/**
 * PRODUCT RECENT TEMPLATE
 *
 * @param  [type] $products_per_page type.
 */
function azo_product_recent( $products_per_page ) {
	$products = azo_get_rencent_product( $products_per_page );
	foreach ( $products as $product ) {
		$args = array(
			'post_type' => 'product',
			'p'         => (int) $product->ID,
		);

		$recents[] = new WP_Query( $args );
	}

	if ( empty( $recents ) ) {
		return;
	}
	?>
		<div class="products ht-grid data-content tab-recent data-content-filter js-products-slider" data-content="recent">
			<?php
			foreach ( $recents as $key => $product ) {
				if ( $product->have_posts() ) {
					$product->the_post();
					get_template_part( 'template-parts/content', 'product' );
				}
			}
			?>
		</div>
	<?php
	wp_reset_postdata();
}

/**
 * Top rate
 *
 * @param string $products_per_page type.
 */
function azo_get_top_rated( $products_per_page ) {
	global $wpdb;

	$table_product = $wpdb->prefix . 'wc_product_meta_lookup';
	$products      = $wpdb->get_results( $wpdb->prepare( "SELECT product_id FROM $table_product WHERE average_rating <> 0 ORDER BY average_rating DESC" ) );

	$top_rate = array();
	if ( ! $products ) {
		return;
	}

	foreach ( $products as $key => $product ) {
		if ( $key < (int) $products_per_page ) {
			$args = array(
				'post_type' => 'product',
				'p'         => (int) $product->product_id,
			);

			$top_rate[ $product->product_id ] = new WP_Query( $args );
		}
	}

	return $top_rate;
}

// Freequent bought together.
add_filter( 'woobt_positions', 'azo_woobt_positions' );
/**
 * Azo woobt positions
 *
 * @param  [type] $positions type.
 */
function azo_woobt_positions( $positions ) {
	$positions['theme_azo'] = 'Theme Azo';
	return $positions;
}

add_filter(
	'woobt_default_position',
	function () {
		return 'theme_azo';
	}
);

do_action( 'woobt_position_theme_azo', true );
