<?php
/**
 * Elementor
 *
 * @package azo
 */

namespace Elementor;

// RETURN IF ELEMENTOR IS NOT ACTIVE.
if ( ! azo_is_elementor() ) {
	return;
}

add_action( 'elementor/element/wp-post/document_settings/before_section_end', 'Elementor\azo_page_settings' );
/**
 * ADD PAGE SETTINGS
 *
 * @param \Elementor\Core\DocumentTypes\PageBase $page type.
 */
function azo_page_settings( \Elementor\Core\DocumentTypes\PageBase $page ) {
	if ( ! isset( $page ) ) {
		return;
	}

	$settings = glob( get_template_directory() . '/elementor/page-settings/*.php' );

	foreach ( $settings as $key ) {
		if ( file_exists( $key ) ) {
			require_once $key;
		}
	}
}

add_action( 'elementor/widgets/widgets_registered', 'Elementor\azo_widgets' );
/**
 * ADD THEME WIDGETS
 */
function azo_widgets() {
	$widgets = glob( get_template_directory() . '/elementor/*.php' );

	foreach ( $widgets as $key ) {
		if ( file_exists( $key ) ) {
			require_once $key;
		}
	}
}

add_action( 'elementor/elements/categories_registered', 'Elementor\azo_widget_categories' );
/**
 * ADD WIDGET CATEGORIES
 *
 * @param  [type] $elements_manager type.
 */
function azo_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'azo-theme',
		array(
			'title' => esc_html__( 'Azo Theme', 'azo' ),
		)
	);
}

add_action( 'elementor/widgets/widgets_registered', 'Elementor\azo_remove_elementor_widgets', 15 );
/**
 * Remove some elementor widget
 *
 * @param  [type] $widgets_manager type.
 */
function azo_remove_elementor_widgets( $widgets_manager ) {
	if ( ! defined( 'ELEMENTOR_PRO_VERSION' ) ) {
		return;
	}

	$widgets_manager->unregister_widget_type( 'woocommerce-product-images' );
}

/**
 * Widget_scripts
 *
 * Load required plugin core files.
 *
 * @since 1.2.0
 * @access public
 */
function widget_scripts() {
	wp_register_script(
		'azo-team-member',
		AZO_URI . 'js/azo-team-member.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-testimonial',
		AZO_URI . 'js/azo-testimonial.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-images-slider',
		AZO_URI . 'js/azo-images-slider.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-category-slider',
		AZO_URI . 'js/azo-slider-category.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-instagram-slider',
		AZO_URI . 'js/azo-instagram-slider.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-countdown',
		AZO_URI . 'js/azo-countdown.js',
		array( 'jquery', 'countdown' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-blog-slider',
		AZO_URI . 'js/azo-blog-slider.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-product-filter',
		AZO_URI . 'js/azo-product-filter.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-product-filter-by-category',
		AZO_URI . 'js/azo-product-filter-by-category.js',
		array( 'jquery', 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-product-slider',
		AZO_URI . 'js/azo-product-slider.js',
		array( 'slick' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-countdown',
		AZO_URI . 'js/coundown-azo.js',
		array( 'jquery', 'countdown' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'azo-login',
		AZO_URI . 'js/azo-login.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);
}
add_action( 'elementor/frontend/after_register_scripts', 'Elementor\widget_scripts', 15 );
