<?php
/**
 * Typography Customize
 *
 * @package azo
 */

/**
 * ADD TYPO SECTION
 */
Azo_Kirki::add_section(
	'typo',
	array(
		'title'    => esc_attr__( 'Typography', 'azo' ),
		'priority' => 2,
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'    => 'custom',
		'section' => 'typo',
		'default' => '<div class="desc"><strong class="insight-label insight-label-info">' . esc_html__( 'IMPORTANT NOTE: ', 'azo' ) . '</strong>' . esc_html__( 'This section contains general typography options. Additional typography options for specific areas can be found within other sections. Example: For breadcrumb typography options go to the breadcrumb section.', 'azo' ) . '</div>',
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_body_font',
		'section'  => 'typo',
		'default'  => azo_label( esc_attr__( 'Body font', 'azo' ) ),
	)
);

/*BODY FONT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'settings'  => 'typo_body',
		'section'   => 'typo',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '400',
			'color'          => '#767676',
			'font-size'      => '15px',
			'line-height'    => '26px',
			'letter-spacing' => '0.3px',
			'text-transform' => 'none',
		),
		'output'    => array(
			array(
				'element' => array(
					'body',
				),
			),

			array(
				'element'  => array(
					'input, select, textarea, button',
					'.comment-time',
					'.single .blog-header-info .if-item a',
					'.cart-sidebar-title',
					'.single-product .product_meta .posted_in',
					'.single-product .product_meta .posted_in a',
					'.single-product .product_meta .tagged_as a',
					'.single-product .product_meta .tagged_as',
					'.single-product .product_meta .sku_wrapper',
					'.single-product .product_meta .sku_wrapper .sku',
					'form.woocommerce-checkout .shop_table td',
					'form.woocommerce-checkout .shop_table th',
					'.tooltip',
				),
				'property' => 'font-family',
				'choice'   => 'font-family',
			),

			array(
				'element'  => array(
					'.comment-form-rating .stars:not(.selected) a:hover ~ a',
					'.comment-form-rating .stars.selected .active ~ a',
					'.comment-form-rating .stars.selected a:hover ~ a',
					'.wp-block-archives li a',
					'.wp-block-rss li a',
					'.wp-block-tag-cloud a',
					'.search .blog-header-info .if-item a',
					'.blog-article .tagcloud a',
					'.azo-entries .azo-entry .azo-recent-post-detail .azo-recent-post-on a',
					'.cart a.tinvwl_add_to_wishlist_button.tinvwl-icon-heart.tinvwl-position-shortcode.ftinvwl-animated',
					'.elementor-widget-wp-widget-tag_cloud .tagcloud a',
				),
				'property' => 'color',
				'choice'   => 'color',
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_heading_font',
		'default'  => azo_label( esc_attr__( 'Heading font', 'azo' ) ),
		'section'  => 'typo',
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'settings'  => 'typo_heading_2',
		'section'   => 'typo',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => 'regular',
			'letter-spacing' => '0px',
			'text-transform' => 'none',
		),
		'output'    => array(
			array(
				'element'  => array(
					'.not-found h1.oops',
					'.not-found h3.title',
					'.woocommerce-thankyou-order-completed',
					'.woocommerce-order-details__title',
					'.woocommerce-customer-details .woocommerce-column__title',
					'.reviews-summary .rating-average',
					'.single-product .upsells.products > h2',
					'.single-product .related.products > h2',
				),
				'property' => 'font-family',
				'choice'   => 'font-family',
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*HEADING FONT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'settings'  => 'typo_heading',
		'section'   => 'typo',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => 'bold',
			'line-height'    => '1.4em',
			'letter-spacing' => '0px',
			'color'          => '#222222',
			'text-transform' => 'uppercase',
		),
		'output'    => array(
			array(
				'element' => 'h1, h2, h3, h4, h5, h6',
			),

			array(
				'element'  => array(
					'.blog-read-more',
					'.shop-sidebar .wcapf-layered-nav .chosen',
					'.blog-article .theme-social-icon a:hover',
					'.product_meta .p-shared > span',
					'.widget.widget_shopping_cart .woocommerce-mini-cart__total strong',
					'#order_review .shop_table tfoot tr th:first-of-type',
					'#order_review .shop_table tfoot strong',
					'form.woocommerce-checkout .shop_table thead',
				),
				'property' => 'color',
				'choice'   => 'color',
			),

			array(
				'element'  => array(
					'.woocommerce-Reviews #reply-title',
					'.sticky-add-to-cart-section .sticky-product-title h6',
					'input.submit-newletter',
				),
				'property' => 'font-family',
				'choice'   => 'font-family',
			),

			array(
				'element'  => array(
					'.blog-read-more',
				),
				'property' => 'border-bottom-color',
				'choice'   => 'color',
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*h1*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'slider',
		'settings'    => 'typo_h1',
		'label'       => esc_html__( 'Font size', 'azo' ),
		'description' => esc_html__( 'H1', 'azo' ),
		'section'     => 'typo',
		'default'     => 60,
		'transport'   => 'auto',
		'choices'     => array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
		'output'      => array(
			array(
				'element'  => 'h1',
				'property' => 'font-size',
				'units'    => 'px',
			),
		),
	)
);

/*h2*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'slider',
		'settings'    => 'typo_h2',
		'description' => esc_html__( 'H2', 'azo' ),
		'section'     => 'typo',
		'default'     => 45,
		'transport'   => 'auto',
		'choices'     => array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
		'output'      => array(
			array(
				'element'  => 'h2',
				'property' => 'font-size',
				'units'    => 'px',
			),
		),
	)
);

/*h3*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'slider',
		'settings'    => 'typo_h3',
		'description' => esc_html__( 'H3', 'azo' ),
		'section'     => 'typo',
		'default'     => 30,
		'transport'   => 'auto',
		'choices'     => array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
		'output'      => array(
			array(
				'element'  => 'h3',
				'property' => 'font-size',
				'units'    => 'px',
			),
		),
	)
);

/*h4*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'slider',
		'settings'    => 'typo_h4',
		'description' => esc_html__( 'H4', 'azo' ),
		'section'     => 'typo',
		'default'     => 20,
		'transport'   => 'auto',
		'choices'     => array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
		'output'      => array(
			array(
				'element'  => 'h4',
				'property' => 'font-size',
				'units'    => 'px',
			),
		),
	)
);

/*h5*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'slider',
		'settings'    => 'typo_h5',
		'description' => esc_html__( 'H5', 'azo' ),
		'section'     => 'typo',
		'default'     => 18,
		'transport'   => 'auto',
		'choices'     => array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
		'output'      => array(
			array(
				'element'  => 'h5',
				'property' => 'font-size',
				'units'    => 'px',
			),
		),
	)
);

/*h6*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'slider',
		'settings'    => 'typo_h6',
		'description' => esc_html__( 'H6', 'azo' ),
		'section'     => 'typo',
		'default'     => 16,
		'transport'   => 'auto',
		'choices'     => array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
		'output'      => array(
			array(
				'element'  => 'h6',
				'property' => 'font-size',
				'units'    => 'px',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'select',
		'settings'    => 'strong_font_weight',
		'label'       => esc_html__( 'Strong Tag Weight', 'azo' ),
		'description' => esc_html__( 'Controls font weight of &lt;strong&gt;, &lt;b&gt; tags', 'azo' ),
		'section'     => 'typo',
		'default'     => '700',
		'transport'   => 'auto',
		'choices'     => array(
			'400' => esc_html__( '400 - Regular', 'azo' ),
			'500' => esc_html__( '500 - Medium', 'azo' ),
			'600' => esc_html__( '600 - Semi Bold', 'azo' ),
			'700' => esc_html__( '700 - Bold', 'azo' ),
			'800' => esc_html__( '800 - Extra Bold', 'azo' ),
			'900' => esc_html__( '900 - Ultra Bold (Black)', 'azo' ),
		),
		'output'      => array(
			array(
				'element'  => 'b, strong',
				'property' => 'font-weight',
			),
		),
	)
);
