<?php
/**
 * Topbar
 *
 * @package azo
 */

// ADD TOPBAR SECTION.
Azo_Kirki::add_section(
	'topbar',
	array(
		'title'    => esc_attr__( 'Topbar', 'azo' ),
		'priority' => 3,
	)
);

/* Header 1 Topbar */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'header_1_topbar',
		'label'    => esc_attr__( 'Topbar', 'azo' ),
		'section'  => 'topbar',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

// TOPBAR.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'topbar_color',
		'label'     => esc_attr__( 'Topbar Text Color', 'azo' ),
		'section'   => 'topbar',
		'default'   => '#9f876a',
		'transport' => 'auto',
		'output'    => array(
			array(
				'element'  => array(
					'.topbar',
					'.topbar__right .gray',
				),
				'property' => 'color',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'topbar_bg',
		'label'     => esc_attr__( 'Topbar Background Color', 'azo' ),
		'section'   => 'topbar',
		'default'   => '#f7eee3',
		'transport' => 'auto',
		'output'    => array(
			array(
				'element'  => array(
					'.topbar',
				),
				'property' => 'background-color',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'textarea',
		'settings' => 'topbar_left',
		'label'    => esc_attr__( 'Topbar Left Content', 'azo' ),
		'section'  => 'topbar',
		'default'  => '+01 532 485 283<span class="space-top">sale@azo.com</span>',
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'textarea',
		'settings' => 'topbar_center',
		'label'    => esc_attr__( 'Topbar Center Content', 'azo' ),
		'section'  => 'topbar',
		'default'  => 'Free shipping on all orders over $75.00',
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'textarea',
		'settings' => 'topbar_right',
		'label'    => esc_attr__( 'Topbar Right Content', 'azo' ),
		'section'  => 'topbar',
		'default'  => '<span class="gray">Language:</span><div class="dropdown"><span class="dropdown__current">English <i class="fa fa-angle-down"></i></span><div class="dropdown__content"><a href="#">English</a><a href="#">French</a></div></div><span class="gray">Currency:</span><div class="dropdown"><span class="dropdown__current">USD <i class="fa fa-angle-down"></i></span><div class="dropdown__content"><a href="#">USD</a><a href="#">EUR</a></div></div>',
	)
);
