<?php
/**
 * ADD A LOGO FOR MENU LAYOUT
 *
 * @package azo
 */

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'image',
		'settings' => 'retina_logo',
		'label'    => esc_attr__( 'Retina Logo', 'azo' ),
		'section'  => 'title_tagline',
		'default'  => '',
		'priority' => '8',
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'image',
		'settings'    => 'secondary_logo',
		'label'       => esc_attr__( 'Secondary Logo', 'azo' ),
		'description' => esc_attr__( 'Upload a logo for transparent menu with dark hero image', 'azo' ),
		'section'     => 'title_tagline',
		'default'     => '',
		'priority'    => '8',
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'slider',
		'settings' => 'logo_width',
		'label'    => esc_attr__( 'Logo Width', 'azo' ),
		'section'  => 'title_tagline',
		'default'  => 133,
		'choices'  => array(
			'min'  => '80',
			'max'  => '350',
			'step' => '1',
		),
		'priority' => '8',
		'output'   => array(
			array(
				'element'  => array(
					'.theme-logo',
				),
				'property' => 'width',
				'units'    => 'px',
			),
		),
	)
);
