<?php
/**
 * Page Header
 *
 * @package azo
 */

// Add Title Page.
Azo_Kirki::add_section(
	'title_page_header',
	array(
		'title'    => esc_attr__( 'Title Page', 'azo' ),
		'panel'    => 'title_breadcrumb',
		'priority' => 1,
	)
);

// Show Title Page.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_title_page',
		'label'    => esc_attr__( 'Show Title Page', 'azo' ),
		'section'  => 'title_page_header',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/*Title font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'typography',
		'label'           => esc_attr__( 'Title Page', 'azo' ),
		'settings'        => 'page_header',
		'section'         => 'title_page_header',
		'transport'       => 'auto',
		'default'         => array(
			'font-family'    => 'Heebo',
			'variant'        => 'bold',
			'font-size'      => '28px',
			'color'          => '#222222',
			'letter-spacing' => '0px',
			'text-transform' => 'uppercase',
		),
		'output'          => array(
			array(
				'element' => '#theme-page-header .page-header .container h1.page-title.entry-title',
			),
		),
		'choices'         => azo_custom_font(),
		'active_callback' => array(
			array(
				'setting'  => 'show_title_page',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

// Position Title Page.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'radio-buttonset',
		'settings'        => 'position_title_page',
		'label'           => esc_html__( 'Position Title Page', 'azo' ),
		'section'         => 'title_page_header',
		'default'         => 'center',
		'choices'         => array(
			'left'   => esc_html__( 'Left', 'azo' ),
			'center' => esc_html__( 'Center', 'azo' ),
			'right'  => esc_html__( 'Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '#theme-page-header .page-header .container h1.page-title.entry-title',
				'property' => 'text-align',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_title_page',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
