<?php
/**
 * ADD SHOP SECTION
 *
 * @package azo
 */

Azo_Kirki::add_panel(
	'shop',
	array(
		'title'    => esc_attr__( 'Shop', 'azo' ),
		'priority' => 8,
	)
);

// Add Shop archive.
Azo_Kirki::add_section(
	'shop_archive',
	array(
		'title'    => esc_attr__( 'Shop Archive', 'azo' ),
		'panel'    => 'shop',
		'priority' => 1,
	)
);

/*SIDEBAR*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'radio-image',
		'label'    => esc_html__( 'Sidebar position', 'azo' ),
		'settings' => 'shop_sidebar',
		'section'  => 'shop_archive',
		'default'  => 'full',
		'choices'  => array(
			'left'  => AZO_URI . 'images/sidebar/left.png',
			'full'  => AZO_URI . 'images/sidebar/full.png',
			'right' => AZO_URI . 'images/sidebar/right.png',
		),
	)
);

/*SHOP TITLE*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'text',
		'label'     => esc_html__( 'Shop Title', 'azo' ),
		'settings'  => 'shop_title',
		'section'   => 'shop_archive',
		'default'   => 'Shop',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'element'  => '.page-title.entry-title',
				'function' => 'html',
			),
		),
	)
);

/*BACKGROUND*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'background',
		'settings'        => 'c_header_archive_shop',
		'section'         => 'shop_archive',
		'transport'       => 'auto',
		'default'         => array(
			'background-color'      => '#f3f5f6',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'output'          => array(
			array(
				'element' => '.post-type-archive-product #theme-page-header .page-header',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_post',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

// Add Info Product.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'radio-buttonset',
		'settings'  => 'position_info_product',
		'label'     => esc_html__( 'Position Info', 'azo' ),
		'section'   => 'shop_archive',
		'default'   => 'left',
		'choices'   => array(
			'left'   => esc_html__( 'Left', 'azo' ),
			'center' => esc_html__( 'Center', 'azo' ),
			'right'  => esc_html__( 'Right', 'azo' ),
		),
		'transport' => 'auto',
		'output'    => array(
			array(
				'element'  => '.content-info-product',
				'property' => 'text-align',
			),
		),
	)
);

/* FLEXIBLE SIDEBAR */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Flexible Sidebar', 'azo' ),
		'settings' => 'flexible_sidebar',
		'section'  => 'shop_archive',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
		'required' => array(
			array(
				'setting'  => 'shop_sidebar',
				'operator' => '!==',
				'value'    => 'full',
			),
		),
	)
);

/* Enable Filter Area */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'label'       => esc_html__( 'Filter Area', 'azo' ),
		'description' => esc_html__( 'Turn on to show filtering button that displays above products list.', 'azo' ),
		'settings'    => 'filter_area',
		'section'     => 'shop_archive',
		'default'     => false,
		'choices'     => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
		'required'    => array(
			array(
				'setting'  => 'shop_sidebar',
				'operator' => '===',
				'value'    => 'full',
			),
		),
	)
);

/* Enable Result Count */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'label'       => esc_html__( 'Result Count', 'azo' ),
		'description' => esc_html__( 'Turn on to show result count that displays above products list.', 'azo' ),
		'settings'    => 'result_count',
		'section'     => 'shop_archive',
		'default'     => true,
		'choices'     => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Enable Tool Product Per Page */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'label'       => esc_html__( 'Tool Product Per Page', 'azo' ),
		'description' => esc_html__( 'Turn on to tool product per page that displays above products list.', 'azo' ),
		'settings'    => 'tool_product_per_page',
		'section'     => 'shop_archive',
		'default'     => true,
		'choices'     => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Enable Sorting */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'label'       => esc_html__( 'Sorting', 'azo' ),
		'description' => esc_html__( 'Turn on to show sorting that displays above products list.', 'azo' ),
		'settings'    => 'ordering_woocommerce',
		'section'     => 'shop_archive',
		'default'     => true,
		'choices'     => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Product load more */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Product Infinite Scroll', 'azo' ),
		'settings' => 'product_load_more',
		'section'  => 'shop_archive',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);


/*Show stock bar*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Stock Bar', 'azo' ),
		'settings' => 'show_stock_bar',
		'section'  => 'shop_archive',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'radio-buttonset',
		'settings'    => 'shop_archive_wishlist',
		'label'       => esc_html__( 'Wishlist', 'azo' ),
		'description' => esc_html__( 'Turn on to display love button', 'azo' ),
		'section'     => 'shop_archive',
		'default'     => '1',
		'choices'     => array(
			'0' => esc_html__( 'Off', 'azo' ),
			'1' => esc_html__( 'On', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'radio-buttonset',
		'settings'    => 'shop_archive_quick_view',
		'label'       => esc_html__( 'Quick View', 'azo' ),
		'description' => esc_html__( 'Turn on to display quick view button', 'azo' ),
		'section'     => 'shop_archive',
		'default'     => '1',
		'choices'     => array(
			'0' => esc_html__( 'Off', 'azo' ),
			'1' => esc_html__( 'On', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'radio-buttonset',
		'settings'    => 'shop_archive_compare',
		'label'       => esc_html__( 'Compare', 'azo' ),
		'description' => esc_html__( 'Turn on to display compare button', 'azo' ),
		'section'     => 'shop_archive',
		'default'     => '1',
		'choices'     => array(
			'0' => esc_html__( 'Off', 'azo' ),
			'1' => esc_html__( 'On', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'radio-buttonset',
		'settings'    => 'shop_archive_compare',
		'label'       => esc_html__( 'Compare View', 'azo' ),
		'description' => esc_html__( 'Turn on to display compare button', 'azo' ),
		'section'     => 'shop_archive',
		'default'     => '1',
		'choices'     => array(
			'0' => esc_html__( 'Off', 'azo' ),
			'1' => esc_html__( 'On', 'azo' ),
		),
	)
);

/**
 * Space Content Product
 */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'dimensions',
		'settings'  => 'shop_style2_category',
		'label'     => esc_attr__( 'Space Content Product', 'azo' ),
		'section'   => 'shop_archive',
		'default'   => array(
			'padding-top'    => '40px',
			'padding-right'  => '24px',
			'padding-bottom' => '38px',
			'padding-left'   => '24px',
		),
		'output'    => array(
			array(
				'choice'   => 'padding-top',
				'element'  => '.content-info-product',
				'property' => 'padding-top',
			),
			array(
				'choice'   => 'padding-right',
				'element'  => '.content-info-product',
				'property' => 'padding-right',
			),
			array(
				'choice'   => 'padding-bottom',
				'element'  => '.content-info-product',
				'property' => 'padding-bottom',
			),
			array(
				'choice'   => 'padding-left',
				'element'  => ' .content-info-product',
				'property' => 'padding-left',
			),
		),
		'transport' => 'auto',
	)
);

/**
 * Color border shop hover
 */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Color Border Shop Hover', 'azo' ),
		'settings'  => 'border_shop_color',
		'section'   => 'shop_archive',
		'default'   => '#dddddd',
		'transport' => 'auto',
		'output'    => array(
			/*BORDER*/
			array(
				'element'  => array(
					'element' => '.products .product:hover',
				),
				'property' => 'border-color',
			),
		),
	)
);

/* Show category */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show category', 'azo' ),
		'settings' => 'shop_category',
		'section'  => 'shop_archive',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/**
 * Dimensions category
 */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'dimensions_category',
		'label'           => esc_html__( 'Dimension Control Category', 'azo' ),
		'section'         => 'shop_archive',
		'default'         => array(
			'margin-top'    => '0',
			'margin-bottom' => '5px',
			'margin-left'   => '0',
			'margin-right'  => '0',
		),
		'output'          => array(
			array(
				'choice'   => 'margin-top',
				'element'  => '.azo-product-cats',
				'property' => 'margin-top',
			),
			array(
				'choice'   => 'margin-bottom',
				'element'  => '.azo-product-cats',
				'property' => 'margin-bottom',
			),
			array(
				'choice'   => 'margin-left',
				'element'  => ' .azo-product-cats',
				'property' => 'margin-left',
			),
			array(
				'choice'   => 'margin-right',
				'element'  => '.azo-product-cats',
				'property' => 'margin-right',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'shop_category',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Price font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Price Shop', 'azo' ),
		'settings'  => 'typo_list_price',
		'section'   => 'shop_archive',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '700',
			'font-size'      => '18px',
			'line-height'    => '24px',
			'color'          => '#222222',
			'letter-spacing' => '0',
		),
		'output'    => array(
			array(
				'element' => array(
					'.content-info-product .price',
				),
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*Price font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Price Regular Shop', 'azo' ),
		'settings'  => 'typo_regular_list_price',
		'section'   => 'shop_archive',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '700',
			'font-size'      => '18px',
			'line-height'    => '24px',
			'color'          => '#222222',
			'letter-spacing' => '0',
		),
		'output'    => array(
			array(
				'element' => array(
					'.content-info-product .price ins',
				),
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*Price regular font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Price Regular Shop', 'azo' ),
		'settings'  => 'typo_del_list_price',
		'section'   => 'shop_archive',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '400',
			'font-size'      => '14px',
			'line-height'    => '24px',
			'color'          => '#767676',
			'letter-spacing' => '0',
		),
		'output'    => array(
			array(
				'element' => array(
					'.content-info-product .price del',
				),
			),
		),
		'choices'   => azo_custom_font(),
	)
);

// Controls the number of products display on shop archive page.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'number',
		'settings'    => 'shop_archive_number_item',
		'label'       => esc_html__( 'Number items', 'azo' ),
		'description' => esc_html__( 'Controls the number of products display on shop archive page', 'azo' ),
		'section'     => 'shop_archive',
		'default'     => 12,
		'choices'     => array(
			'min'  => 1,
			'max'  => 50,
			'step' => 1,
		),
	)
);
