<?php
/**
 * ADD SHOP SINGLE SECTION
 *
 * @package azo
 */

Azo_Kirki::add_section(
	'shop_single',
	array(
		'title'    => esc_attr__( 'Shop Single', 'azo' ),
		'panel'    => 'shop',
		'priority' => 2,
	)
);

/*LABEL Breadcrumd*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_breadcrumd_shop_single',
		'section'  => 'shop_single',
		'default'  => azo_label( esc_attr__( 'Breadcrumb Shop Single', 'azo' ) ),
	)
);

/*SHOP SINGLE NAVIGATION*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'settings'    => 'shop_single_nav',
		'label'       => esc_attr__( 'Shop single navigation', 'azo' ),
		'section'     => 'shop_single',
		'default'     => true,
		'description' => esc_attr__( 'This option available only on product page', 'azo' ),
		'choices'     => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

// Show Breadcrumb.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_breadcrumd_shop_single',
		'label'    => esc_attr__( 'Show Breadcrumb Shop Single', 'azo' ),
		'section'  => 'shop_single',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/*HEIGHT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'breadcrumd_height_single',
		'label'           => esc_attr__( 'Height', 'azo' ),
		'section'         => 'shop_single',
		'default'         => array(
			'padding-top'    => '14px',
			'padding-bottom' => '15px',
			'padding-left'   => '0',
			'padding-right'  => '0',
		),
		'output'          => array(
			array(
				'choice'   => 'padding-top',
				'element'  => '.single-product .page-header .container #theme-bread',
				'property' => 'padding-top',
			),
			array(
				'choice'   => 'padding-bottom',
				'element'  => '.single-product .page-header .container #theme-bread',
				'property' => 'padding-bottom',
			),
			array(
				'choice'   => 'padding-left',
				'element'  => ' .single-product .page-header .container #theme-bread',
				'property' => 'padding-left',
			),
			array(
				'choice'   => 'padding-right',
				'element'  => '.single-product .page-header .container #theme-bread',
				'property' => 'padding-right',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_shop_single',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Margin bottom*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'margin_bottom_breadcrumb',
		'label'           => esc_attr__( 'Space', 'azo' ),
		'section'         => 'shop_single',
		'default'         => array(
			'margin-bottom' => '0px',
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.single-product .page-header',
				'property' => 'margin-bottom',
				'choice'   => 'margin-bottom',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_shop_single',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*BACKGROUND*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'background',
		'settings'        => 'c_header_bg_single',
		'section'         => 'shop_single',
		'transport'       => 'auto',
		'default'         => array(
			'background-color'      => '#f3f5f6',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'output'          => array(
			array(
				'element' => '.single-product .page-header',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_shop_single',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Breadcrumb color*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'color',
		'settings'        => 'breadcrumb_color_single',
		'label'           => esc_attr__( 'Breadcrumb color', 'azo' ),
		'section'         => 'shop_single',
		'transport'       => 'auto',
		'default'         => '#222222',
		'output'          => array(
			array(
				'element'  => array(
					'.single-product .woocommerce-breadcrumb',
				),
				'property' => 'color',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_shop_single',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*LABEL PRODUCT GALLERY*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_product_gallery',
		'section'  => 'shop_single',
		'default'  => azo_label( esc_attr__( 'Product Gallery', 'azo' ) ),
	)
);

/*GALLERY LAYOUT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Product Gallery Layout', 'azo' ),
		'settings' => 'shop_gallery_layout',
		'section'  => 'shop_single',
		'default'  => 'horizontal',
		'choices'  => array(
			'list'       => esc_attr__( 'List', 'azo' ),
			'grid'       => esc_attr__( 'Grid', 'azo' ),
			'vertical'   => esc_attr__( 'Vertical carousel', 'azo' ),
			'horizontal' => esc_attr__( 'Horizontal carousel', 'azo' ),
			'fullall'    => esc_attr__( 'Full Width Carousel', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'select',
		'settings' => 'gallery_layout_width',
		'label'    => esc_attr__( 'Product Gallery Width Layout', 'azo' ),
		'section'  => 'shop_single',
		'default'  => 'default',
		'choices'  => array(
			'default' => esc_attr__( 'Default', 'azo' ),
			'large'   => esc_attr__( 'Large', 'azo' ),
		),
	)
);

/*LIGHTBOX*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Gallery Lightbox', 'azo' ),
		'settings' => 'gallery_lightbox',
		'section'  => 'shop_single',
		'default'  => 0,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/*Enable and disable Image Zoom*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'switch',
		'label'     => esc_html__( 'Disable & Enable Image Hover Zoom', 'azo' ),
		'settings'  => 'show_image_zoom',
		'section'   => 'shop_single',
		'default'   => 1,
		'choices'   => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
		'transport' => 'auto',
	)
);

/*Product gallery default*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'settings'    => 'product_gallery_default',
		'label'       => esc_attr__( 'Product Gallery Default', 'azo' ),
		'description' => esc_attr__( 'This option product gallery default for plugin woocommerce extension', 'azo' ),
		'section'     => 'shop_single',
		'default'     => '0',
		'choices'     => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/*LABEL PRODUCT CONTENT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_product_content',
		'section'  => 'shop_single',
		'default'  => azo_label( esc_attr__( 'Product Content', 'azo' ) ),
	)
);

/*Product Content*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Product Content', 'azo' ),
		'settings' => 'shop_layout_align',
		'section'  => 'shop_single',
		'default'  => 'left',
		'choices'  => array(
			'left'   => esc_attr__( 'Left', 'azo' ),
			'center' => esc_attr__( 'Center', 'azo' ),
		),
	)
);

/*AJAX SINGLE ADD TO CART*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Ajax single add to cart', 'azo' ),
		'settings' => 'ajax_single_atc',
		'section'  => 'shop_single',
		'default'  => 1,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/*SHOW BUTTON BUY NOW*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Sticky Button', 'azo' ),
		'settings' => 'show_sticky_button',
		'section'  => 'shop_single',
		'default'  => 0,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/*SHOW Sold Woocommerce*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Sold', 'azo' ),
		'settings' => 'show_sold',
		'section'  => 'shop_single',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

if ( defined( 'DOKAN_FILE' ) ) {
	/*Position Vendor*/
	Azo_Kirki::add_field(
		'azo',
		array(
			'type'     => 'select',
			'label'    => esc_html__( 'Position Vendor', 'azo' ),
			'settings' => 'position_vendor_align',
			'section'  => 'shop_single',
			'default'  => 'none',
			'choices'  => array(
				'after_ratting'     => esc_attr__( 'After Ratting', 'azo' ),
				'after_add_to_cart' => esc_attr__( 'After Add To Cart', 'azo' ),
				'none'              => esc_attr__( 'None', 'azo' ),
			),
		)
	);
}

/*SHOW CATEGORY*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Category', 'azo' ),
		'settings' => 'show_product_category',
		'section'  => 'shop_single',
		'default'  => 1,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/*SHOW TAG*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Tag', 'azo' ),
		'settings' => 'show_product_tag',
		'section'  => 'shop_single',
		'default'  => 1,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/*SHOW SHARE*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Share', 'azo' ),
		'settings' => 'show_share_product',
		'section'  => 'shop_single',
		'default'  => 0,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'sortable',
		'settings'        => 'social_shop_sharing_order',
		'label'           => esc_attr__( 'Order Sharing Product Single', 'azo' ),
		'description'     => esc_html__( 'Controls the order of social shop share links.', 'azo' ),
		'section'         => 'shop_single',
		'default'         => array(
			'facebook',
			'twitter',
			'pinterest',
		),
		'choices'         => array(
			'facebook'  => esc_attr__( 'Facebook', 'azo' ),
			'twitter'   => esc_attr__( 'Twitter', 'azo' ),
			'pinterest' => esc_attr__( 'Pinterest', 'azo' ),
			'linkedin'  => esc_attr__( 'Linkedin', 'azo' ),
			'tumblr'    => esc_attr__( 'Tumblr', 'azo' ),
			'email'     => esc_attr__( 'Email', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_share_product',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'radio-buttonset',
		'settings'    => 'single_product_trust_badge_enable',
		'label'       => esc_html__( 'Trust Badge', 'azo' ),
		'description' => esc_html__( 'Turn on to display the trust badge below Add to cart button.', 'azo' ),
		'section'     => 'shop_single',
		'default'     => '0',
		'choices'     => array(
			'0' => esc_html__( 'Hide', 'azo' ),
			'1' => esc_html__( 'Show', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'image',
		'settings' => 'single_product_trust_badge_image',
		'label'    => esc_html__( 'Trust Badge Image', 'azo' ),
		'section'  => 'shop_single',
		'choices'  => array(
			'save_as' => 'array',
		),
	)
);

$preset_label = esc_html__( 'Preset %1$s', 'azo' );

Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'preset',
		'settings' => 'shop_single_preset',
		'label'    => esc_html__( 'Single Layout Preset', 'azo' ),
		'section'  => 'shop_single',
		'default'  => '-1',
		'multiple' => 0,
		'choices'  => array(
			'-1' => array(
				'label'    => esc_html__( 'None', 'azo' ),
				'settings' => array(),
			),
			'01' => array(
				'label'    => sprintf( $preset_label, '01' ),
				'settings' => array(
					'product_page_sidebar_1'        => 'single_shop_sidebar',
					'product_page_sidebar_position' => 'left',
				),
			),
			'02' => array(
				'label'    => sprintf( $preset_label, '02' ),
				'settings' => array(
					'single_product_site_layout'      => 'normal',
					'single_product_image_layout'     => 'normal',
					'single_product_image_style'      => 'slider',
					'single_product_tabs_style'       => 'tabs',
					'single_product_related_position' => 'before-reviews',
				),
			),
			'03' => array(
				'label'    => sprintf( $preset_label, '03' ),
				'settings' => array(
					'single_product_site_layout'      => 'normal',
					'single_product_image_layout'     => 'normal',
					'single_product_image_style'      => 'slider',
					'single_product_tabs_style'       => 'toggles',
					'single_product_related_position' => 'before-reviews',
				),
			),
			'04' => array(
				'label'    => sprintf( $preset_label, '04' ),
				'settings' => array(
					'single_product_site_layout'    => 'normal',
					'product_page_sidebar_1'        => 'single_shop_sidebar',
					'product_page_sidebar_position' => 'right',
					'single_product_image_layout'   => 'normal',
					'single_product_image_style'    => 'slider',
					'single_product_tabs_style'     => 'toggles',
				),
			),
			'05' => array(
				'label'    => sprintf( $preset_label, '05' ),
				'settings' => array(
					'single_product_site_layout'      => 'normal',
					'product_page_sidebar_1'          => 'single_shop_sidebar2',
					'product_page_sidebar_position'   => 'right',
					'product_page_sidebar_style'      => '02',
					'single_product_image_layout'     => 'extended',
					'single_product_image_style'      => 'slider',
					'single_product_tabs_style'       => 'tabs',
					'single_product_up_sells_enable'  => '0',
					'single_product_related_position' => 'before-reviews',
				),
			),
			'06' => array(
				'label'    => sprintf( $preset_label, '06' ),
				'settings' => array(
					'single_product_site_layout' => 'wide',
					'single_product_image_style' => 'slider',
				),
			),
			'07' => array(
				'label'    => sprintf( $preset_label, '07' ),
				'settings' => array(
					'single_product_site_layout'  => 'wide',
					'single_product_image_layout' => 'wide',
					'single_product_image_style'  => 'grid',
				),
			),
		),
	)
);

/*LABEL RELATED PRODUCT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_single_related',
		'section'  => 'shop_single',
		'default'  => azo_label( esc_attr__( 'Shop Single Related', 'azo' ) ),
	)
);

/* SHOW RELATED PRODUCT */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'shop_single_related',
		'label'    => esc_attr__( 'Shop Single Related', 'azo' ),
		'section'  => 'shop_single',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);
