<?php
/**
 * SHOP HEADER LAYOUT
 *
 * @package azo
 */

// ADD PAGE HEADER SECTION.
Azo_Kirki::add_section(
	'page_shop_header',
	array(
		'title'    => esc_attr__( 'Shop Archive Extension', 'azo' ),
		'panel'    => 'shop',
		'priority' => 3,
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_slider_category',
		'section'  => 'page_shop_header',
		'default'  => azo_label( esc_attr__( 'Slider Category', 'azo' ) ),
	)
);

// Show Category Slider.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_category_slider',
		'label'    => esc_attr__( 'Show Category Slider', 'azo' ),
		'section'  => 'page_shop_header',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_shop_header',
		'section'  => 'page_shop_header',
		'default'  => azo_label( esc_attr__( 'Header', 'azo' ) ),
	)
);

// Show Shop Header.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_shop_header',
		'label'    => esc_attr__( 'Show Shop Header', 'azo' ),
		'section'  => 'page_shop_header',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/*HEIGHT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'shop_search_height',
		'label'           => esc_attr__( 'Space', 'azo' ),
		'section'         => 'page_shop_header',
		'default'         => array(
			'padding-top'    => '44px',
			'padding-bottom' => '34px',
			'padding-left'   => '50px',
			'padding-right'  => '50px',
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'choice'   => 'padding-top',
				'element'  => '.azo-pageheader-shop .box-pageheader-shop',
				'property' => 'padding-top',
			),
			array(
				'choice'   => 'padding-bottom',
				'element'  => '.azo-pageheader-shop .box-pageheader-shop',
				'property' => 'padding-bottom',
			),
			array(
				'choice'   => 'padding-left',
				'element'  => '.azo-pageheader-shop .box-pageheader-shop',
				'property' => 'padding-left',
			),
			array(
				'choice'   => 'padding-right',
				'element'  => '.azo-pageheader-shop .box-pageheader-shop',
				'property' => 'padding-right',
			),
		),
	)
);

/*BACKGROUND*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'background',
		'settings'        => 'shop_search_header_bg',
		'section'         => 'page_shop_header',
		'transport'       => 'auto',
		'default'         => array(
			'background-color'      => '#1f1d1e',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'output'          => array(
			array(
				'element' => '.azo-pageheader-shop .box-pageheader-shop',
			),
		),
	)
);

/*Shop Description*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'text',
		'label'           => esc_html__( 'Shop Description', 'azo' ),
		'settings'        => 'shop_description',
		'section'         => 'page_shop_header',
		'default'         => 'NEW ARRIVAL',
		'transport'       => 'postMessage',
		'js_vars'         => array(
			array(
				'element'  => '.shop-description',
				'function' => 'html',
			),
		),
	)
);

/*SHOP TITLE*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'text',
		'label'           => esc_html__( 'Shop Title', 'azo' ),
		'settings'        => 'shop_title_taxanomy',
		'section'         => 'page_shop_header',
		'default'         => 'GET THE PACK 20% OFF',
		'transport'       => 'postMessage',
		'js_vars'         => array(
			array(
				'element'  => '.shop-title',
				'function' => 'html',
			),
		),
	)
);

// Add Position Title.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'radio-buttonset',
		'settings'        => 'position_shop_header',
		'label'           => esc_html__( 'Position Title Control', 'azo' ),
		'section'         => 'page_shop_header',
		'default'         => 'flex-start',
		'choices'         => array(
			'flex-start' => esc_html__( 'Left', 'azo' ),
			'center'     => esc_html__( 'Center', 'azo' ),
			'flex-end'   => esc_html__( 'Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.azo-pageheader-shop .box-pageheader-shop',
				'property' => 'align-items',
			),
		),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_brand',
		'section'  => 'page_shop_header',
		'default'  => azo_label( esc_attr__( 'Brand Slider', 'azo' ) ),
	)
);

// Show Brand Slider.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_brand_slider',
		'label'    => esc_attr__( 'Show Brand Slider', 'azo' ),
		'section'  => 'page_shop_header',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);
