<?php
/**
 * Setting Shop Section
 *
 * @package azo
 */

Azo_Kirki::add_section(
	'setting_shop',
	array(
		'title'    => esc_attr__( 'General', 'azo' ),
		'panel'    => 'shop',
		'priority' => 0,
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_general',
		'section'  => 'setting_shop',
		'default'  => azo_label( esc_attr__( 'General', 'azo' ) ),
	)
);

/* Show rate */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Ratting', 'azo' ),
		'settings' => 'shop_rate',
		'section'  => 'setting_shop',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

// Rate color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'color',
		'label'           => esc_attr__( 'Ratting color', 'azo' ),
		'settings'        => 'rate_color',
		'section'         => 'setting_shop',
		'default'         => '#ffc400',
		'transport'       => 'auto',
		'output'          => array(
			/*COLOR*/
			array(
				'element'  => array(
					'.comment-form-rating .stars span:hover a',
					'.star-rating > span:before',
				),
				'property' => 'color',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'shop_rate',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*SHOW Sold By Vendor*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Sold By Vendor', 'azo' ),
		'settings' => 'show_sold_by_vendor',
		'section'  => 'setting_shop',
		'default'  => false,
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'azo' ),
			'off' => esc_attr__( 'No', 'azo' ),
		),
	)
);

/**
 * Sale Style
 */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Sale Style', 'azo' ),
		'settings' => 'shop_style_sale',
		'section'  => 'setting_shop',
		'default'  => 'stylesale2',
		'choices'  => array(
			'stylesale1' => esc_attr__( 'Style 1', 'azo' ),
			'stylesale2' => esc_attr__( 'Style 2', 'azo' ),
		),
	)
);

// Sale Color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Sale color', 'azo' ),
		'settings'  => 'sale_color',
		'section'   => 'setting_shop',
		'default'   => '#e76700',
		'transport' => 'auto',
		'output'    => array(
			/*Background*/
			array(
				'element'  => array(
					'.onsale',
				),
				'property' => 'background-color',
				'choice'   => 'color',
			),
		),
	)
);

// Hot Color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Hot color', 'azo' ),
		'settings'  => 'hot_color',
		'section'   => 'setting_shop',
		'default'   => '#00a8ff',
		'transport' => 'auto',
		'output'    => array(
			/*Background*/
			array(
				'element'  => array(
					'.hot-product',
				),
				'property' => 'background-color',
				'choice'   => 'color',
			),
		),
	)
);

// New Color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'New color', 'azo' ),
		'settings'  => 'new_color',
		'section'   => 'setting_shop',
		'default'   => '#ffb700',
		'transport' => 'auto',
		'output'    => array(
			/*Background*/
			array(
				'element'  => array(
					'.new-product',
				),
				'property' => 'background-color',
				'choice'   => 'color',
			),
		),
	)
);

// Sold out Color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Sold out color', 'azo' ),
		'settings'  => 'soldout_color',
		'section'   => 'setting_shop',
		'default'   => '#5b6684',
		'transport' => 'auto',
		'output'    => array(
			/*Background*/
			array(
				'element'  => array(
					'.azo-product-label.sold-out-label',
				),
				'property' => 'background-color',
				'choice'   => 'color',
			),
		),
	)
);

/*Title font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Title Product', 'azo' ),
		'settings'  => 'typo_title',
		'section'   => 'setting_shop',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'font-size'      => '16px',
			'variant'        => '500',
			'line-height'    => '25px',
			'color'          => '#222222',
			'letter-spacing' => '0px',
			'text-transform' => 'none',
		),
		'output'    => array(
			array(
				'element' => '.woocommerce-loop-product__title',
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*Price font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Price', 'azo' ),
		'settings'  => 'typo_price',
		'section'   => 'setting_shop',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '500',
			'font-size'      => '24px',
			'line-height'    => '24px',
			'color'          => '#222222',
			'letter-spacing' => '0',
		),
		'output'    => array(
			array(
				'element' => array(
					'.price',
				),
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*Price font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Price Regular', 'azo' ),
		'settings'  => 'typo_regular_price',
		'section'   => 'setting_shop',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '500',
			'font-size'      => '24px',
			'line-height'    => '24px',
			'color'          => '#222222',
			'letter-spacing' => '0',
		),
		'output'    => array(
			array(
				'element' => array(
					'.price ins',
				),
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*Price regular font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'label'     => esc_attr__( 'Price Regular', 'azo' ),
		'settings'  => 'typo_del_price',
		'section'   => 'setting_shop',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '400',
			'font-size'      => '18px',
			'line-height'    => '24px',
			'color'          => '#b1b1b1',
			'letter-spacing' => '0',
		),
		'output'    => array(
			array(
				'element' => array(
					'.price del',
				),
			),
		),
		'choices'   => azo_custom_font(),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_ajax_search',
		'section'  => 'setting_shop',
		'default'  => azo_label( esc_attr__( 'Search Shop Option', 'azo' ) ),
	)
);

/* ENABLE PRODUCT CATEGORIES IN SEARCH FORM */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'settings'    => 'product_cat_in_search',
		'label'       => esc_attr__( 'Enable product categories in search form', 'azo' ),
		'description' => esc_attr__( 'Search product with dropdown categories', 'azo' ),
		'section'     => 'setting_shop',
		'default'     => 'on',
		'choices'     => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/* ONLY SEARCH PRODUCT */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'product_cat_in_search',
		'label'           => esc_attr__( 'Enable product categories in search form', 'azo' ),
		'description'     => esc_attr__( 'Search product with dropdown categories', 'azo' ),
		'section'         => 'setting_shop',
		'default'         => 'on',
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'product_search',
				'operator' => '===',
				'value'    => true,
			),
		),
	)
);

/* AJAX SEARCH FOR SHOP PRODUCTS */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'ajax_search',
		'label'    => esc_attr__( 'Ajax Search for Shop Products', 'azo' ),
		'section'  => 'setting_shop',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/* AJAX SEARCH DISPLAY PRODUCT IMAGE */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'ajax_search_display_product_image',
		'label'           => esc_html__( 'Ajax Search Display Product Image', 'azo' ),
		'section'         => 'setting_shop',
		'default'         => true,
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'ajax_search',
				'operator' => '===',
				'value'    => true,
			),
		),
	)
);

/* AJAX SEARCH DISPLAY PRODUCT PRICE */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'ajax_search_display_product_price',
		'label'           => esc_html__( 'Ajax Search Display Product Price', 'azo' ),
		'section'         => 'setting_shop',
		'default'         => true,
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'ajax_search',
				'operator' => '===',
				'value'    => true,
			),
		),
	)
);

/* AJAX SEARCH DISPLAY PRODUCT EXCERPT */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'ajax_search_display_product_excerpt',
		'label'           => esc_html__( 'Ajax Search Display Product Excerpt', 'azo' ),
		'section'         => 'setting_shop',
		'default'         => false,
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'ajax_search',
				'operator' => '===',
				'value'    => true,
			),
		),
	)
);

/* LIMIT SEARCH RESULTS */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'number',
		'settings'        => 'ajax_search_limit_search_results',
		'label'           => esc_html__( 'Limit search results', 'azo' ),
		'description'     => esc_attr__( 'Enter 0 to show all', 'azo' ),
		'section'         => 'setting_shop',
		'default'         => 5,
		'choices'         => array(
			'min'  => 0,
			'max'  => 99,
			'step' => 1,
		),
		'active_callback' => array(
			array(
				'setting'  => 'ajax_search',
				'operator' => '===',
				'value'    => true,
			),
		),
	)
);

/* AJAX SEARCH DISPLAY BUTTON VIEW ALL SEARCH RESULTS */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'ajax_search_display_button_view_all_results',
		'label'           => esc_html__( 'Ajax Search Display Button View All Results', 'azo' ),
		'section'         => 'setting_shop',
		'default'         => true,
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'ajax_search',
				'operator' => '===',
				'value'    => true,
			),
		),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_free_ship',
		'section'  => 'setting_shop',
		'default'  => azo_label( esc_attr__( 'Content Bottom Sidebar Cart', 'azo' ) ),
	)
);

// Free shipping.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'textarea',
		'settings' => 'content_sidebar_cart',
		'label'    => esc_attr__( 'Content Bottom Sidebar Cart', 'azo' ),
		'section'  => 'setting_shop',
		'default'  => 'Free shipping on all orders over $75',
	)
);
