<?php
/**
 * Page Header
 *
 * @package azo
 */

// ADD PAGE HEADER LAYOUT SECTION.
Azo_Kirki::add_panel(
	'title_breadcrumb',
	array(
		'title'    => esc_attr__( 'Page Title Bar & Breadcrumb', 'azo' ),
		'priority' => 4,
	)
);

// Add Breadcrumb.
Azo_Kirki::add_section(
	'breadcrumd',
	array(
		'title'    => esc_attr__( 'Breadcrumb', 'azo' ),
		'panel'    => 'title_breadcrumb',
		'priority' => 0,
	)
);

// Show Breadcrumb.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_breadcrumd',
		'label'    => esc_attr__( 'Show Breadcrumb', 'azo' ),
		'section'  => 'breadcrumd',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

// Position Breadcrumb.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'radio-buttonset',
		'settings'        => 'position_breadcrumd',
		'label'           => esc_html__( 'Position Breadcrumb', 'azo' ),
		'section'         => 'breadcrumd',
		'default'         => 'center',
		'choices'         => array(
			'left'   => esc_html__( 'Left', 'azo' ),
			'center' => esc_html__( 'Center', 'azo' ),
			'right'  => esc_html__( 'Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.page-header .container #theme-bread',
				'property' => 'text-align',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*HEIGHT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'breadcrumd_height',
		'label'           => esc_attr__( 'Height', 'azo' ),
		'section'         => 'breadcrumd',
		'default'         => array(
			'padding-top'    => '52px',
			'padding-bottom' => '54px',
			'padding-left'   => '0',
			'padding-right'  => '0',
		),
		'output'          => array(
			array(
				'choice'   => 'padding-top',
				'element'  => '.page-header .container #theme-bread',
				'property' => 'padding-top',
			),
			array(
				'choice'   => 'padding-bottom',
				'element'  => '.page-header .container #theme-bread',
				'property' => 'padding-bottom',
			),
			array(
				'choice'   => 'padding-left',
				'element'  => ' .page-header .container #theme-bread',
				'property' => 'padding-left',
			),
			array(
				'choice'   => 'padding-right',
				'element'  => '.page-header .container #theme-bread',
				'property' => 'padding-right',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Margin bottom*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'c_height',
		'label'           => esc_attr__( 'Space', 'azo' ),
		'section'         => 'breadcrumd',
		'default'         => array(
			'margin-bottom' => '0px',
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.page-header',
				'property' => 'margin-bottom',
				'choice'   => 'margin-bottom',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*BACKGROUND*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'background',
		'settings'        => 'c_header_bg',
		'section'         => 'breadcrumd',
		'transport'       => 'auto',
		'default'         => array(
			'background-color'      => '#f3f5f6',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'output'          => array(
			array(
				'element' => '.page-header',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Breadcrumb color*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'color',
		'settings'        => 'breadcrumb_color',
		'label'           => esc_attr__( 'Breadcrumb color', 'azo' ),
		'section'         => 'breadcrumd',
		'transport'       => 'auto',
		'default'         => '#222',
		'output'          => array(
			array(
				'element'  => array(
					'.woocommerce-breadcrumb',
				),
				'property' => 'color',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
