<?php
/**
 * Navigation
 *
 * @package azo
 */

Azo_Kirki::add_panel(
	'navigation',
	array(
		'title'    => esc_attr__( 'Navigation', 'azo' ),
		'priority' => 5,
	)
);

// ADD MENU LAYOUT 1 SECTION.
Azo_Kirki::add_section(
	'header_1',
	array(
		'title'    => esc_attr__( 'Desktop Menu', 'azo' ),
		'panel'    => 'navigation',
		'priority' => 1,
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_main_menu',
		'section'  => 'header_1',
		'default'  => azo_label( esc_attr__( 'Main Menu Level 1', 'azo' ) ),
	)
);

/*parent-menu*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'settings'  => 'hd_parent_menu',
		'label'     => esc_attr__( 'Controls the typography for all menu items.', 'azo' ),
		'section'   => 'header_1',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '500',
			'font-size'      => '15px',
			'letter-spacing' => '0.3px',
			'color'          => '#222222',
		),
		'output'    => array(
			array(
				'element'     => array(
					'.theme-primary-menu > li > a',
				),
				'media_query' => '@media ( min-width: 992px )',
			),
			array(
				'element'  => array(
					'.js-search-button',
					'.menu-profile-azo',
					'a.wishlist_products_counter.top_wishlist-heart:before',
				),
				'property' => 'color',
			),
		),
	)
);

/*hover menu*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'hd1_menu_highlight',
		'label'     => esc_attr__( 'Hover color', 'azo' ),
		'section'   => 'header_1',
		'transport' => 'auto',
		'default'   => '#222222',
		'output'    => array(
			array(
				'element'  => array(
					'.theme-primary-menu li.current-menu-item > a',
					'.theme-primary-menu > li.current-menu-ancestor > a',
					'.theme-primary-menu > li.current-menu-parent > a',
					'.theme-primary-menu > li.current_page_parent > a',
					'.theme-primary-menu > li.current_page_ancestor > a',
					'.theme-primary-menu > li > a:hover',
					'.theme-primary-menu > li:hover > a',
				),
				'property' => 'color',
			),
			array(
				'element'  => array(
					'.menu-header .theme-menu-box.header-menu ul a:before',
				),
				'property' => 'background-color',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'menu_background',
		'section'   => 'header_1',
		'label'     => esc_attr__( 'Menu background level 1', 'azo' ),
		'transport' => 'auto',
		'default'   => '#ffffff',
		'output'    => array(
			array(
				'element'  => array(
					'.menu-layout.menu-layout-1.menu-layout--classic',
				),
				'property' => 'background-color',
			),
		),
	)
);


/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_main_menu_dropdown',
		'section'  => 'header_1',
		'default'  => azo_label( esc_attr__( 'Main Menu Dropdown', 'azo' ) ),
	)
);

/*sub-menu*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'settings'  => 'hd_submenu',
		'label'     => esc_attr__( 'Controls the typography for all dropdown menu items.', 'azo' ),
		'section'   => 'header_1',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '400',
			'font-size'      => '14px',
			'letter-spacing' => '0.3px',
			'text-transform' => 'none',
			'color'          => '#2F2F30',
		),
		'output'    => array(
			array(
				'element'     => array(
					'.theme-primary-menu .sub-menu a',
				),
				'media_query' => '@media ( min-width: 992px )',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'sub_menu_hover',
		'label'     => esc_attr__( 'Hover color', 'azo' ),
		'section'   => 'header_1',
		'transport' => 'auto',
		'default'   => '#ffb700',
		'output'    => array(
			array(
				'element'  => array(
					'.theme-primary-menu li ul a:hover',
					'.theme-primary-menu > li:not(.menu-item-has-mega-menu) ul a:hover',
				),
				'property' => 'color',
			),
		),
	)
);

/*background menu*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'color',
		'settings'    => 'c_menu1_bg',
		'section'     => 'header_1',
		'label'       => esc_attr__( 'Background Dropdown Menu', 'azo' ),
		'description' => esc_html__( 'Controls the background color for dropdown menu', 'azo' ),
		'transport'   => 'auto',
		'default'     => '#ffffff',
		'output'      => array(
			array(
				'element'  => array(
					'.theme-primary-menu:not(.theme-sidebar-menu) > li:not(.menu-item-has-mega-menu) ul',
					'.menu-layout--sticky',
				),
				'property' => 'background-color',
			),
		),
	)
);
