<?php
/**
 * Mobile menu
 *
 * @package azo
 */

// ADD MENU SECTION MOBILE.
Azo_Kirki::add_section(
	'header_2',
	array(
		'title'    => esc_attr__( 'Mobile Menu', 'azo' ),
		'panel'    => 'navigation',
		'priority' => 2,
	)
);

/*background menu*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'color',
		'settings'    => 'bg_mobile_menu',
		'section'     => 'header_2',
		'label'       => esc_attr__( 'Background Menu Mobile', 'azo' ),
		'description' => esc_html__( 'Controls the background color for dropdown menu', 'azo' ),
		'transport'   => 'auto',
		'default'     => '#ffffff',
		'output'      => array(
			array(
				'element'  => array(
					'#sidebar-menu-content',
				),
				'property' => 'background-color',
			),
		),
	)
);

/*sub-menu*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'typography',
		'settings'  => 'mobile_submenu',
		'label'     => esc_attr__( 'Controls the typography for all menu items mobile.', 'azo' ),
		'section'   => 'header_2',
		'transport' => 'auto',
		'default'   => array(
			'font-family'    => 'Heebo',
			'variant'        => '500',
			'font-size'      => '13px',
			'letter-spacing' => '0.26px',
			'text-transform' => 'none',
			'color'          => '#222222',
		),
		'output'    => array(
			array(
				'element' => array(
					'#sidebar-menu-content .theme-primary-menu a',
				),
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'sub_menu_mobile_hover',
		'label'     => esc_attr__( 'Hover color', 'azo' ),
		'section'   => 'header_2',
		'transport' => 'auto',
		'default'   => '#ffb700',
		'output'    => array(
			array(
				'element'  => array(
					'#sidebar-menu-content .theme-primary-menu a:hover',
				),
				'property' => 'color',
			),
		),
	)
);
