<?php
/**
 * Genaral Customize
 *
 * @package azo
 */

$section = 'c_general';
$prefix  = 'pre_loader_';

// ADD GENERAL SECTION.
Azo_Kirki::add_section(
	'c_general',
	array(
		'title'    => esc_attr__( 'General', 'azo' ),
		'priority' => 0,
	)
);

/*LOADING EFFECT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'settings'    => 'loading',
		'label'       => esc_attr__( 'Preloader', 'azo' ),
		'section'     => 'c_general',
		'default'     => false,
		'description' => esc_attr__( 'This option showing a loading animation while your site loads', 'azo' ),
		'choices'     => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'select',
		'settings'        => $prefix . 'style',
		'label'           => esc_html__( 'Style', 'azo' ),
		'section'         => $section,
		'default'         => 'circle',
		'choices'         => Azo_Helper::get_preloader_list(),
		'active_callback' => array(
			array(
				'setting'  => 'loading',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'image',
		'settings'        => 'image_preload_setting_url',
		'label'           => esc_html__( 'Image Control (URL)', 'azo' ),
		'description'     => esc_html__( 'Image preload.', 'azo' ),
		'section'         => 'c_general',
		'default'         => '',
		'transport'       => 'auto',
		'active_callback' => array(
			array(
				'setting'  => 'loading',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

// Loading text.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'text',
		'label'           => esc_html__( 'Loading Text', 'azo' ),
		'settings'        => 'loading_text',
		'section'         => 'c_general',
		'default'         => 'Boostify',
		'transport'       => 'postMessage',
		'js_vars'         => array(
			array(
				'element'  => '.azo-demo-loader',
				'function' => 'html',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'loading',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'color-alpha',
		'settings'        => $prefix . 'background_color',
		'label'           => esc_html__( 'Background Color', 'azo' ),
		'section'         => $section,
		'transport'       => 'auto',
		'default'         => '#fff',
		'output'          => array(
			array(
				'element'  => '#preloader',
				'property' => 'background-color',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'loading',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'color-alpha',
		'settings'        => $prefix . 'shape_color',
		'label'           => esc_html__( 'Shape Color', 'azo' ),
		'section'         => $section,
		'transport'       => 'auto',
		'default'         => '#ffb700',
		'output'          => array(
			array(
				'element'  => '.page-loading .sk-wrap',
				'property' => 'color',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'loading',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*SMOOTH SCROLL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'        => 'switch',
		'settings'    => 'smooth',
		'label'       => esc_attr__( 'Smooth scrolling', 'azo' ),
		'section'     => 'c_general',
		'default'     => false,
		'description' => esc_attr__( 'Smooth scrolling for the web', 'azo' ),
		'choices'     => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/* STICKY HEADER MENU */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'sticky_header',
		'label'    => esc_attr__( 'Sticky Header Menu', 'azo' ),
		'section'  => 'c_general',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

// Sticky on mobile?
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'mobile_sticky_header',
		'label'           => esc_attr__( 'Sticky On Mobile', 'azo' ),
		'section'         => 'c_general',
		'default'         => false,
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'sticky_header',
				'operator' => '==',
				'value'    => '1',
			),
		),
	)
);
