<?php
/**
 * Footer
 *
 * @package azo
 */

// ADD FOOTER SECTION.
Azo_Kirki::add_section(
	'footer',
	array(
		'title'      => esc_attr__( 'Footer', 'azo' ),
		'capability' => 'edit_theme_options',
		'priority'   => 6,
	)
);


// SHOW FOOTER.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'settings'        => 'show_footer',
		'label'           => esc_attr__( 'Show Footer', 'azo' ),
		'section'         => 'footer',
		'default'         => true,
		'choices'         => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
		'partial_refresh' => array(
			'footer_edit_location' => array(
				'selector'        => '#theme-footer',
				'render_callback' => 'azo_footer',
			),
		),
	)
);


// COLUMN.
if ( is_active_sidebar( 'footer-widget' ) ) {
	Azo_Kirki::add_field(
		'azo',
		array(
			'type'            => 'select',
			'label'           => esc_attr__( 'Column widgets', 'azo' ),
			'settings'        => 'ft_column',
			'section'         => 'footer',
			'default'         => '4',
			'transport'       => 'postMessage',
			'choices'         => array(
				'1' => 1,
				'2' => 2,
				'3' => 3,
				'4' => 4,
				'5' => 5,
				'6' => 6,
			),
			'active_callback' => array(
				array(
					'setting'  => 'show_footer',
					'operator' => '==',
					'value'    => true,
				),
			),
		)
	);
}

// LOGO.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'image',
		'settings'        => 'ft_logo',
		'section'         => 'footer',
		'label'           => esc_attr__( 'Footer Logo', 'azo' ),
		'partial_refresh' => array(
			'footer_logo' => array(
				'selector'        => '.footer-logo',
				'render_callback' => 'azo_footer_logo',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_footer',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);


// BAKGROUND.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'background',
		'settings'        => 'footer_bg',
		'section'         => 'footer',
		'transport'       => 'auto',
		'default'         => array(
			'background-color'      => '#181818',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'output'          => array(
			array(
				'element' => '#theme-footer',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_footer',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);


// COPYRIGHT.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'editor',
		'settings'        => 'ft_copyright',
		'section'         => 'footer',
		'default'         => '',
		'label'           => esc_attr__( 'Copyright', 'azo' ),
		'transport'       => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'show_footer',
				'operator' => '==',
				'value'    => true,
			),
		),
		'js_vars'         => array(
			array(
				'element'  => '#theme-footer .footer-copyright',
				'function' => 'html',
			),
		),
	)
);

// RIGHT CONTENT.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'editor',
		'settings'        => 'ft_bot_right',
		'section'         => 'footer',
		'default'         => '',
		'label'           => esc_attr__( 'Right content', 'azo' ),
		'transport'       => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'show_footer',
				'operator' => '==',
				'value'    => true,
			),
		),
		'js_vars'         => array(
			array(
				'element'  => '#theme-footer .footer-bot-right',
				'function' => 'html',
			),
		),
	)
);
