<?php
/**
 * ADD COLOR SECTION
 *
 * @package azo
 */

$section  = 'color';
$priority = 1;
$prefix   = 'color_';

Azo_Kirki::add_section(
	'color',
	array(
		'title'    => esc_attr__( 'Colors', 'azo' ),
		'priority' => 1,
	)
);

// PRIMARY COLOR.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Primary color', 'azo' ),
		'settings'  => 'primary_color',
		'section'   => 'color',
		'default'   => '#ffb700',
		'transport' => 'auto',
		'output'    => array(
			// COLOR.
			array(
				'element'  => array(
					'.blog-article .tagcloud a:hover',
					'.azo-post-related .blog-header-info .if-item a:hover',
					'.widget.widget_categories ul li:hover',
					'.widget.widget_categories ul li a:hover',
					'.widget.widget_search .search-submit:hover',
					'azo-post-related .blog-header-info a:hover',
					'.elementor-widget-wp-widget-categories ul li a:hover',
					'.elementor-widget-wp-widget-categories ul li:hover',
					'.elementor-widget-wp-widget-search .search-submit:hover',
					'.single-post .entry-footer .azo-entry-footer .tagcloud a:hover',
					'.azo-recent-post-detail .azo-recent-post-title:hover',
					'.widget-area .widget_search .wp-block-search__button:hover',
					'.widget-area .widget_categories ul li:hover',
					'.widget-area .widget_categories ul .current-cat',
					'.widget-area .widget_categories ul .current-cat a',
					'.widget-area .widget_categories ul li a:hover',
					'.info-blog-change .if-item a:hover',
					'.single-post .blog-article-header .entry-meta.blog-header-info .if-cat a:hover',
					'.elementor-widget-container .azo-entries li.azo-entry .azo-recent-post-detail .azo-recent-post-title:hover',
					'.elementor-widget-wp-widget-tag_cloud .tagcloud a:hover',
					'a:not(.woocommerce-loop-product__link):hover',
					'a:hover .autocomplete-suggestion__title',
					'.read-more-link',
					'.entry-footer .read-more',
					'.product-categories .current-cat > a',
					'.product-categories .current-cat > .count',
					'.product-categories .current-cat > .accordion-cat-toggle',
					'.form-order-label',
					'.sticky .entry-title:after',
					'.related-box .post-navigation .nav-links .meta-nav:hover',
					'.blog-article-header .entry-meta.blog-header-info .if-item a:hover',
					'.azo_widget_recent_entries ul li.azo-entry .azo-recent-post-detail .azo-recent-post-title:hover',
					'.azo-entries .azo-entry .azo-recent-post-detail .azo-recent-post-on a:hover',
					'.azo-page-header-shop-box-wrapper .azo-page-header-shop-box-content .azo-page-header-shop-box-button:hover',
					'a.wishlist_products_counter.top_wishlist-heart:hover:before',
					'.js-search-button:hover',
					'.form-contact .form-wrapper .indes .red',
					'.countdown-product .azo-countdown-item .azo-count',
					'.woocommerce-currency-switcher-form .dd-container .dd-select .dd-selected',
					'.woocommerce-MyAccount-navigation .woocommerce-MyAccount-navigation-link.is-active a',
					'.woocommerce-Reviews-title span',
					'.azo-product-navigation .wrapper-short .product-short-description .price',
					'.azo-share-product .icons .social:hover',
					'.woocommerce-grouped-product-list-item__price ins',
					'.widget-products-filter .pf-item .pf-link:hover',
					'.widget-products-filter .pf-item.active .pf-link',
					'.widget-products-filter.filter-by-button .pf-item .swatch-inner .pf-swatch-filter span:before',
					'.widget_layered_nav_filters .azo-active-filters li a:hover',
					'.widget_layered_nav_filters .azo-active-filters li.azo-clear-filter a:hover',
					'.woocommerce-loop-product__title:hover h2',
					'form.woocommerce-checkout .shop_table tfoot .order-total td .woocommerce-Price-amount bdi',
					'.woocommerce-cart .cart_totals .order-total td',
					'.info-author a:hover',
					'a:hover .woocommerce-loop-product__title',
					'.related-box .post-navigation .nav-links a:hover .azo-article-nav-text',
					'.sticky-post:after',
					'.methods input[type="radio"]:checked + label:before',
					'#shipping_method input[type="radio"]:checked + label:before',
					'#payment .wc_payment_method input[type="radio"]:checked + label:before',
					'.single .woosc-btn:hover',
					'.single .woosw-btn:hover',
					'.grouped_form td.woocommerce-grouped-product-list-item__price ins',
					'.woosw-content-item--price ins',
					'#comments .comment-info a:hover',
					'.button-read-more .btnblog-readmore:hover',
					'.form-page-contact label span',
					'.reviews-summary .stars-title .fas',
					'.is-style-outline>.wp-block-button__link:not(.has-text-color)',
				),
				'property' => 'color',
			),

			// BACKGROUND.
			array(
				'element'  => array(
					'.form-return .submit-newletter',
					'.woocommerce-form.woocommerce-form-track-order.track_order .form-row button:hover',
					'.elementor-widget-wp-widget-tag_cloud .tagcloud a:hover',
					'.form-page-contact .button-submit .submit-contact',
					'.ht-pagination .page-numbers.current',
					'.ht-pagination .page-numbers.current:hover',
					'.blog-pagination a.page-numbers:hover',
					'.ht-pagination a.page-numbers:hover',
					'.blog-pagination span.current',
					'.blog-pagination span.current:hover',
					'#sidebar-menu-content .theme-primary-menu a:before',
					'#sidebar-menu-content .theme-primary-menu a:hover:before',
					'.submit-form-order',
					'.blog-title a:before',
					'.entry-footer .read-more:hover:after',
					'.not-found .back-to-home:hover',
					'.blog-title a:before',
					'.entry-title a:before',
					'.read-more:after',
					'.azo-page-header-shop-box-wrapper .azo-page-header-shop-box-content .azo-page-header-shop-box-button',
					'.menu-layout-1 .theme-primary-menu > li.current-menu-ancestor > a:before',
					'.menu-layout-1 .theme-primary-menu > li.current-menu-parent > a:before',
					'.theme-primary-menu li.menu-item-has-children li.current_page_item a:before',
					'.form-contact .form-wrapper .submit-contact',
					'.scroll-to-top',
					'.woocommerce-store-notice',
					'.elementor-widget-wp-widget-tag_cloud .tagcloud a:hover',
					'.woocommerce-form.woocommerce-form-track-order.track_order .form-row button:hover',
					'.single .woosc-btn:hover:before',
					'.single .woosw-btn:hover:before',
					'.reviews-summary .rating-graph .percentage',
					'.nav-pro a:hover',
					'.spacenav-shop:hover',
					'.product-quick-view-btn:hover span',
					'.product-action-wishlist:hover a',
					'.product-action-compare:hover a',
					'.navigation-header',
					'.theme-primary-menu:not(.theme-sidebar-menu) li.current-menu-item >a:before',
					'.theme-primary-menu > li:not(.menu-item-has-mega-menu) ul a:hover:before',
					'.theme-primary-menu a:hover:before',
					'.theme-primary-menu >a:before',
					'.shop-cart-count',
					'.count-wishlist',
					'.menu-layout .wishlist_products_counter .wishlist_products_counter_number',
					'button:not( .search-submit, .boostify-menu-toggle-vertical, .menu-toggle-btn, .woosc-btn, .woosw-btn ):hover',
				),
				'property' => 'background-color',
			),

			// BORDER.
			array(
				'element'  => array(
					'.widget.widget_search .search-field:focus',
					'.blog-read-more:hover',
					'.entry-categories a',
					'.swatch.selected:before',
					'.p-attr-swatch.p-attr-label.active',
					'.has-default-loop-add-to-cart-button .product .button:hover',
					'.has-default-loop-add-to-cart-button .product .added_to_cart:hover',
					'.related-box .post-navigation .nav-links .meta-nav:hover',
					'.quotes',
					'.loader-circles .circle:nth-child(odd)',
					'.single-gallery-slider .pro-thumb.tns-nav-active img',
					'.wpcf7-text:focus, .wpcf7-textarea:focus',
					'.search-field:focus',
					'.woocommerce-pagination ul .page-numbers:not(.current):hover',
					'.ht-pagination a.page-numbers:hover',
					'.ht-pagination .page-numbers.current',
					'.woocommerce-pagination ul .current',
					'button:hover',
					'.is-style-outline>.wp-block-button__link:not(.has-text-color)',
				),
				'property' => 'border-color',
			),

			array(
				'element'  => array(
					'.blog-read-more:hover',
					'.woocommerce-currency-switcher-form .dd-container .dd-select .dd-pointer-down',
				),
				'property' => 'border-top-color',
			),

			array(
				'element'  => array(
					'blockquote',
				),
				'property' => 'border-left-color',
			),
		),
	)
);

// SECOND COLOR.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Second color', 'azo' ),
		'settings'  => 'second_color',
		'section'   => 'color',
		'default'   => '#ffffff',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'.crumbs .last-item span',
					'.nav-item .nav-link.active',
					'.azo-page-header-shop-box-wrapper .azo-page-header-shop-box-content .azo-page-header-shop-box-button',
					'.form-contact .form-wrapper .submit-contact',
					'.open-label-shop span',
					'input[type="button"], input[type="submit"], input[type="reset"], input[type="file"]',
					'.tns-controls [data-controls]:hover',
					'.azo-style .fade-in-block a:hover',
					'.widget_layered_nav_filters .azo-active-filters li a:hover',
					'.woocommerce-pagination ul .current',
					'.woocommerce-pagination ul .page-numbers:not(.current):hover',
					'.not-found .back-to-home',
					'.not-found .back-to-home:hover',
					'.nav-pro a:hover',
					'.spacenav-shop:hover i',
					'.scroll-to-top i',
					'.elementor-widget-wp-widget-tag_cloud .tagcloud a:hover',
					'.single .woosc-btn:hover:before',
					'.single .woosw-btn:hover:before',
					'.footer-center a:hover',
					'.product-quick-view-btn:hover span:before',
					'.product-action-wishlist:hover a:before',
					'.product-action-compare:hover a:before',
					'.onsale',
					'.footer-center a',
				),
				'property' => 'color',
			),

			/*BORDER*/
			array(
				'element'  => array(
					'.blog-article .tagcloud a:hover',
					'.wp-block-tag-cloud a:hover',
					'.widget .tagcloud a:hover',
					'.woocommerce-pagination ul a:hover',
				),
				'property' => 'border-color',
			),

			/*BACKROUND*/
			array(
				'element'  => array(
					'.woocommerce-form.woocommerce-form-track-order.track_order .form-row button',
					'.azo-page-header-shop-box-wrapper .azo-page-header-shop-box-content .azo-page-header-shop-box-button:hover',
					'.theme-primary-menu:not(.theme-sidebar-menu) > li:not(.menu-item-has-mega-menu) ul',
					'.woocommerce-form.woocommerce-form-track-order.track_order .form-row button',
				),
				'property' => 'background-color',
			),
		),
	)
);

// THIRD COLOR.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Third color', 'azo' ),
		'settings'  => 'third_color',
		'section'   => 'color',
		'default'   => '#707070',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'.azo-post-related .blog-header-info .if-item a',
					'blockquote cite',
					'.form-return input::placeholder',
					'.woocommerce-form.woocommerce-form-track-order.track_order .form-row button',
					'.elementor-widget-wp-widget-azo-recent-posts h5',
					'.elementor-widget-wp-widget-tag_cloud .tagcloud a',
					'.elementor-widget-wp-widget-search .search-submit',
					'.widget-area .widget_search .wp-block-search__button',
					'.azo-recent-post-detail .azo-recent-post-title',
					'.single-post .entry-footer .azo-entry-footer .tagcloud',
					'.single-post .entry-footer .azo-entry-footer .share-social .title-share',
					'.elementor-widget-wp-widget-categories .elementor-widget-container h5',
					'.elementor-widget-wp-widget-tag_cloud .elementor-widget-container h5',
					'.elementor-widget-wp-widget-azo-recent-posts .elementor-widget-container h5',
					'.blog-pagination .pagination span.current',
					'.product_meta > span a',
					'.product_meta > span .sku',
					'.cart-sidebar-content .woocommerce-mini-cart__total',
					'.cart-sidebar-after-cart',
					'.woocommerce-review__author',
					'.azo-product-navigation .nav-pro',
					'.product-type-variable .variations td',
					'.variations select',
					'.woocommerce-grouped-product-list-item__label a',
					'.woocommerce-grouped-product-list-item__price',
					'.quantity:not(.hidden) .modify-qty[data-click=plus]:hover',
					'.quantity:not(.hidden) .modify-qty[data-click=minus]:hover',
					'.product-action button',
					'.ht-pagination ul .current',
					'.price_slider_wrapper .price_slider_amount .price_label .from',
					'.price_slider_wrapper .price_slider_amount .price_label .to',
					'.dropdown',
					'.comments-title .text-comments',
					'.woocommerce-form.woocommerce-form-track-order.track_order .form-row button',
					'input::placeholder',
					'.grouped_form td.woocommerce-grouped-product-list-item__price del',
					'.woocommerce-tabs .tabs a',
					'.shop-top-bar .woocommerce-result-count',
					'.shop-top-bar .azo-shop-tools .azo-products-per-page .per-page-title',
					'.shop-top-bar .azo-sort-label',
				),
				'property' => 'color',
				'choice'   => 'color',
			),
			/*Border*/
			array(
				'element'  => array(
					'.variations select',
					'.price_slider_wrapper .ui-slider-handle',
					'.comment-list .children',
				),
				'property' => 'border-color',
				'choice'   => 'color',
			),
		),
	)
);

// Fourth COLOR.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Fourth color', 'azo' ),
		'settings'  => 'fourth_color',
		'section'   => 'color',
		'default'   => '#767676',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'.elementor-widget-container .widget_tag_cloud .tagcloud a',
					'.woocommerce-cart .woocommerce-cart-form thead',
					'label',
					'.methods input[type="radio"]:checked + label',
					'.woocommerce-cart .cart_totals .woocommerce-shipping-destination',
					'.woocommerce-cart .woocommerce-cart-form .actions button[type="submit"]:disabled',
					'form.woocommerce-checkout .shop_table tbody .cart_item .product-name .product-quantity',
					'#shipping_method input[type="radio"] + label:before',
					'#payment .wc_payment_method label',
					'#payment .wc_payment_method label:before',
					'.widget-area .widget .tagcloud a',
					'form.woocommerce-checkout .payment_box p, form.woocommerce-checkout .woocommerce-privacy-policy-text p',
					'.reviews-summary .reviews-count',
					'.shop-top-bar .woocommerce-ordering select',
				),
				'property' => 'color',
				'choice'   => 'color',
			),
		),
	)
);

// Link color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'link_color',
		'label'     => esc_html__( 'Link Color', 'azo' ),
		'section'   => 'color',
		'default'   => '#222222',
		'transport' => 'auto',
		'output'    => array(
			array(
				'element'  => array(
					'a',
					'.widget.widget_categories ul li',
					'.widget.widget_categories ul li a',
					'.azo-product-cats a',
					'.comment-author-name',
					'.comments-title',
					'blockquote cite strong',
					'blockquote p',
					'.elementor-widget-container .azo-entries li.azo-entry .azo-recent-post-detail .azo-recent-post-title',
					'.widget.widget_search .search-field:focus::placeholder',
					'.widget.widget_search .search-submit',
					'.form-return label',
					'.form-page-contact label',
					'.wpcf7-text:focus::placeholder, .wpcf7-textarea:focus::placeholder',
					'.reviews-summary .rating-percentage',
					'.woocommerce-Reviews .comment_container .woocommerce-review__author',
					'.woocommerce-tabs .tabs a:hover',
					'.woocommerce-tabs .tabs .active a',
					'#comments .comment-info a',
					'.ht-pagination a.page-numbers:hover',
					'.ht-pagination .page-numbers.current',
					'.ht-pagination .page-numbers.current:hover',
					'.blog-pagination a.page-numbers:hover',
					'.blog-pagination span.current',
					'.blog-pagination span.current:hover',
					'.btnblog-readmore',
					'.woocommerce-table--order-details tfoot tr:last-child td > .amount',
					'.woocommerce-table--order-details tfoot .amount',
					'.form-return .submit-newletter',
					'.form-return .submit-newletter:hover',
					'.form-page-contact .button-submit .submit-contact:hover',
					'.form-page-contact .button-submit .submit-contact:focus',
					'.form-page-contact .button-submit .submit-contact',
					'.stock.in-stock',
					'.single .woosc-btn:before',
					'.single .woosw-btn:before',
					'.reviews-summary .rating-average',
					'#shipping_method input[type="radio"]:checked + label',
					'#payment input[type="radio"]:checked + label',
					'.woocommerce-cart .cart_totals .cart-subtotal td',
					'.woocommerce-form-login-toggle .woocommerce-info',
					'.woocommerce-form-coupon-toggle .woocommerce-info',
					'.form-row > label',
					'.comment-form-comment label',
					'.comment-form-author label',
					'.comment-form-email label',
					'label span',
					'.login-azo-widget .popup-login .content-login form label',
					'input',
					'.woosc-btn',
					'.woosw-btn',
					'.title-meta-detail',
					'.sale-div .price-onsale',
					'.woocommerce-grouped-product-list-item__label a',
					'.grouped_form td.woocommerce-grouped-product-list-item__price',
					'.variations .label label',
					'.shop-top-bar .azo-shop-tools .azo-products-per-page .per-page-variation-wrap a.per-page-variation.active',
					'.shop-top-bar .azo-shop-tools .azo-products-per-page .per-page-variation-wrap a.per-page-variation:hover',
					'.is-style-outline>.wp-block-button__link:not(.has-text-color):hover',
				),
				'property' => 'color',
			),

			/*Border*/
			array(
				'element'  => array(
					'.is-style-outline>.wp-block-button__link:not(.has-text-color):hover',
				),
				'property' => 'border-color',
			),
		),
	)
);

// Link color hover.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'settings'  => 'link_color_hover',
		'label'     => esc_html__( 'Link Color Hover', 'azo' ),
		'section'   => 'color',
		'transport' => 'auto',
		'default'   => '#ffb700',
		'output'    => array(
			array(
				'element'  => array(
					'a:hover',
					'a:focus',
					'.info-blog-change .if-item a:hover, .entry-meta.blog-header-info .if-item a:hover',
					'.azo-map-overlay-info a:hover',
					'.widget_rss li a:hover',
					'.widget_recent_entries li a:hover',
					'.widget_recent_entries li a:after',
				),
				'property' => 'color',
			),
		),
	)
);
