<?php
/**
 * Button Section
 *
 * @package azo
 */

Azo_Kirki::add_section(
	'button_input',
	array(
		'title'    => esc_attr__( 'Button & Input Setting', 'azo' ),
		'priority' => 9,
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_button_color',
		'section'  => 'button_input',
		'default'  => azo_label( esc_attr__( 'Button Color', 'azo' ) ),
	)
);

// Button color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Button Color', 'azo' ),
		'settings'  => 'button_color',
		'section'   => 'button_input',
		'default'   => '#222222',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => Azo_Helper::get_button_css_selector(),
				'property' => 'color',
			),
		),
	)
);

// Button background color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Button Background Color', 'azo' ),
		'settings'  => 'button_bg_color',
		'section'   => 'button_input',
		'default'   => '#ffb700',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => Azo_Helper::get_button_css_selector(),
				'property' => 'background-color',
			),
		),
	)
);

// Button hover color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Button Hover Color', 'azo' ),
		'settings'  => 'button_hover_color',
		'section'   => 'button_input',
		'default'   => '#222222',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => Azo_Helper::get_button_hover_css_selector(),
				'property' => 'color',
			),
		),
	)
);

// Button hover background color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Button Hover Background Color', 'azo' ),
		'settings'  => 'button_bg_hover_color',
		'section'   => 'button_input',
		'default'   => '#cccccc',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => Azo_Helper::get_button_hover_css_selector(),
				'property' => 'background-color',
			),
		),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_input_color',
		'section'  => 'button_input',
		'default'  => azo_label( esc_attr__( 'Input Color', 'azo' ) ),
	)
);

// Input color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Input color', 'azo' ),
		'settings'  => 'input_background_color',
		'section'   => 'color_input',
		'default'   => '#b1b1b1',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'input',
					'textarea',
					'select:not( .orderby )',
					'select:not( .azo-search-form__product-categories )',
					'select2',
					'.select2-container .select2-selection--single',
					'.select2-container',
					'.form-row input[type="text"], .form-row input[type="tel"], .form-row input[type="email"], .form-row input[type="password"]',
					'.widget-area .search-field',
					'.search-default-azo .search-form .search-field',
				),
				'property' => 'color',
			),
		),
	)
);

// Input color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Input background color', 'azo' ),
		'settings'  => 'input_background_color',
		'section'   => 'button_input',
		'default'   => '#ffffff',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'input',
					'textarea',
					'select:not( .orderby, .azo-search-form__product-categories )',
					'select2',
					'.select2-container .select2-selection--single',
					'.select2-container',
					'.form-row input[type="text"], .form-row input[type="tel"], .form-row input[type="email"], .form-row input[type="password"]',
					'.widget-area .search-field',
					'.search-default-azo .search-form .search-field',
				),
				'property' => 'background-color',
			),
		),
	)
);

// Input border color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Input border color', 'azo' ),
		'settings'  => 'input_border_color',
		'section'   => 'button_input',
		'default'   => '#dddddd',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'input',
					'textarea',
					'select',
					'select2',
					'.select2-container .select2-selection--single',
					'.search-default-azo .search-form .search-field',
					'.select2-container',
					'.form-row textarea',
					'#commentform #comment',
					'#commentform #author, #commentform #email',
					'.wpcf7-text, .wpcf7-textarea',
					'.form-row input[type="text"], .form-row input[type="tel"], .form-row input[type="email"], .form-row input[type="password"]',
				),
				'property' => 'border-color',
			),
		),
	)
);

// Input border hover color.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'color',
		'label'     => esc_attr__( 'Input border hover color', 'azo' ),
		'settings'  => 'input_border_hover_color',
		'section'   => 'button_input',
		'default'   => '#ffb700',
		'transport' => 'auto',
		'output'    => array(
			/*COLOR*/
			array(
				'element'  => array(
					'.form-row input[type="text"]:focus,
					.form-row input[type="tel"]:focus,
					.form-row input[type="email"]:focus,
					.form-row input[type="password"]:focus',
				),
				'property' => 'border-color',
			),
		),
	)
);
