<?php
/**
 * Add Blog Section
 *
 * @package azo
 */

Azo_Kirki::add_panel(
	'blog',
	array(
		'title'    => esc_attr__( 'Blog', 'azo' ),
		'priority' => 7,
	)
);

// Add Blog archive.
Azo_Kirki::add_section(
	'blog_archive',
	array(
		'title'    => esc_attr__( 'Blog Archive', 'azo' ),
		'panel'    => 'blog',
		'priority' => 1,
	)
);

/*SIDEBAR*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'radio-image',
		'label'    => esc_html__( 'Sidebar position', 'azo' ),
		'settings' => 'blog_sidebar',
		'section'  => 'blog_archive',
		'default'  => 'full',
		'choices'  => array(
			'left'  => AZO_URI . 'images/sidebar/left.png',
			'full'  => AZO_URI . 'images/sidebar/full.png',
			'right' => AZO_URI . 'images/sidebar/right.png',
		),
	)
);

/*BLOG PRESET*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Blog Layout Preset', 'azo' ),
		'settings' => 'blog_preset',
		'section'  => 'blog_archive',
		'default'  => 'blog1',
		'choices'  => array(
			'blog1' => esc_attr__( 'Blog Preset 1', 'azo' ),
			'blog2' => esc_attr__( 'Blog Preset 2', 'azo' ),
			'blog3' => esc_attr__( 'Blog Preset 3', 'azo' ),
			'blog4' => esc_attr__( 'Blog Preset 4', 'azo' ),
		),
	)
);


/*BLOG TITLE*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'text',
		'label'     => esc_html__( 'Blog Title', 'azo' ),
		'settings'  => 'blog_title',
		'section'   => 'blog_archive',
		'default'   => 'Blog',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'element'  => '.group-blog .page-title',
				'function' => 'html',
			),
		),
	)
);

// Position Info Blog.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'radio-buttonset',
		'settings'        => 'position_info_blog',
		'label'           => esc_html__( 'Position Info Blog', 'azo' ),
		'section'         => 'blog_archive',
		'default'         => 'left',
		'choices'         => array(
			'left'   => esc_html__( 'Left', 'azo' ),
			'center' => esc_html__( 'Center', 'azo' ),
			'right'  => esc_html__( 'Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.widget-blog-post .item-blog',
				'property' => 'text-align',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'blog_preset',
				'operator' => '==',
				'value'    => 'blog2',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'blog_archive_sidebar_offset',
		'label'           => esc_html__( 'Sidebar Offset', 'azo' ),
		'description'     => esc_html__( 'Controls the offset of the sidebar when only one sidebar is present. Enter value including any valid CSS unit. For e.g: 70px. Leave blank to use global setting.', 'azo' ),
		'section'         => 'blog_archive',
		'default'         => array(
			'left'  => '35px',
			'right' => '34px',
		),
		'choices'         => array(
			'left'  => esc_attr__( 'Space Left', 'azo' ),
			'right' => esc_attr__( 'Space Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'property'    => 'padding',
				'element'     => array(
					'.blog .blog1 .col-md-4, .blog .hello-single .col-md-4, .single .blog1 .col-md-4, .single .hello-single .col-md-4, .search .blog1 .col-md-4, .search .hello-single .col-md-4',
				),
				'media_query' => '@media ( min-width: 1024px )',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'blog_sidebar',
				'operator' => '!=',
				'value'    => 'full',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'blog_archive_sidebar_top',
		'label'           => esc_html__( 'Sidebar Space Top', 'azo' ),
		'section'         => 'blog_archive',
		'default'         => array(
			'top' => '0',
		),
		'choices'         => array(
			'top' => esc_attr__( 'Space Top', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'property' => 'margin',
				'element'  => array(
					'.blog .widget-area',
				),
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'blog_sidebar',
				'operator' => '!=',
				'value'    => 'full',
			),
		),
	)
);

/* Modified excerpt length */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'number',
		'settings' => 'excerpt_length',
		'label'    => esc_html__( 'Modified excerpt length', 'azo' ),
		'section'  => 'blog_archive',
		'default'  => 32,
		'choices'  => array(
			'min'  => 1,
			'max'  => 40,
			'step' => 1,
		),
	)
);

/* Show Image Thumbnail */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Image Thumbnail', 'azo' ),
		'settings' => 'image_blog',
		'section'  => 'blog_archive',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show date */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Date', 'azo' ),
		'settings' => 'date_time_info',
		'section'  => 'blog_archive',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show Author */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Author', 'azo' ),
		'settings' => 'author_blog',
		'section'  => 'blog_archive',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show Category */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Category', 'azo' ),
		'settings' => 'category_blog',
		'section'  => 'blog_archive',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show Comment Count */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Comment Count', 'azo' ),
		'settings' => 'count_comment_blog',
		'section'  => 'blog_archive',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show Button Readmore */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'switch',
		'label'           => esc_html__( 'Show Button Readmore', 'azo' ),
		'settings'        => 'button_readmore',
		'section'         => 'blog_archive',
		'default'         => true,
		'choices'         => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'blog_preset',
				'operator' => '==',
				'value'    => 'blog1',
			),
		),
	)
);
