<?php
/**
 * Add Blog Single
 *
 * @package azo
 */

Azo_Kirki::add_section(
	'c_blog_single',
	array(
		'title'    => esc_attr__( 'Blog Single', 'azo' ),
		'panel'    => 'blog',
		'priority' => 2,
	)
);

/*LABEL Breadcrumd*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_breadcrumd_blog_single',
		'section'  => 'c_blog_single',
		'default'  => azo_label( esc_attr__( 'Breadcrumb Blog Single', 'azo' ) ),
	)
);

// Show Breadcrumb.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_breadcrumd_post',
		'label'    => esc_attr__( 'Show Breadcrumb Blog Single', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/*HEIGHT*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'breadcrumd_height_post_single',
		'label'           => esc_attr__( 'Height', 'azo' ),
		'section'         => 'c_blog_single',
		'default'         => array(
			'padding-top'    => '52px',
			'padding-bottom' => '54px',
			'padding-left'   => '0',
			'padding-right'  => '0',
		),
		'output'          => array(
			array(
				'choice'   => 'padding-top',
				'element'  => '.single-post .page-header .container #theme-bread',
				'property' => 'padding-top',
			),
			array(
				'choice'   => 'padding-bottom',
				'element'  => '.single-post .page-header .container #theme-bread',
				'property' => 'padding-bottom',
			),
			array(
				'choice'   => 'padding-left',
				'element'  => ' .single-post .page-header .container #theme-bread',
				'property' => 'padding-left',
			),
			array(
				'choice'   => 'padding-right',
				'element'  => '.single-post .page-header .container #theme-bread',
				'property' => 'padding-right',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_post',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Margin bottom*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'margin_bottom_breadcrumb_post',
		'label'           => esc_attr__( 'Space', 'azo' ),
		'section'         => 'c_blog_single',
		'default'         => array(
			'margin-bottom' => '0px',
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.single-post .page-header',
				'property' => 'margin-bottom',
				'choice'   => 'margin-bottom',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_post',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*BACKGROUND*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'background',
		'settings'        => 'c_header_bg_post_single',
		'section'         => 'c_blog_single',
		'transport'       => 'auto',
		'default'         => array(
			'background-color'      => '#f3f5f6',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'output'          => array(
			array(
				'element' => '.single-post .page-header',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_post',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*Breadcrumb color*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'color',
		'settings'        => 'breadcrumb_color_post_single',
		'label'           => esc_attr__( 'Breadcrumb color', 'azo' ),
		'section'         => 'c_blog_single',
		'transport'       => 'auto',
		'default'         => '#222222',
		'output'          => array(
			array(
				'element'  => array(
					'.single-post .woocommerce-breadcrumb',
				),
				'property' => 'color',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_breadcrumd_post',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/*LABEL SIDEBAR*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_sidebar_post',
		'section'  => 'c_blog_single',
		'default'  => azo_label( esc_attr__( 'Sidebar Blog Single', 'azo' ) ),
	)
);

/*SIDEBAR*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'radio-image',
		'label'           => esc_html__( 'Sidebar Blog Single Position', 'azo' ),
		'settings'        => 'blog_single_sidebar',
		'section'         => 'c_blog_single',
		'default'         => 'full',
		'choices'         => array(
			'left'  => AZO_URI . 'images/sidebar/left.png',
			'full'  => AZO_URI . 'images/sidebar/full.png',
			'right' => AZO_URI . 'images/sidebar/right.png',
		),
		'active_callback' => array(
			array(
				'setting'  => 'post_style',
				'operator' => '==',
				'value'    => 'poststyle1',
			),
		),
	)
);

/*BLOG SINGLE LAYOUT PRESET*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Blog Single Layout Preset', 'azo' ),
		'settings' => 'post_style',
		'section'  => 'c_blog_single',
		'default'  => 'poststyle1',
		'choices'  => array(
			'poststyle1' => esc_attr__( 'Blog Single Preset 1', 'azo' ),
			'poststyle2' => esc_attr__( 'Blog Single Preset 2', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'blog_archive_single_sidebar_offset',
		'label'           => esc_html__( 'Single Sidebar Offset', 'azo' ),
		'description'     => esc_html__( 'Controls the offset of the sidebar when only one sidebar is present. Enter value including any valid CSS unit. For e.g: 70px. Leave blank to use global setting.', 'azo' ),
		'section'         => 'c_blog_single',
		'default'         => array(
			'left'  => '45px',
			'right' => '15px',
		),
		'choices'         => array(
			'left'  => esc_attr__( 'Space Left', 'azo' ),
			'right' => esc_attr__( 'Space Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'property'    => 'padding',
				'element'     => array(
					'.single-post .widget-area',
				),
				'media_query' => '@media ( min-width: 1600px )',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'blog_single_sidebar',
				'operator' => '!=',
				'value'    => 'full',
			),

			array(
				'setting'  => 'post_style',
				'operator' => '==',
				'value'    => 'poststyle1',
			),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'dimensions',
		'settings'        => 'blog_archive_single_sidebar_top',
		'label'           => esc_html__( 'Single Sidebar Space Top', 'azo' ),
		'section'         => 'c_blog_single',
		'default'         => array(
			'top' => '0',
		),
		'choices'         => array(
			'top' => esc_attr__( 'Space Top', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'property'    => 'margin',
				'element'     => array(
					'.single-post .widget-area',
				),
				'media_query' => '@media ( min-width: 1600px )',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'blog_single_sidebar',
				'operator' => '!=',
				'value'    => 'full',
			),

			array(
				'setting'  => 'post_style',
				'operator' => '==',
				'value'    => 'poststyle1',
			),
		),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_blog_main_single',
		'section'  => 'c_blog_single',
		'default'  => azo_label( esc_attr__( 'Blog Single Main', 'azo' ) ),
	)
);

// Content padding.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'dimensions',
		'settings' => 'content_padding_post_single',
		'label'    => esc_attr__( 'Content Padding', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => array(
			'padding-top'    => '60px',
			'padding-bottom' => '41px',
			'padding-left'   => '25px',
			'padding-right'  => '25px',
		),
		'output'   => array(
			array(
				'choice'   => 'padding-top',
				'element'  => '.single .hello-single .container .row-new',
				'property' => 'padding-top',
			),
			array(
				'choice'   => 'padding-bottom',
				'element'  => '.single .hello-single .container .row-new',
				'property' => 'padding-bottom',
			),
			array(
				'choice'   => 'padding-left',
				'element'  => '.single .hello-single .container .row-new',
				'property' => 'padding-left',
			),
			array(
				'choice'   => 'padding-right',
				'element'  => '.single .hello-single .container .row-new',
				'property' => 'padding-right',
			),
		),
	)
);


// Show Title Blog Single.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_title_blog_single',
		'label'    => esc_attr__( 'Show Title Blog Single', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/*Title font*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'typography',
		'label'           => esc_attr__( 'Title Blog Single', 'azo' ),
		'settings'        => 'blog_single_header',
		'section'         => 'c_blog_single',
		'transport'       => 'auto',
		'default'         => array(
			'font-family'    => 'Heebo',
			'variant'        => '500',
			'font-size'      => '32px',
			'line-height'    => '32px',
			'color'          => '#222222',
			'letter-spacing' => '0px',
		),
		'output'          => array(
			array(
				'element' => '.single-post .blog-article-sum .entry-title',
			),
		),
		'choices'         => azo_custom_font(),
		'active_callback' => array(
			array(
				'setting'  => 'show_title_blog_single',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

// Position Title Blog Single.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'radio-buttonset',
		'settings'        => 'position_title_blog_single',
		'label'           => esc_html__( 'Position Title Blog Single', 'azo' ),
		'section'         => 'c_blog_single',
		'default'         => 'left',
		'choices'         => array(
			'left'   => esc_html__( 'Left', 'azo' ),
			'center' => esc_html__( 'Center', 'azo' ),
			'right'  => esc_html__( 'Right', 'azo' ),
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => '.single-post .blog-article-sum .entry-title',
				'property' => 'text-align',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_title_blog_single',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);


/* Show Image Thumbnail */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Image Thumbnail', 'azo' ),
		'settings' => 'image_blog_single',
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show date */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Date', 'azo' ),
		'settings' => 'date_time_info_single',
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show Category */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Category', 'azo' ),
		'settings' => 'category_blog_single',
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/* Show Comment Count */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'label'    => esc_html__( 'Show Comment Count', 'azo' ),
		'settings' => 'count_comment_blog_single',
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'on'  => esc_attr__( 'On', 'azo' ),
			'off' => esc_attr__( 'Off', 'azo' ),
		),
	)
);

/*LABEL*/
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'custom',
		'settings' => 'kirki_label_blog_single_footer',
		'section'  => 'c_blog_single',
		'default'  => azo_label( esc_attr__( 'Blog Single Footer', 'azo' ) ),
	)
);

/* SHOW TAG POST */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_tag',
		'label'    => esc_attr__( 'Tag Post', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/* SHOW SHARE POST */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_share',
		'label'    => esc_attr__( 'Share Post', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

Azo_Kirki::add_field(
	'azo',
	array(
		'type'            => 'sortable',
		'settings'        => 'social_sharing_order',
		'label'           => esc_attr__( 'Order', 'azo' ),
		'description'     => esc_html__( 'Controls the order of social share links.', 'azo' ),
		'section'         => 'c_blog_single',
		'default'         => array(
			'facebook',
			'twitter',
			'pinterest',
		),
		'choices'         => array(
			'facebook'  => esc_attr__( 'Facebook', 'azo' ),
			'twitter'   => esc_attr__( 'Twitter', 'azo' ),
			'pinterest' => esc_attr__( 'Pinterest', 'azo' ),
			'linkedin'  => esc_attr__( 'Linkedin', 'azo' ),
			'tumblr'    => esc_attr__( 'Tumblr', 'azo' ),
			'email'     => esc_attr__( 'Email', 'azo' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'show_share',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

/* Show Navigation Post */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_navigation',
		'label'    => esc_attr__( 'Navigation Post', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/* SHOW RELATED POST */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_related',
		'label'    => esc_attr__( 'Related Post', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => false,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);

/* SHOW COMMENT POST */
Azo_Kirki::add_field(
	'azo',
	array(
		'type'     => 'switch',
		'settings' => 'show_comment_post',
		'label'    => esc_attr__( 'Comment Post', 'azo' ),
		'section'  => 'c_blog_single',
		'default'  => true,
		'choices'  => array(
			'off' => esc_attr__( 'Off', 'azo' ),
			'on'  => esc_attr__( 'On', 'azo' ),
		),
	)
);
