<?php
/**
 * Add 404 Page Section
 *
 * @package azo
 */

Azo_Kirki::add_section(
	'404',
	array(
		'title'    => esc_attr__( 'Error 404 Page', 'azo' ),
		'priority' => 10,
	)
);

// Warning404.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'text',
		'label'     => esc_html__( 'Warning', 'azo' ),
		'settings'  => 'warning404',
		'section'   => '404',
		'default'   => 'Oops! Error 404',
		'transport' => 'auto',
	)
);

// Oops.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'text',
		'label'     => esc_html__( 'Oops', 'azo' ),
		'settings'  => 'not_found_oops',
		'section'   => '404',
		'default'   => 'Page Not Found',
		'transport' => 'auto',
	)
);

// Title.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'text',
		'label'     => esc_html__( 'Title', 'azo' ),
		'settings'  => 'not_found_title',
		'section'   => '404',
		'default'   => "We can't seem to find the page you're looking for. Try to use the search.",
		'transport' => 'auto',
	)
);

// Subtitle.
Azo_Kirki::add_field(
	'azo',
	array(
		'type'      => 'text',
		'label'     => esc_html__( 'Subtitle', 'azo' ),
		'settings'  => 'not_found_subtitle',
		'section'   => '404',
		'default'   => 'Or go to the home page to start over.',
		'transport' => 'auto',
	)
);
