<?php
/**
 * Helper
 *
 * @package azo
 */

defined( 'ABSPATH' ) || exit;

/**
 * Helper functions
 */
if ( ! class_exists( 'Azo_Helper' ) ) {
	/**
	 * Azo helper
	 */
	class Azo_Helper {

		static $preloader_style = array();

		function __construct() {
			self::$preloader_style = array(
				'rotating-plane'  => esc_attr__( 'Rotating Plane', 'azo' ),
				'double-bounce'   => esc_attr__( 'Double Bounce', 'azo' ),
				'three-bounce'    => esc_attr__( 'Three Bounce', 'azo' ),
				'wave'            => esc_attr__( 'Wave', 'azo' ),
				'wandering-cubes' => esc_attr__( 'Wandering Cubes', 'azo' ),
				'pulse'           => esc_attr__( 'Pulse', 'azo' ),
				'chasing-dots'    => esc_attr__( 'Chasing dots', 'azo' ),
				'circle'          => esc_attr__( 'Circle', 'azo' ),
				'cube-grid'       => esc_attr__( 'Cube Grid', 'azo' ),
				'fading-circle'   => esc_attr__( 'Fading Circle', 'azo' ),
				'folding-cube'    => esc_attr__( 'Folding Cube', 'azo' ),
				'default'         => esc_attr__( 'Default', 'azo' ),
			);
		}

		public static function get_site_layout_options() {
			$options = [
				'wide'   => esc_attr__( 'Wide', 'azo' ),
				'normal' => esc_attr__( 'Normal', 'azo' ),
			];

			return $options;
		}

		public static function e( $var = '' ) {
			echo "{$var}";
		}

		public static function get_preloader_list() {
			$list = self::$preloader_style + array( 'random' => esc_attr__( 'Random', 'azo' ) );

			return $list;
		}

		public static function get_post_meta( $name, $default = false ) {
			global $azo_page_options;

			if ( $azo_page_options != false && isset( $azo_page_options[ $name ] ) ) {
				return $azo_page_options[ $name ];
			}

			return $default;
		}

		public static function get_the_post_meta( $options, $name, $default = false ) {
			if ( $options != false && isset( $options[ $name ] ) ) {
				return $options[ $name ];
			}

			return $default;
		}

		/**
		 * @param bool $default_option
		 *
		 * @return array
		 */
		public static function get_registered_sidebars( $default_option = false, $empty_option = true ) {
			global $wp_registered_sidebars;
			$sidebars = array();
			if ( $empty_option === true ) {
				$sidebars['none'] = esc_html__( 'No Sidebar', 'azo' );
			}
			if ( $default_option === true ) {
				$sidebars['default'] = esc_html__( 'Default', 'azo' );
			}
			foreach ( $wp_registered_sidebars as $sidebar ) {
				$sidebars[ $sidebar['id'] ] = $sidebar['name'];
			}

			return $sidebars;
		}

		/**
		 * Get list sidebar positions
		 *
		 * @return array
		 */
		public static function get_list_sidebar_positions( $default = false ) {
			$positions = array(
				'left'  => esc_html__( 'Left', 'azo' ),
				'right' => esc_html__( 'Right', 'azo' ),
			);


			if ( $default === true ) {
				$positions['default'] = esc_html__( 'Default', 'azo' );
			}

			return $positions;
		}

		/**
		 * Get content of file
		 *
		 * @param string $path
		 *
		 * @return mixed
		 */
		static function get_file_contents( $path = '' ) {
			$content = '';
			if ( $path !== '' ) {
				global $wp_filesystem;

				azo_require_file_once( ABSPATH . '/wp-admin/includes/file.php' );
				WP_Filesystem();

				if ( file_exists( $path ) ) {
					$content = $wp_filesystem->get_contents( $path );
				}
			}

			return $content;
		}

		public static function strposa( $haystack, $needle, $offset = 0 ) {
			if ( ! is_array( $needle ) ) {
				$needle = array( $needle );
			}
			foreach ( $needle as $query ) {
				if ( strpos( $haystack, $query, $offset ) !== false ) {
					return true;
				} // stop on first true result
			}

			return false;
		}

		public static function w3c_iframe( $iframe ) {
			$iframe = str_replace( 'frameborder="0"', '', $iframe );
			$iframe = str_replace( 'frameborder="no"', '', $iframe );
			$iframe = str_replace( 'scrolling="no"', '', $iframe );
			$iframe = str_replace( 'gesture="media"', '', $iframe );
			$iframe = str_replace( 'allow="encrypted-media"', '', $iframe );

			return $iframe;
		}

		public static function calculate_percentage( $value1, $value2 ) {
			$percent = ( $value1 > 0 ) ? ( $value1 * 100 ) / $value2 : 0;

			return $percent;
		}

		/**
		 * @see wc_clean() Function clone from woocommerce.
		 *
		 * Clean variables using sanitize_text_field. Arrays are cleaned recursively.
		 * Non-scalar values are ignored.
		 *
		 * @param string|array $var Data to sanitize.
		 *
		 * @return string|array
		 */
		public static function data_clean( $var ) {
			if ( is_array( $var ) ) {
				return array_map( 'data_clean', $var );
			} else {
				return is_scalar( $var ) ? sanitize_text_field( $var ) : $var;
			}
		}

		public static function get_md_media_query() {
			return '@media (max-width: 1199px)';
		}

		public static function get_sm_media_query() {
			return '@media (max-width: 991px)';
		}

		public static function get_xs_media_query() {
			return '@media (max-width: 767px)';
		}

		public static function get_xs_down_media_query() {
			return '@media (max-width: 543px)';
		}

		public static function get_body_font() {
			$font = Azo::setting( 'typography_body' );

			if ( isset( $font['font-family'] ) ) {
				return "{$font['font-family']} Helvetica, Arial, sans-serif";
			}

			return 'Helvetica, Arial, sans-serif';
		}

		/**
		 * Check search page has results
		 *
		 * @return boolean true if has any results
		 */
		public static function is_search_has_results() {
			if ( is_search() ) {
				global $wp_query;
				$result = ( 0 != $wp_query->found_posts ) ? true : false;

				return $result;
			}

			return 0 != $GLOBALS['wp_query']->found_posts;
		}

		public static function get_button_typography_css_selector() {
			return '
				button,
				input[type="button"],
				input[type="reset"],
				input[type="submit"],
				.wp-block-button__link,
				.rev-btn,
				.tm-button,
				.button,
				.elementor-button
				';
		}

		public static function get_button_css_selector() {
			return '
			    button:not( .boostify-menu-toggle-vertical, .slick-arrow, .azo-arrow, .quick-view-close-btn, .menu-toggle-btn, .woosc-btn, .woosw-btn, .azo-products-tab-content .tns-nav button, .search-submit, .icoros-icon_search, .button-404 ),
				.blog-pagination span.current:after,
				.not-found .back-to-home,
				input[type="button"], input[type="submit"], input[type="reset"], input[type="file"],
				.cart .single_add_to_cart_button,
				.cart-sidebar-content .woocommerce-mini-cart__buttons .checkout,
				.price_slider_wrapper .ui-widget-header,
				.woocommerce-cart .woocommerce-cart-form .actions button[type="submit"],
				.woocommerce-cart .cart_totals .checkout-button:hover,
				button.woocommerce-button.button.woocommerce-form-login__submit,
				.checkout_coupon.woocommerce-form-coupon .button,
				button.woocommerce-Button.woocommerce-button.button.woocommerce-form-register__submit,
				.woocommerce-account .edit-account .button.woocommerce-Button.button,
				.woocommerce-account .woocommerce-address-fields .button,
				.azo-style .product-information .fade-in-block a,
				#place_order:hover,
				.tinv-wishlist .tinvwl-buttons-group button,
				.woocommerce-cart .cart_totals .checkout-button,
				#place_order,
				.woocommerce-pagination ul .current,
				.woocommerce-pagination ul .page-numbers:not(.current):hover,
				.woocommerce-cart .woocommerce-cart-form .actions button[type="submit"]:hover:disabled,
				.woocommerce-form.woocommerce-form-track-order.track_order .form-row button,
				.woocommerce-message .button:hover,
				#woosw_copy_btn,
				.woosc-area .woosc-inner .woosc-table .woosc-table-inner .woosc-table-items .button,
				.woosw-list .button,
				.woosw-area.woosw-area .woosw-content .button,
				.wp-block-button__link
				';
		}

		public static function get_button_hover_css_selector() {
			return '
				button:not( .boostify-menu-toggle-vertical, .slick-arrow, .azo-arrow, .quick-view-close-btn, .menu-toggle-btn, .woosc-btn, .woosw-btn, .azo-products-tab-content .tns-nav button, .arrows-next, .arrows-prev, .search-submit, .icoros-icon_search ):hover,
				.blog-pagination span.current:after,
				.not-found .back-to-home:hover,
				.cart-sidebar-content .woocommerce-mini-cart__buttons .checkout:hover,
				.price_slider_wrapper .ui-widget-header:hover,
				.woocommerce-cart .woocommerce-cart-form .actions button[type="submit"]:hover,
				button.woocommerce-button.button.woocommerce-form-login__submit:hover,
				.checkout_coupon.woocommerce-form-coupon .button:hover,
				button.woocommerce-Button.woocommerce-button.button.woocommerce-form-register__submit:hover,
				.woocommerce-account .edit-account .button.woocommerce-Button.button:hover,
				.woocommerce-account .woocommerce-address-fields .button:hover,
				.azo-style .product-information .fade-in-block a:hover,
				#commentform #submit:hover,
				.cart .single_add_to_cart_button:hover,
				.cart-sidebar-content .woocommerce-mini-cart__buttons .checkout:hover,
				.sidebar-action-cart,
				#page-loader #nprogress .ba,
				scroll-to-top,
				.form-contact-wrapp .submit-form,
				ul.products li.product .tinvwl_add_to_wishlist_button:hover,
				.woocommerce-loop-product__title:after,
				.woocommerce-address-fields .button,
				.footer-subscribe-form button,
				.widget.widget_shopping_cart .woocommerce-mini-cart__buttons a,
				.price_slider_wrapper .price_slider_amount button,
				.shop-sidebar .woocommerce-widget-layered-nav-dropdown__submit,
				.woocommerce-cart .woocommerce-cart-form .actions button[type="submit"]:hover,
				.woocommerce-form-login button[type="submit"],
				.woocommerce-form-register button[type="submit"],
				.woocommerce-form-coupon button[type="submit"],
				.woocommerce-MyAccount-content .woocommerce-EditAccountForm button[type="submit"],
				.flash-sale-atc a,
				.woocommerce-cart .woocommerce-shipping-calculator button[type="submit"],
				.lost_reset_password button[type="submit"],
				.has-product-load-more-button .load-more-product-btn,
				.tinvwl-table-manage-list button:hover,
				.azo-lightbox-zoom-button:hover,
				.azo-lightbox-button:hover,
				.tns-controls [data-controls]:hover,
				.widget_layered_nav_filters .azo-active-filters li:not(.azo-clear-filter) a:hover,
				.button:active,
				#place_order:hover,
				button.woocommerce-button.button.woocommerce-form-login__submit:hover,
				.checkout_coupon.woocommerce-form-coupon .button:hover,
				button.woocommerce-Button.woocommerce-button.button.woocommerce-form-register__submit:hover,
				.woocommerce-account .edit-account .button.woocommerce-Button.button:hover,
				.woocommerce-account .woocommerce-address-fields .button:hover,
				#commentform #submit:hover,
				.form-newletter-newletter-gadget .submit-newletter:hover,
				.wpcf7-form-control.wpcf7-submit.submit-contact:hover,
				.tinv-wishlist .tinvwl-buttons-group button:hover,
				.woocommerce-cart .cart_totals .checkout-button:hover,
				.woocommerce-cart .woocommerce-cart-form .actions button[type="submit"]:disabled,
				.woocommerce-form.woocommerce-form-track-order.track_order .form-row button:hover,
				#commentform .attachment-button:hover,
				.single-product .azo-wc-question .form-submit input:hover,
				.woocommerce-message .button,
				#woosw_copy_btn:hover,
				.login-azo-widget .popup-login .content-login form .login-submit input:hover,
				.woosc-area .woosc-inner .woosc-table .woosc-table-inner .woosc-table-items .button:hover,
				.woosw-list .button:hover,
				.woosw-area.woosw-area .woosw-content .button:hover,
				.form-return .submit-newletter:hover,
				.form-page-contact .button-submit .submit-contact:hover,
				.form-page-contact .button-submit .submit-contact:focus,
				.wp-block-button__link:hover,
				a.wp-block-button__link:hover,
				.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:hover:not(.has-background)
				';
		}

		public static function get_form_input_typography_css_selector() {
			return "
			input[type='text'],
			input[type='email'],
			input[type='url'],
			input[type='password'],
			input[type='search'],
			input[type='number'],
			input[type='tel'],
			select,
			textarea,
			.woocommerce .select2-container--default .select2-selection--single,
			.woocommerce .select2-container--default .select2-search--dropdown .select2-search__field,
			.elementor-field-group .elementor-field-textual
		";
		}

		public static function get_form_input_css_selector() {
			return "
			input[type='text'],
			input[type='email'],
			input[type='url'],
			input[type='password'],
			input[type='search'],
			input[type='number'],
			input[type='tel'],
			select,
			textarea,
			.elementor-field-group .elementor-field-textual
		";
		}

		public static function get_form_input_focus_css_selector() {
			return "
			input[type='text']:focus,
			input[type='email']:focus,
			input[type='url']:focus,
			input[type='password']:focus,
			input[type='search']:focus,
			input[type='number']:focus,
			input[type='tel']:focus,
			textarea:focus, select:focus,
			select:focus,
			textarea:focus,
			.elementor-field-group .elementor-field-textual:focus
		";
		}

		public static function is_page_template( $template_file ) {
			$template_full = 'templates/' . $template_file;

			return is_page_template( $template_full );
		}

		public static function get_all_pages() {
			$options = [
				0 => esc_html__( 'Select a page', 'azo' ),
			];

			$pages = get_pages();

			if ( $pages ) {
				foreach ( $pages as $page ) {
					$options [ $page->ID ] = $page->post_title;
				}
			}

			return $options;
		}
	}

	new Azo_Helper();
}
