<?php
/**
 * Functions
 *
 * @package azo
 */

define( 'AZO_VERSION', '1.0' );
define( 'AZO_DIR', get_template_directory() . '/' );
define( 'AZO_URI', get_template_directory_uri() . '/' );

/*THEME INCLUDES*/
require AZO_DIR . 'inc/init.php';

/*TGM PLUGIN*/
require AZO_DIR . 'tgm-plugin/recommend-plugins.php';

/*KIRKI PLUGIN*/
require AZO_DIR . 'inc/kirki-fallback.php';

/*CUSTOMIZE*/
require AZO_DIR . 'inc/customizer.php';

/*ENQUEUE*/
require AZO_DIR . 'inc/enqueue.php';

/*ELEMENTOR*/
require AZO_DIR . 'inc/elementor.php';

/*WOOCOMMERCE*/
require AZO_DIR . 'inc/woocommerce.php';

/**
 * Admin Style
 */
function azo_admin_style() {
	wp_enqueue_style(
		'azo-admin-style',
		AZO_URI . 'css/custom.css',
		array(),
		AZO_VERSION
	);
}
add_action( 'admin_enqueue_scripts', 'azo_admin_style' );

/**
 * CUSTOMIZE
 */
function azo_customizer_live_preview() {
	wp_enqueue_script(
		'azo-customize-preview',
		AZO_URI . 'js/customize-preview.js',
		array(),
		AZO_VERSION,
		true
	);
}
add_action( 'customize_preview_init', 'azo_customizer_live_preview' );


/* ELEMENTOR*/

/**
 * FOR WIDGET
 */
function azo_register_script_file() {
	wp_register_script(
		'tiny-slider',
		AZO_URI . 'js/tiny-slider.js',
		array(),
		AZO_VERSION,
		true
	);
}
add_action( 'elementor/frontend/after_register_scripts', 'azo_register_script_file' );

/**
 * THEME STATIC
 */
function azo_static() {
	/*MAIN STYLESHEET*/
	wp_enqueue_style(
		'azo-theme-style',
		get_stylesheet_uri(),
		array(),
		AZO_VERSION
	);

	/*COMMENT REPLY SCRIPT*/
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	/*PRODUCT ZOOM*/
	wp_register_script(
		'easyzoom',
		AZO_URI . 'js/easyzoom.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'easyzoom-handle',
		AZO_URI . 'js/easyzoom-handle.js',
		array( 'jquery', 'easyzoom' ),
		AZO_VERSION,
		true
	);

	/*PLYR: SUPPORT FOR IE*/
	wp_register_script(
		'plyr-polyfill',
		AZO_URI . 'js/plyr-polyfill.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_register_script(
		'plyr-script',
		AZO_URI . 'js/plyr.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_register_style(
		'plyr-style',
		AZO_URI . 'css/plyr.css',
		array(),
		AZO_VERSION
	);

	/*STICKY SIDEBAR*/
	wp_register_script(
		'sticky-sidebar',
		AZO_URI . 'js/sticky-sidebar.js',
		array(),
		AZO_VERSION,
		true
	);

	/*TESTIMONIAL SLIDER*/
	wp_register_script(
		'azo-testimonial',
		AZO_URI . 'js/testimonial.js',
		array(),
		AZO_VERSION,
		true
	);

	/*TINY SLIDER*/
	wp_enqueue_script(
		'tiny-slider',
		AZO_URI . 'js/tiny-slider.js',
		array(),
		AZO_VERSION,
		true
	);

	/*COUNTDOWN*/
	wp_register_script(
		'countdown',
		AZO_URI . 'js/countdown.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_enqueue_script(
		'azo-product-images',
		AZO_URI . 'js/azo-product-images.js',
		array( 'jquery', 'wc-add-to-cart-variation', 'tiny-slider' ),
		AZO_VERSION,
		true
	);

	/*PHOTO SWIPE*/
	if ( true === get_theme_mod( 'gallery_lightbox', false ) ) {
		wp_register_script(
			'photoswipe-init',
			AZO_URI . 'js/photoswipe-init.js',
			array( 'photoswipe', 'photoswipe-ui-default' ),
			AZO_VERSION,
			true
		);
	}

	/*LITY LIGHBOX*/
	wp_register_script(
		'lity-script',
		AZO_URI . 'js/lity.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_register_style(
		'lity-style',
		AZO_URI . 'css/lity.css',
		array(),
		AZO_VERSION
	);

	/*COUNTDOWN*/
	wp_register_script(
		'countdown',
		AZO_URI . 'js/azo-countdown.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_enqueue_style(
		'isotope-style',
		AZO_URI . 'css/isotope-docs.css',
		array(),
		AZO_VERSION
	);

	/*SMOOTH SCROLL*/
	if ( true === get_theme_mod( 'smooth', false ) ) {
		wp_enqueue_script(
			'smoothscroll',
			AZO_URI . 'js/smoothscroll.js',
			array(),
			AZO_VERSION,
			true
		);
	}

	/*GLOBAL WC CART VARIATION*/
	if ( wp_script_is( 'wc-add-to-cart-variation', 'registered' ) && ! wp_script_is( 'wc-add-to-cart-variation', 'enqueued' ) ) {
		wp_enqueue_script( 'wc-add-to-cart-variation' );
	}

	/*CLASS LIST ADD MULTI CLASS FOR IE*/
	if ( true === azo_ie() ) {
		wp_enqueue_script(
			'polyfill-class-list',
			AZO_URI . 'js/polyfill-class-list.js',
			array(),
			AZO_VERSION,
			true
		);

		wp_enqueue_script(
			'polyfill-fetch-api',
			AZO_URI . 'js/polyfill-fetch-api.js',
			array(),
			AZO_VERSION,
			true
		);
	}

	/*PRELOADER*/
	if ( true === get_theme_mod( 'loading', false ) ) {
		wp_enqueue_script(
			'nprogress',
			AZO_URI . 'js/nprogress.js',
			array( 'jquery' ),
			AZO_VERSION,
			true
		);
	}

	/*ISOTOPE*/
	wp_enqueue_script(
		'isotope',
		AZO_URI . 'js/isotope.pkgd.min.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);

	/* jQuery Autocomplete */
	wp_enqueue_script(
		'azo-autocomplete-script',
		AZO_URI . 'js/autocomplete.min.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_localize_script(
		'azo-autocomplete-script',
		'global',
		array(
			'url'   => admin_url( 'admin-ajax.php' ),
			'nonce' => wp_create_nonce( 'search_nonce' ),
		)
	);

	// Category archive slider.
	wp_enqueue_script(
		'azo-category-product-slider',
		AZO_URI . 'js/azo-category-product-slider.js',
		array( 'slick' ),
		AZO_VERSION,
		true
	);

	// Category related slider.
	wp_enqueue_script(
		'azo-slider-related',
		AZO_URI . 'js/azo-slider-related.js',
		array( 'slick' ),
		AZO_VERSION,
		true
	);

	// Brand archive slider.
	wp_enqueue_script(
		'azo-brand-product-slider',
		AZO_URI . 'js/azo-brand-product-slider.js',
		array( 'slick' ),
		AZO_VERSION,
		true
	);

	// Slick.
	wp_register_style(
		'slick',
		AZO_URI . 'css/slick.css',
		array(),
		AZO_VERSION
	);
	wp_register_script(
		'slick',
		AZO_URI . 'js/slick.min.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);

	// Disable auto zoom on mobile.
	wp_enqueue_script(
		'azo-disable-auto-zoom-on-ios',
		AZO_URI . 'js/disable-auto-zoom-on-mobile.js',
		array(),
		AZO_VERSION,
		true
	);

	wp_enqueue_script(
		'azo-ajax-product-filter',
		AZO_URI . 'js/azo-ajax-product-filter.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);

	if ( defined( 'WC_PLUGIN_FILE' ) ) {
		wp_localize_script(
			'azo-ajax-product-filter',
			'azo_ajax_shop_filter',
			array(
				'home_url' => home_url( '/' ),
				'shop_url' => wc_get_page_permalink( 'shop' ),
			)
		);
	}

	/*CUSTOM SCRIPT*/
	wp_enqueue_script(
		'azo-custom',
		AZO_URI . 'js/azo-custom.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);

	if ( get_theme_mod( 'ajax_search', false ) ) {
		wp_localize_script(
			'azo-custom',
			'azo_ajax_search',
			array(
				'limit_search_results' => get_theme_mod( 'ajax_search_limit_search_results', 5 ),
				'display_image'        => get_theme_mod( 'ajax_search_display_product_image', true ),
				'display_price'        => get_theme_mod( 'ajax_search_display_product_price', true ),
				'display_excerpt'      => get_theme_mod( 'ajax_search_display_product_excerpt', false ),
				'btn_view_all'         => get_theme_mod( 'ajax_search_display_button_view_all_results', true ),
				'btn_view_all_txt'     => esc_html__( 'View All Results', 'azo' ),
			)
		);
	}

	wp_enqueue_script(
		'azo-product-questions',
		AZO_URI . 'js/azo-product-questions.js',
		array( 'jquery' ),
		AZO_VERSION,
		true
	);

	$js_variables = array(
		'ajaxurl'    => admin_url( 'admin-ajax.php' ),
		'nonce'      => wp_create_nonce( 'azo-security' ),
		'isSingle'   => is_singular(),
		'postType'   => get_post_type(),
		'alertTitle' => esc_html__( 'Notice!', 'azo' ),
	);
	wp_localize_script( 'azo-product-questions', 'azo_product_questions', $js_variables );
}
add_action( 'wp_enqueue_scripts', 'azo_static' );

/**
 * Register Elementor locations
 *
 * @param array $elementor_theme_manager  The elementor theme manager.
 */
function azo_theme_register_elementor_locations( $elementor_theme_manager ) {
	$elementor_theme_manager->register_location(
		'header',
		array(
			'hook'         => 'azo_theme_header',
			'remove_hooks' => array( 'azo_theme_print_elementor_header' ),
		)
	);
	$elementor_theme_manager->register_location(
		'footer',
		array(
			'hook'         => 'azo_theme_footer',
			'remove_hooks' => array( 'azo_theme_print_elementor_footer' ),
		)
	);
	$elementor_theme_manager->register_location(
		'single',
		array(
			'hook'         => 'azo_theme_single',
			'remove_hooks' => array( 'azo_theme_print_elementor_single' ),
		)
	);
	$elementor_theme_manager->register_location(
		'product_archive',
		array(
			'hook'         => 'azo_theme_archive',
			'remove_hooks' => array( 'azo_theme_print_elementor_archive' ),
		)
	);
}
add_action( 'elementor/theme/register_locations', 'azo_theme_register_elementor_locations' );

/**
 * Header
 */
function azo_theme_print_elementor_header() {
	get_template_part( 'template-parts/header' );
}
add_action( 'azo_theme_header', 'azo_theme_print_elementor_header' );

/**
 * Footer
 */
function azo_theme_print_elementor_footer() {
	get_template_part( 'template-parts/footer' );
}
add_action( 'azo_theme_footer', 'azo_theme_print_elementor_footer' );

/**
 * Single
 */
function azo_theme_print_elementor_single() {
	get_template_part( 'template-parts/single' );
}
add_action( 'azo_theme_single', 'azo_theme_print_elementor_single' );

/**
 * Archive
 */
function azo_theme_print_elementor_archive() {
	get_template_part( 'template-parts/archive' );
}
add_action( 'azo_theme_archive', 'azo_theme_print_elementor_archive' );


/**
 * Register custom query vars
 *
 * @param array $vars The array of available query variables.
 */
function azo_register_query_vars( $vars ) {
	$vars[] = 'menu_layout';

	return $vars;
}
add_filter( 'query_vars', 'azo_register_query_vars' );

/**
 * Azo unset query vars
 *
 * @param  [type] $query_vars type.
 */
function azo_unset_query_vars( $query_vars ) {
	global $wp_query, $wp;

	if ( ! $wp_query->is_main_query() ) {
		return $query_vars;
	}

	$qv_keys = array_keys( $wp->query_vars );

	if ( ! ( in_array( 'pagename', $qv_keys, true ) ) ) {
		unset( $query_vars['menu_layout'] );
	}

	return $query_vars;
}
add_filter( 'request', 'azo_unset_query_vars' );


add_filter( 'loop_shop_per_page', 'azo_loop_shop_per_page', 20 );
/**
 * Set shop looop product per page
 *
 * @param int $cols Column.
 *
 * @return mixed
 */
function azo_loop_shop_per_page( $cols ) {
	// $cols contains the current number of products per page based on the value stored on Options -> Reading
	// Return the number of products you wanna show per page.
	if ( isset( $_GET['per_page'] ) ) {
		$cols = $_GET['per_page'];
	}

	return $cols;
}

/**
 * Deactivate new block editor
 */
function azo_theme_support() {
	remove_theme_support( 'widgets-block-editor' );
}
add_action( 'after_setup_theme', 'azo_theme_support' );
